/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmIdClassReference;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlClassReference;
import org.eclipse.jpt.core.resource.orm.XmlIdClassContainer;
import org.eclipse.jpt.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmIdClassReference
extends AbstractXmlContextNode
implements OrmIdClassReference {
    protected String specifiedIdClassName = this.buildSpecifiedIdClassName();
    protected String defaultIdClassName;
    protected JavaPersistentType idClass;

    public GenericOrmIdClassReference(OrmTypeMapping parent, JavaIdClassReference javaIdClassReference) {
        super(parent);
        this.defaultIdClassName = this.buildDefaultIdClassName(javaIdClassReference);
        this.idClass = this.buildIdClass();
    }

    protected OrmTypeMapping getTypeMapping() {
        return (OrmTypeMapping)this.getParent();
    }

    protected OrmPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public String getSpecifiedIdClassName() {
        return this.specifiedIdClassName;
    }

    @Override
    public void setSpecifiedIdClassName(String newClassName) {
        String oldClassName = this.specifiedIdClassName;
        this.specifiedIdClassName = newClassName;
        if (this.valuesAreDifferent(oldClassName, newClassName)) {
            if (this.getIdXmlClassRef() != null) {
                this.getIdXmlClassRef().setClassName(newClassName);
                if (this.getIdXmlClassRef().isUnset()) {
                    this.removeIdClassElement();
                }
            } else if (newClassName != null) {
                this.addIdClassElement();
                this.getIdXmlClassRef().setClassName(newClassName);
            }
        }
        this.firePropertyChanged("specifiedIdClassName", oldClassName, newClassName);
    }

    protected void setSpecifiedIdClassName_(String newClassName) {
        String oldClassName = this.specifiedIdClassName;
        this.specifiedIdClassName = newClassName;
        this.firePropertyChanged("specifiedIdClassName", oldClassName, newClassName);
    }

    protected String buildSpecifiedIdClassName() {
        XmlClassReference idXmlClassRef = this.getIdXmlClassRef();
        return idXmlClassRef == null ? null : idXmlClassRef.getClassName();
    }

    @Override
    public String getDefaultIdClassName() {
        return this.defaultIdClassName;
    }

    protected void setDefaultIdClassName_(String newClassName) {
        String oldClassName = this.defaultIdClassName;
        this.defaultIdClassName = newClassName;
        this.firePropertyChanged("defaultIdClassName", oldClassName, newClassName);
    }

    protected String buildDefaultIdClassName(JavaIdClassReference javaIdClassReference) {
        return javaIdClassReference == null ? null : javaIdClassReference.getFullyQualifiedIdClassName();
    }

    @Override
    public String getIdClassName() {
        return this.specifiedIdClassName == null ? this.defaultIdClassName : this.specifiedIdClassName;
    }

    @Override
    public boolean isSpecified() {
        return this.getIdClassName() != null;
    }

    @Override
    public JavaPersistentType getIdClass() {
        return this.idClass;
    }

    protected void setIdClass_(JavaPersistentType newIdClass) {
        JavaPersistentType oldIdClass = this.idClass;
        this.idClass = newIdClass;
        this.firePropertyChanged("idClass", oldIdClass, newIdClass);
    }

    protected JavaPersistentType buildIdClass() {
        JavaResourcePersistentType resourceIdClass = this.getResourceIdClass();
        return resourceIdClass == null ? null : this.buildIdClass(resourceIdClass);
    }

    protected JavaPersistentType buildIdClass(JavaResourcePersistentType resourceClass) {
        return this.getJpaFactory().buildJavaPersistentType(this, resourceClass);
    }

    protected XmlTypeMapping getResourceTypeMapping() {
        return this.getTypeMapping().getResourceTypeMapping();
    }

    protected XmlIdClassContainer getResourceIdClassContainer() {
        return (XmlIdClassContainer)((Object)this.getResourceTypeMapping());
    }

    protected XmlClassReference getIdXmlClassRef() {
        return this.getResourceIdClassContainer().getIdClass();
    }

    protected void addIdClassElement() {
        this.getResourceIdClassContainer().setIdClass(OrmFactory.eINSTANCE.createXmlClassReference());
    }

    protected void removeIdClassElement() {
        this.getResourceIdClassContainer().setIdClass(null);
    }

    protected JavaResourcePersistentType getResourceIdClass() {
        XmlClassReference idXmlClassRef = this.getIdXmlClassRef();
        if (idXmlClassRef == null) {
            return null;
        }
        String className = idXmlClassRef.getClassName();
        if (className == null) {
            return null;
        }
        return this.getEntityMappings().resolveJavaResourcePersistentType(className);
    }

    protected EntityMappings getEntityMappings() {
        return (EntityMappings)this.getMappingFileRoot();
    }

    @Override
    public char getIdClassEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public void update(JavaIdClassReference javaIdClassReference) {
        this.setDefaultIdClassName_(this.buildDefaultIdClassName(javaIdClassReference));
        this.setSpecifiedIdClassName_(this.buildSpecifiedIdClassName());
        this.updateIdClass();
    }

    protected void updateIdClass() {
        JavaResourcePersistentType resourceIdClass = this.getResourceIdClass();
        if (resourceIdClass == null) {
            this.setIdClass_(null);
        } else if (this.idClass == null || this.idClass.getResourcePersistentType() != resourceIdClass) {
            this.setIdClass_(this.buildIdClass(resourceIdClass));
        } else {
            this.idClass.update(resourceIdClass);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        XmlClassReference idXmlClassRef = this.getIdXmlClassRef();
        return idXmlClassRef == null ? this.getTypeMapping().getValidationTextRange() : idXmlClassRef.getClassNameTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
    }
}

