/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.impl;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.internal.impl.KeyRelationshipRoleFilter;
import org.eclipse.jst.j2ee.ejb.internal.impl.ModelledKeyAttributeFilter;
import org.eclipse.jst.j2ee.ejb.internal.impl.RoleShapeStrategy;

public class EJB20FlattenedRoleShapeStrategy
extends RoleShapeStrategy {
    public EJB20FlattenedRoleShapeStrategy(CommonRelationshipRole aRole) {
        super(aRole);
    }

    protected boolean canContinue() {
        return !this.busy && this.role.getName() != null && (this.role.isForward() || this.role.isMany() && (this.role.getOppositeAsCommonRole() == null || this.role.getOppositeAsCommonRole().isMany()));
    }

    public boolean usesAttributeNamed(String attributeName) {
        if (attributeName != null) {
            int index = attributeName.indexOf("_");
            String name = attributeName.substring(0, index);
            return this.getRole().getName().equals(name);
        }
        return false;
    }

    protected void reconcileAttributes(CommonRelationshipRole aRole, String attributeName, List aList, List computedNames) {
        Resource res = aRole.eResource();
        boolean dirtyFlag = res != null ? res.isModified() : false;
        try {
            ContainerManagedEntity entity;
            if (aRole.getOppositeAsCommonRole() != null && (entity = aRole.getOppositeAsCommonRole().getSourceEntity()) != null) {
                this.collectAttributes(entity, attributeName, aList, computedNames);
            }
        }
        finally {
            if (res != null) {
                res.setModified(dirtyFlag);
            }
        }
    }

    protected void setDerivedAttributeType(CMPAttribute attribute, CMPAttribute targetAttribute, boolean isNew) {
        if (targetAttribute == null) {
            return;
        }
        JavaHelpers fieldType = targetAttribute.getType();
        if (fieldType != null) {
            int singleRoleNameSize = this.getRole().getName().length() + targetAttribute.getName().length() + 1;
            if (attribute.getName().length() <= singleRoleNameSize) {
                attribute.setOriginatingType(fieldType);
            }
            attribute.setEType((EClassifier)fieldType.getWrapper());
        }
        if (isNew && !this.getRole().isKey()) {
            attribute.setDerived(true);
        }
    }

    protected void collectAttributes(ContainerManagedEntity type, String attributeName, List aList, List computedNames) {
        this.collectKeyModelledAttributes(type, attributeName, aList, computedNames);
        this.collectKeyRoleAttributes(type, attributeName, aList, computedNames);
    }

    protected void collectAttributes(CMPAttribute type, String attributeName, List aList, List computedNames) {
        ContainerManagedEntity entity = (ContainerManagedEntity)type.eContainer();
        this.collectAttributes(entity, type, attributeName, aList, computedNames);
    }

    protected void collectAttributes(ContainerManagedEntity entity, CMPAttribute type, String attributeName, List aList, List computedNames) {
        boolean isNewAttribute = false;
        attributeName = this.appendName(attributeName, type.getName());
        computedNames.add(attributeName);
        CMPAttribute attribute = this.getCMPEntity().getPersistentAttribute(attributeName);
        if (attribute == null) {
            attribute = this.createPersistentAttribute(attributeName);
            isNewAttribute = true;
        }
        if (entity != null) {
            this.setDerivedAttributeType(attribute, type, isNewAttribute);
        }
        if (isNewAttribute) {
            if (this.getRole().isKey()) {
                this.getCMPEntity().getKeyAttributes().add((Object)attribute);
            }
            aList.add(attribute);
            this.getCMPEntity().getPersistentAttributes().add((Object)attribute);
        } else if (!aList.contains(attribute)) {
            aList.add(attribute);
        }
    }

    protected CMPAttribute createPersistentAttribute(String aName) {
        CMPAttribute attribute = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createCMPAttribute();
        attribute.setName(aName);
        attribute.setDescription("Generated to support relationships.  Do NOT delete.");
        return attribute;
    }

    protected void collectKeyModelledAttributes(ContainerManagedEntity entity, String attributeName, List aList, List computedNames) {
        for (CMPAttribute attribute : entity.getFilteredFeatures(ModelledKeyAttributeFilter.singleton())) {
            this.collectAttributes(entity, attribute, attributeName, aList, computedNames);
        }
    }

    protected void collectKeyRoleAttributes(ContainerManagedEntity entity, String attributeName, List aList, List computedNames) {
        if (this.visitedKeyTypes.contains(entity)) {
            throw new RuntimeException("Key role cycle detected");
        }
        this.visitedKeyTypes.add(entity);
        for (CommonRelationshipRole aRole : entity.getFilteredFeatures(KeyRelationshipRoleFilter.singleton())) {
            String attName = this.appendName(attributeName, aRole.getName());
            this.reconcileAttributes(aRole, attName, aList, computedNames);
        }
    }

    protected ContainerManagedEntity getCMPEntity() {
        return this.getRole().getSourceEntity();
    }
}

