/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.internal.annotation;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.annotation.AnnotationFileInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.annotation.AnnotationFileRegistry;

public class AnnotationFileRegistryReader {
    protected static final String EXTENSION_POINT_ID = "annotationFiles";
    protected static final String TAG_NAME = "annotationFile";
    protected static final String ATT_PUBLIC_ID = "publicId";
    protected static final String ATT_LOCATION = "location";
    private AnnotationFileRegistry annotationFileRegistry;

    public AnnotationFileRegistryReader(AnnotationFileRegistry annotationFileRegistry) {
        this.annotationFileRegistry = annotationFileRegistry;
    }

    public void readRegistry() {
        String pluginId;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint(pluginId = "org.eclipse.wst.xml.core", EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_NAME)) {
            String publicId = element.getAttribute(ATT_PUBLIC_ID);
            String location = element.getAttribute(ATT_LOCATION);
            if (publicId != null && location != null) {
                try {
                    String bundleId = element.getNamespace();
                    AnnotationFileInfo fileInfo = new AnnotationFileInfo(location, bundleId);
                    this.annotationFileRegistry.addAnnotationFile(publicId, fileInfo);
                }
                catch (Exception e) {
                    Logger.logException("problem adding annotation file " + location, e);
                }
            }
        }
    }
}

