/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.viewers;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;
import org.eclipse.wst.internet.monitor.ui.internal.custom.MonitorStackLayout;

public class HeaderViewer {
    protected boolean displayHeader = true;
    protected Composite headerComp;
    protected MonitorStackLayout layout;
    protected Label headerLabel;
    protected Text headerText;
    protected Request rr;
    protected byte msg;
    protected boolean hidden = false;
    public static byte REQUEST_HEADER = 0;
    public static byte RESPONSE_HEADER = 1;

    public HeaderViewer(Composite parent, byte message) {
        this.headerComp = new Composite(parent, 0);
        this.layout = new MonitorStackLayout();
        this.headerComp.setLayout((Layout)this.layout);
        this.headerText = new Text(this.headerComp, 2826);
        Display display = this.headerComp.getDisplay();
        this.headerText.setBackground(display.getSystemColor(25));
        this.headerText.setForeground(display.getSystemColor(24));
        this.headerText.setFont(JFaceResources.getTextFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.headerText, "org.eclipse.wst.internet.monitor.ui.tmvw0006");
        this.headerLabel = new Label(this.headerComp, 0);
        this.layout.topControl = this.headerText;
        this.rr = null;
        this.msg = message;
        this.setDisplayHeader(false);
    }

    public void setRequestResponse(Request request) {
        this.rr = request;
        if (!this.hidden) {
            this.getView();
        }
    }

    public void setDisplayHeader(boolean b) {
        if (this.displayHeader != b) {
            this.displayHeader = b;
            this.layout.topControl = this.displayHeader ? this.headerText : this.headerLabel;
            this.headerComp.layout(true);
            this.getView();
        }
    }

    private void getView() {
        String out = "";
        if (this.rr != null) {
            byte[] b;
            if (this.msg == REQUEST_HEADER) {
                b = this.rr.getRequest(1);
                if (b != null) {
                    out = MonitorUIPlugin.parse(b);
                }
            } else if (this.msg == RESPONSE_HEADER && (b = this.rr.getResponse(1)) != null) {
                out = MonitorUIPlugin.parse(b);
            }
        }
        if (this.displayHeader) {
            this.headerText.setText(out);
        } else {
            String lineSeparator = System.getProperty("line.separator");
            int index = out.indexOf(lineSeparator);
            if (index > 0) {
                this.headerLabel.setText(NLS.bind((String)Messages.headerLabel, (Object)out.substring(0, index)));
            } else {
                this.headerLabel.setText(NLS.bind((String)Messages.headerLabel, (Object)out));
            }
        }
    }

    public void dispose() {
        this.headerComp.dispose();
    }

    public void setEditable(boolean editable) {
        this.headerText.setEditable(editable);
    }

    public byte[] getContent() {
        if (this.headerText == null || this.headerText.isDisposed()) {
            return null;
        }
        String header = this.headerText.getText().trim();
        byte[] twoNewlines = new byte[]{13, 10, 13, 10};
        byte[] headerBytes = header.getBytes();
        byte[] retBytes = new byte[headerBytes.length + 4];
        System.arraycopy(headerBytes, 0, retBytes, 0, headerBytes.length);
        System.arraycopy(twoNewlines, 0, retBytes, headerBytes.length, 4);
        return retBytes;
    }
}

