/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.internal.J2EEModulePostImportHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;

public class J2EEModulePostImportHelper {
    private static final String WEB = J2EEPluginResourceHandler.J2EEModulePostImportHelper_0;
    private static final String EJB = J2EEPluginResourceHandler.J2EEModulePostImportHelper_1;
    private static final String APP_CLIENT = J2EEPluginResourceHandler.J2EEModulePostImportHelper_2;
    private static final String CONNECTOR = J2EEPluginResourceHandler.J2EEModulePostImportHelper_3;
    private static IConfigurationElement[] webExtensions = null;
    private static IConfigurationElement[] ejbExtensions = null;
    private static IConfigurationElement[] appClientExtensions = null;
    private static IConfigurationElement[] connectorExtensions = null;
    private static boolean firstTimeLoading = true;

    public static void notifyWebExtensions(IProject project) {
        if (webExtensions == null) {
            J2EEModulePostImportHelper.loadConfiguration(WEB);
        }
        J2EEModulePostImportHelper.notifyExtensions(webExtensions, project);
    }

    public static void notifyEjbExtensions(IProject project) {
        if (ejbExtensions == null) {
            J2EEModulePostImportHelper.loadConfiguration(EJB);
        }
        J2EEModulePostImportHelper.notifyExtensions(ejbExtensions, project);
    }

    public static void notifyAppClientExtensions(IProject project) {
        if (appClientExtensions == null) {
            J2EEModulePostImportHelper.loadConfiguration(APP_CLIENT);
        }
        J2EEModulePostImportHelper.notifyExtensions(appClientExtensions, project);
    }

    public static void notifyConnectorExtensions(IProject project) {
        if (connectorExtensions == null) {
            J2EEModulePostImportHelper.loadConfiguration(CONNECTOR);
        }
        J2EEModulePostImportHelper.notifyExtensions(connectorExtensions, project);
    }

    private static void notifyExtensions(IConfigurationElement[] postImportElement, IProject project) {
        int i = 0;
        while (i < postImportElement.length) {
            try {
                J2EEModulePostImportHandler postCreate = (J2EEModulePostImportHandler)postImportElement[i].createExecutableExtension("className");
                postCreate.moduleImported(project);
            }
            catch (CoreException e) {
                J2EEPlugin.logError(e);
            }
            ++i;
        }
    }

    private static void loadConfiguration(String loadingModuleType) {
        boolean shouldLogErrors = firstTimeLoading;
        firstTimeLoading = false;
        IExtension[] importExtensions = Platform.getExtensionRegistry().getExtensionPoint("J2EEModulePostImport").getExtensions();
        ArrayList<IConfigurationElement> interestedExtensions = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < importExtensions.length) {
            IExtension extension = importExtensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            boolean isExtensionInterested = false;
            IConfigurationElement postImportElement = null;
            int moduleCount = 0;
            int j = 0;
            while (j < configElements.length) {
                block27: {
                    try {
                        IConfigurationElement element = configElements[j];
                        if (element.getName().equalsIgnoreCase("postImport")) {
                            postImportElement = element;
                        } else if (element.getName().equalsIgnoreCase("module")) {
                            ++moduleCount;
                            if (!isExtensionInterested) {
                                String moduleType = element.getAttribute("type");
                                if (WEB == loadingModuleType && WEB.equalsIgnoreCase(moduleType)) {
                                    isExtensionInterested = true;
                                } else if (EJB == loadingModuleType && EJB.equalsIgnoreCase(moduleType)) {
                                    isExtensionInterested = true;
                                } else if (APP_CLIENT == loadingModuleType && APP_CLIENT.equalsIgnoreCase(moduleType)) {
                                    isExtensionInterested = true;
                                } else if (CONNECTOR == loadingModuleType && CONNECTOR.equalsIgnoreCase(moduleType)) {
                                    isExtensionInterested = true;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!shouldLogErrors) break block27;
                        J2EEPlugin.logError(e);
                    }
                }
                ++j;
            }
            if (!isExtensionInterested && moduleCount == 0) {
                isExtensionInterested = true;
            }
            if (isExtensionInterested && postImportElement != null) {
                try {
                    postImportElement.createExecutableExtension("className");
                    interestedExtensions.add(postImportElement);
                }
                catch (Exception e) {
                    J2EEPlugin.logError(e);
                }
            }
            ++i;
        }
        IConfigurationElement[] configElements = new IConfigurationElement[interestedExtensions.size()];
        int i2 = 0;
        while (i2 < configElements.length) {
            configElements[i2] = (IConfigurationElement)interestedExtensions.get(i2);
            ++i2;
        }
        if (WEB == loadingModuleType) {
            webExtensions = configElements;
        } else if (EJB == loadingModuleType) {
            ejbExtensions = configElements;
        } else if (APP_CLIENT == loadingModuleType) {
            appClientExtensions = configElements;
        } else if (CONNECTOR == loadingModuleType) {
            connectorExtensions = configElements;
        }
    }
}

