/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.util.Sorter;

public abstract class RegistryReader {
    protected static final String TAG_DESCRIPTION = "description";

    protected RegistryReader() {
    }

    protected String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getNamespace() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        Logger.log(4, buf.toString());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, "Unknown extension tag found: " + element.getName());
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        Sorter sorter = new Sorter(){

            public boolean compare(Object extension1, Object extension2) {
                String s1 = ((IExtension)extension1).getNamespace().toUpperCase();
                String s2 = ((IExtension)extension2).getNamespace().toUpperCase();
                return s2.compareTo(s1) > 0;
            }
        };
        Object[] sorted = sorter.sort(extensions);
        IExtension[] sortedExtension = new IExtension[sorted.length];
        System.arraycopy(sorted, 0, sortedExtension, 0, sorted.length);
        return sortedExtension;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.readElement(elements[i])) {
                this.logUnknownElement(elements[i]);
            }
            ++i;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    protected void readRegistry(IPluginRegistry registry, String pluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            extensions = this.orderExtensions(extensions);
            int i = 0;
            while (i < extensions.length) {
                this.readExtension(extensions[i]);
                ++i;
            }
        }
    }

    protected void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            extensions = this.orderExtensions(extensions);
            int i = 0;
            while (i < extensions.length) {
                this.readExtension(extensions[i]);
                ++i;
            }
        }
    }
}

