/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.ui.SWTFactory;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors.AbstractJavaScriptBreakpointEditor;

public class StandardJavaScriptBreakpointEditor
extends AbstractJavaScriptBreakpointEditor {
    private IJavaScriptBreakpoint fBreakpoint;
    private Button fHitCountButton;
    private Text fHitCountText;
    private Button fSuspendThread;
    private Button fSuspendTarget;
    public static final int PROP_HIT_COUNT_ENABLED = 4101;
    public static final int PROP_HIT_COUNT = 4102;
    public static final int PROP_SUSPEND_POLICY = 4103;

    public Control createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.jsdt.debug.ui.standard_breakpoint_editor");
        return this.createStandardControls(parent);
    }

    protected Control createStandardControls(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 4, 1, 0, 0, 0);
        this.fHitCountButton = SWTFactory.createCheckButton(composite, this.processMnemonics(Messages.hit_count), null, false, 1);
        this.fHitCountButton.setLayoutData((Object)new GridData());
        this.fHitCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean enabled = StandardJavaScriptBreakpointEditor.this.fHitCountButton.getSelection();
                StandardJavaScriptBreakpointEditor.this.fHitCountText.setEnabled(enabled);
                if (enabled) {
                    StandardJavaScriptBreakpointEditor.this.fHitCountText.setFocus();
                }
                StandardJavaScriptBreakpointEditor.this.setDirty(4101);
            }
        });
        this.fHitCountText = SWTFactory.createSingleText(composite, 1);
        GridData gd = (GridData)this.fHitCountText.getLayoutData();
        gd.minimumWidth = 50;
        this.fHitCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StandardJavaScriptBreakpointEditor.this.setDirty(4102);
            }
        });
        SWTFactory.createLabel(composite, "", 1);
        Composite radios = SWTFactory.createComposite(composite, composite.getFont(), 2, 1, 768, 0, 0);
        this.fSuspendThread = SWTFactory.createRadioButton(radios, this.processMnemonics(Messages.suspend_thread));
        this.fSuspendThread.setLayoutData((Object)new GridData());
        this.fSuspendTarget = SWTFactory.createRadioButton(radios, this.processMnemonics(Messages.suspend_target));
        this.fSuspendTarget.setLayoutData((Object)new GridData());
        this.fSuspendThread.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandardJavaScriptBreakpointEditor.this.setDirty(4103);
            }
        });
        this.fSuspendTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandardJavaScriptBreakpointEditor.this.setDirty(4103);
            }
        });
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StandardJavaScriptBreakpointEditor.this.dispose();
            }
        });
        return composite;
    }

    public void setInput(Object breakpoint) throws CoreException {
        if (breakpoint instanceof IJavaScriptBreakpoint) {
            this.setBreakpoint((IJavaScriptBreakpoint)breakpoint);
        } else {
            this.setBreakpoint(null);
        }
    }

    public Object getInput() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IJavaScriptBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
        boolean enabled = false;
        boolean hasHitCount = false;
        String text = "";
        boolean suspendThread = true;
        if (breakpoint != null) {
            enabled = true;
            int hitCount = breakpoint.getHitCount();
            if (hitCount > 0) {
                text = new Integer(hitCount).toString();
                hasHitCount = true;
            }
            suspendThread = breakpoint.getSuspendPolicy() == 1;
        }
        this.fHitCountButton.setEnabled(enabled);
        this.fHitCountButton.setSelection(enabled & hasHitCount);
        this.fHitCountText.setEnabled(hasHitCount);
        this.fHitCountText.setText(text);
        this.fSuspendThread.setEnabled(enabled);
        this.fSuspendTarget.setEnabled(enabled);
        this.fSuspendThread.setSelection(suspendThread);
        this.fSuspendTarget.setSelection(!suspendThread);
        this.setDirty(false);
    }

    protected IJavaScriptBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    public void setFocus() {
    }

    public void doSave() throws CoreException {
        if (this.fBreakpoint != null) {
            int suspendPolicy = 1;
            if (this.fSuspendTarget.getSelection()) {
                suspendPolicy = 2;
            }
            this.fBreakpoint.setSuspendPolicy(suspendPolicy);
            int hitCount = -1;
            if (this.fHitCountButton.getSelection()) {
                try {
                    hitCount = Integer.parseInt(this.fHitCountText.getText());
                }
                catch (NumberFormatException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.debug.ui", 4, Messages.hit_count_must_be_positive, (Throwable)e));
                }
            }
            this.fBreakpoint.setHitCount(hitCount);
        }
        this.setDirty(false);
    }

    public IStatus getStatus() {
        if (this.fHitCountButton.getSelection()) {
            String hitCountText = this.fHitCountText.getText();
            int hitCount = -1;
            try {
                hitCount = Integer.parseInt(hitCountText);
            }
            catch (NumberFormatException numberFormatException) {
                return new Status(4, "org.eclipse.wst.jsdt.debug.ui", 4, Messages.hit_count_must_be_positive, null);
            }
            if (hitCount < 1) {
                return new Status(4, "org.eclipse.wst.jsdt.debug.ui", 4, Messages.hit_count_must_be_positive, null);
            }
        }
        return Status.OK_STATUS;
    }

    protected Button createSusupendPropertyEditor(Composite parent, String text, final int propId) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        button.setText(text);
        GridData gd = new GridData(1);
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandardJavaScriptBreakpointEditor.this.setDirty(propId);
            }
        });
        return button;
    }
}

