/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.comment.CommentingStrategy;
import org.eclipse.wst.sse.ui.internal.comment.CommentingStrategyRegistry;
import org.eclipse.wst.sse.ui.internal.handlers.AbstractCommentHandler;

public final class ToggleLineCommentHandler
extends AbstractCommentHandler {
    private static final int TOGGLE_LINES_MAX_NO_BUSY_INDICATOR = 10;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processAction(ITextEditor textEditor, IStructuredDocument document, ITextSelection textSelection) {
        boolean changed;
        IStructuredModel model;
        block16: {
            model = null;
            DocumentRewriteSession session = null;
            changed = false;
            try {
                block15: {
                    try {
                        StructuredTextViewer viewer;
                        int selectionStartLine = textSelection.getStartLine();
                        int selectionEndLine = textSelection.getEndLine();
                        int selectionEndLineOffset = document.getLineOffset(selectionEndLine);
                        int selectionEndOffset = textSelection.getOffset() + textSelection.getLength();
                        if (selectionEndLine > selectionStartLine && selectionEndLineOffset == selectionEndOffset) {
                            --selectionEndLine;
                        }
                        Position selectionPosition = null;
                        selectionPosition = new Position(textSelection.getOffset(), textSelection.getLength());
                        document.addPosition(selectionPosition);
                        model = StructuredModelManager.getModelManager().getModelForEdit(document);
                        if (model == null) break block15;
                        model.beginRecording((Object)this, SSEUIMessages.ToggleComment_label, SSEUIMessages.ToggleComment_description);
                        model.aboutToChangeModel();
                        if (document instanceof IDocumentExtension4) {
                            session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                        }
                        changed = true;
                        Display display = null;
                        if (textEditor instanceof StructuredTextEditor && (viewer = ((StructuredTextEditor)textEditor).getTextViewer()) != null) {
                            display = viewer.getControl().getDisplay();
                        }
                        ToggleLinesRunnable toggleCommentsRunnable = new ToggleLinesRunnable(model.getContentTypeIdentifier(), document, selectionStartLine, selectionEndLine, display);
                        if (selectionEndLine - selectionStartLine > 10 && display != null) {
                            ProgressMonitorDialog dialog = new ProgressMonitorDialog(display.getActiveShell());
                            dialog.run(false, true, (IRunnableWithProgress)toggleCommentsRunnable);
                            break block15;
                        }
                        toggleCommentsRunnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        Logger.logException("Problem running toggle comment progess dialog.", e);
                    }
                    catch (InterruptedException e) {
                        Logger.logException("Problem running toggle comment progess dialog.", e);
                    }
                    catch (BadLocationException e) {
                        Logger.logException("The given selection " + textSelection + " must be invalid", e);
                    }
                }
                Object var15_20 = null;
                if (session == null) break block16;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                if (session != null && document instanceof IDocumentExtension4) {
                    ((IDocumentExtension4)document).stopRewriteSession(session);
                }
                if (model == null) throw throwable;
                model.endRecording((Object)this);
                if (changed) {
                    model.changedModel();
                }
                model.releaseFromEdit();
                throw throwable;
            }
            if (document instanceof IDocumentExtension4) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
        }
        if (model == null) return;
        model.endRecording((Object)this);
        if (changed) {
            model.changedModel();
        }
        model.releaseFromEdit();
    }

    private static class ToggleLinesRunnable
    implements IRunnableWithProgress {
        private String fContentType;
        private IStructuredDocument fDocument;
        private int fSelectionStartLine;
        private int fSelectionEndLine;
        private Display fDisplay;

        protected ToggleLinesRunnable(String contentTypeIdentifier, IStructuredDocument document, int selectionStartLine, int selectionEndLine, Display display) {
            this.fContentType = contentTypeIdentifier;
            this.fDocument = document;
            this.fSelectionStartLine = selectionStartLine;
            this.fSelectionEndLine = selectionEndLine;
            this.fDisplay = display;
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(SSEUIMessages.ToggleComment_progress, this.fSelectionEndLine - this.fSelectionStartLine);
            try {
                int line = this.fSelectionStartLine;
                while (line <= this.fSelectionEndLine && !monitor.isCanceled()) {
                    this.readAndDispatch(this.fDisplay);
                    IRegion lineRegion = this.fDocument.getLineInformation(line);
                    String content = this.fDocument.get(lineRegion.getOffset(), lineRegion.getLength());
                    if (content.trim().length() > 0) {
                        ITypedRegion[] lineTypedRegions = this.fDocument.computePartitioning(lineRegion.getOffset(), lineRegion.getLength());
                        CommentingStrategy commentType = CommentingStrategyRegistry.getDefault().getLineCommentingStrategy(this.fContentType, lineTypedRegions);
                        if (commentType == null) {
                            commentType = CommentingStrategyRegistry.getDefault().getBlockCommentingStrategy(this.fContentType, lineTypedRegions);
                        }
                        if (commentType != null) {
                            if (commentType.alreadyCommenting(this.fDocument, (IRegion[])lineTypedRegions)) {
                                commentType.remove(this.fDocument, lineRegion.getOffset(), lineRegion.getLength(), true);
                            } else {
                                commentType.apply(this.fDocument, lineRegion.getOffset(), lineRegion.getLength());
                            }
                        }
                    }
                    monitor.worked(1);
                    ++line;
                }
            }
            catch (BadLocationException e) {
                Logger.logException("Bad location while toggling comments.", e);
            }
            monitor.done();
        }

        private void readAndDispatch(Display display) {
            try {
                display.readAndDispatch();
            }
            catch (Exception e) {
                Logger.log(2, "Exception caused by readAndDispatch, not caused by or fatal to caller", e);
            }
            catch (LinkageError e) {
                Logger.log(2, "LinkageError caused by readAndDispatch, not caused by or fatal to caller", e);
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Error e) {
                Logger.log(2, "Error caused by readAndDispatch, not caused by or fatal to caller", e);
            }
        }
    }
}

