/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.IMonitoredServerPort;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;

public class CreateMonitorCommand
extends AbstractDataModelOperation {
    private static final String WEB_SERVICES = "Web services";
    private Boolean monitorService;
    private String serviceServerInstanceId;
    private Integer monitoredPort;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IServer server;
        IEnvironment env = this.getEnvironment();
        if (this.monitorService != null && this.monitorService.booleanValue() && (server = ServerCore.findServer((String)this.serviceServerInstanceId)) != null) {
            ServerPort[] ports = server.getServerPorts(null);
            ServerPort port = null;
            int it = 0;
            while (it < ports.length) {
                ServerPort p = ports[it];
                String protocol = p.getProtocol();
                if (protocol != null && protocol.trim().toLowerCase().equals("http")) {
                    port = p;
                    break;
                }
                ++it;
            }
            if (port != null) {
                ServerMonitorManager serverMonitorManager = ServerMonitorManager.getInstance();
                IMonitoredServerPort[] monitoredPorts = serverMonitorManager.getMonitoredPorts(server);
                int it2 = 0;
                while (it2 < monitoredPorts.length) {
                    IMonitoredServerPort imsPort = monitoredPorts[it2];
                    if (port.getPort() == imsPort.getServerPort().getPort() && this.hasContentWebServices(imsPort)) {
                        if (!imsPort.isStarted()) {
                            try {
                                serverMonitorManager.startMonitor(imsPort);
                            }
                            catch (CoreException ce) {
                                IStatus error = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_UNABLE_TO_START_MONITOR, (Object[])new Object[]{String.valueOf(port.getPort()), server.getName()}), (Throwable)ce);
                                env.getStatusHandler().reportError(error);
                                return error;
                            }
                        }
                        this.monitoredPort = new Integer(imsPort.getMonitorPort());
                        return Status.OK_STATUS;
                    }
                    ++it2;
                }
                try {
                    IMonitoredServerPort imsPort = serverMonitorManager.createMonitor(server, port, -1, new String[]{WEB_SERVICES});
                    serverMonitorManager.startMonitor(imsPort);
                    this.monitoredPort = new Integer(imsPort.getMonitorPort());
                    return Status.OK_STATUS;
                }
                catch (CoreException ce) {
                    IStatus error = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_UNABLE_TO_START_MONITOR, (Object[])new Object[]{String.valueOf(port.getPort()), server.getName()}), (Throwable)ce);
                    env.getStatusHandler().reportError(error);
                    return error;
                }
            }
            IStatus info = StatusUtils.infoStatus((String)NLS.bind((String)ConsumptionMessages.MSG_INFO_MONITORING_NOT_SUPPORTED, (Object[])new Object[]{server.getName()}));
            env.getStatusHandler().reportInfo(info);
            return info;
        }
        return Status.OK_STATUS;
    }

    private boolean hasContentWebServices(IMonitoredServerPort imsPort) {
        String[] contents = imsPort.getContentTypes();
        int i = 0;
        while (i < contents.length) {
            if (WEB_SERVICES.equals(contents[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
        this.serviceServerInstanceId = typeRuntimeServer.getServerInstanceId();
    }

    public void setServiceServerInstanceId(String serviceServerInstanceId) {
        this.serviceServerInstanceId = serviceServerInstanceId;
    }

    public Integer getMonitoredPort() {
        return this.monitoredPort;
    }

    public void setMonitorService(Boolean value) {
        this.monitorService = value;
    }
}

