/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.JavaEEPreferencesInitializer;
import org.osgi.service.prefs.BackingStoreException;

public class J2EEPreferences {
    private boolean persistOnChange = false;

    public J2EEPreferences(Plugin owner) {
    }

    protected void initializeDefaultPreferences() {
    }

    public String getSetting(String key) {
        return this.getString(key);
    }

    public void setSetting(String key, String value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").put(key, value);
        this.firePreferenceChanged();
    }

    public boolean getUseEARLibraries() {
        return this.getBoolean("org.eclipse.jst.j2ee.preferences.useEARLibraries");
    }

    public void setUseEARLibraries(boolean value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").putBoolean("org.eclipse.jst.j2ee.preferences.useEARLibraries", value);
        this.firePreferenceChanged();
    }

    public boolean getUseEARLibrariesJDTExport() {
        return this.getBoolean("org.eclipse.jst.j2ee.preferences.useEARLibrariesJDTExport");
    }

    public void setUseEARLibrariesJDTExport(boolean value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").putBoolean("org.eclipse.jst.j2ee.preferences.useEARLibrariesJDTExport", value);
        this.firePreferenceChanged();
    }

    public boolean getUseWebLibaries() {
        return this.getBoolean("org.eclipse.jst.j2ee.preferences.useWebAppLibraries");
    }

    public void setUseWebLibraries(boolean value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").putBoolean("org.eclipse.jst.j2ee.preferences.useWebAppLibraries", value);
        this.firePreferenceChanged();
    }

    public boolean getAllowClasspathDep() {
        return this.getBoolean("allowClasspathDep");
    }

    public void setAllowClasspathDep(boolean value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").putBoolean("allowClasspathDep", value);
        this.firePreferenceChanged();
    }

    public IEclipsePreferences getInstancePreferenceNode(String qualifier) {
        return new InstanceScope().getNode("org.eclipse.jst.j2ee");
    }

    public String getJ2EEWebContentFolderName() {
        return this.getString("webContent");
    }

    public String getStaticWebContentFolderName() {
        return this.getString("org.eclipse.jst.j2ee.preference.staticWebContentName");
    }

    public String getJavaSourceFolderName() {
        return FacetCorePlugin.getJavaSrcFolder();
    }

    public String getHighestJ2EEVersionSetting() {
        return this.getString("org.eclipse.jst.j2ee.ui.preference.j2eeVersion");
    }

    public boolean isServerTargetingEnabled() {
        return this.getBoolean("org.eclipse.jst.j2ee.preference.servertargetsupport");
    }

    public void setJ2EEWebContentFolderName(String value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").put("webContent", value);
        this.firePreferenceChanged();
    }

    public void setStaticWebContentFolderName(String value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").put("org.eclipse.jst.j2ee.preference.staticWebContentName", value);
        this.firePreferenceChanged();
    }

    public void setJavaSourceFolderName(String value) {
        FacetCorePlugin.getDefault().getPluginPreferences().setValue("defaultSource", value);
        FacetCorePlugin.getDefault().savePluginPreferences();
        this.firePreferenceChanged();
    }

    public void setHighestJ2EEVersionSetting(String value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").put("org.eclipse.jst.j2ee.ui.preference.j2eeVersion", value);
        this.firePreferenceChanged();
    }

    public void setServerTargetingEnabled(boolean value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").putBoolean("org.eclipse.jst.j2ee.preference.servertargetsupport", value);
        this.firePreferenceChanged();
    }

    public void setIncrementalDeploymentEnabled(boolean value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").putBoolean("org.eclipse.jst.j2ee.ui.preference.incrementalDeployment", value);
        this.firePreferenceChanged();
    }

    public boolean isIncrementalDeploymentEnabled() {
        return this.getBoolean("org.eclipse.jst.j2ee.ui.preference.incrementalDeployment");
    }

    public int getHighestJ2EEVersionID() {
        String versionPreference = this.getHighestJ2EEVersionSetting();
        if ("J2EE_1_2".equals(versionPreference)) {
            return 12;
        }
        if ("J2EE_1_3".equals(versionPreference)) {
            return 13;
        }
        return 14;
    }

    public void firePreferenceChanged() {
        if (this.isPersistOnChange()) {
            this.persist();
        }
    }

    public void persist() {
        try {
            this.getInstancePreferenceNode("org.eclipse.jst.j2ee").flush();
        }
        catch (BackingStoreException e) {
            J2EEPlugin.logError(e);
        }
    }

    public boolean isPersistOnChange() {
        return this.persistOnChange;
    }

    public void setPersistOnChange(boolean persistOnChange) {
        this.persistOnChange = persistOnChange;
    }

    public boolean getDefaultBoolean(String name) {
        return new DefaultScope().getNode("org.eclipse.jst.j2ee").getBoolean(name, false);
    }

    public boolean getBoolean(String name) {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        return preferencesService.getBoolean("org.eclipse.jst.j2ee", name, false, lookupOrder);
    }

    public void setValue(String name, boolean value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").putBoolean(name, value);
        this.firePreferenceChanged();
    }

    public String getDefaultString(String name) {
        return new DefaultScope().getNode("org.eclipse.jst.j2ee").get(name, "");
    }

    public String getString(String name) {
        return JavaEEPreferencesInitializer.getString(name);
    }

    public void setValue(String name, String value) {
        this.getInstancePreferenceNode("org.eclipse.jst.j2ee").put(name, value);
        this.firePreferenceChanged();
    }

    public String getDynamicWebDefaultSourceFolder() {
        return JavaEEPreferencesInitializer.getDynamicWebDefaultSourceFolder();
    }

    public String getDynamicWebDefaultOuputFolderName() {
        return JavaEEPreferencesInitializer.getDynamicWebDefaultOuputFolderName();
    }

    public String getAppClientDefaultOutputFolderName() {
        return JavaEEPreferencesInitializer.getAppClientDefaultOutputFolderName();
    }

    public String getEJBDefaultOutputFolderName() {
        return JavaEEPreferencesInitializer.getEJBDefaultOutputFolderName();
    }

    public String getJCADefaultOutputFolderName() {
        return JavaEEPreferencesInitializer.getJCADefaultOutputFolderName();
    }

    public String getDefaultOutputFolderName() {
        return JavaEEPreferencesInitializer.getDefaultOutputFolderName();
    }

    public String getDefaultJavaSrcFolder() {
        return JavaEEPreferencesInitializer.getDefaultJavaSrcFolder();
    }

    public String getUtilityOutputFolderName() {
        String outputFolder = FacetCorePlugin.getDefault().getPluginPreferences().getString("outputFolder");
        if (outputFolder == null || outputFolder.equals("")) {
            return this.getDefaultOutputFolderName();
        }
        return outputFolder;
    }

    public static interface Defaults
    extends JavaEEPreferencesInitializer.Defaults {
    }

    public static interface Keys
    extends JavaEEPreferencesInitializer.Keys {
    }

    public static interface Values
    extends JavaEEPreferencesInitializer.Values {
    }
}

