/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationWrapper;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.internal.ejb.provider.EJBJarItemProvider;
import org.eclipse.jst.j2ee.internal.ejb.provider.EJBNameComparator;
import org.eclipse.jst.j2ee.internal.ejb.provider.EJBUIMessages;
import org.eclipse.jst.j2ee.internal.ejb.provider.GroupedEJBItemProvider;
import org.eclipse.jst.j2ee.internal.ejb.provider.GroupedEntityItemProvider;
import org.eclipse.jst.j2ee.internal.ejb.provider.GroupedMessageItemProvider;
import org.eclipse.jst.j2ee.internal.ejb.provider.GroupedSessionItemProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.provider.J2EEItemProvider;

public class GroupedEJBJarItemProvider
extends EJBJarItemProvider {
    private GroupedSessionItemProvider sessionProvider = null;
    private GroupedEntityItemProvider entityProvider = null;
    private GroupedMessageItemProvider messageProvider = null;
    private static Hashtable sessionTable = new Hashtable();
    private static Hashtable entityTable = new Hashtable();
    private static Hashtable messageTable = new Hashtable();
    private static final String SESSION = EJBUIMessages.GroupedEJBJarItemProvider_UI_0;
    private static final String ENTITY = EJBUIMessages.GroupedEJBJarItemProvider_UI_1;
    private static final String MESSAGE = EJBUIMessages.GroupedEJBJarItemProvider_UI_2;
    protected Map children = new HashMap();
    private boolean showAssemblyDescriptor;
    private boolean isDisposing;

    public GroupedEJBJarItemProvider(AdapterFactory adapterFactory, boolean showAssemblyDescriptor) {
        super(adapterFactory);
        this.showAssemblyDescriptor = showAssemblyDescriptor;
    }

    public Collection getChildren(Object object) {
        List result = this.initChildren(object);
        if (this.showAssemblyDescriptor && ((EJBJar)object).getAssemblyDescriptor() != null) {
            result.add(((EJBJar)object).getAssemblyDescriptor());
        }
        return result;
    }

    protected List initChildren(Object object) {
        EJBJar ejbJar = (EJBJar)object;
        List allRootBeans = GroupedEJBJarItemProvider.getAllRootBeans(ejbJar);
        boolean is20Jar = this.is20Jar(ejbJar);
        ArrayList<GroupedEJBItemProvider> localChildren = new ArrayList<GroupedEJBItemProvider>(5);
        ArrayList entityBeans = new ArrayList();
        ArrayList sessionBeans = new ArrayList();
        ArrayList messageBeans = new ArrayList();
        this.catagorizeBeans(allRootBeans, entityBeans, sessionBeans, messageBeans);
        this.orderBeans(entityBeans);
        this.orderBeans(sessionBeans);
        this.orderBeans(messageBeans);
        if (sessionTable.get(ejbJar) == null) {
            this.sessionProvider = new GroupedSessionItemProvider(this.adapterFactory, null, this.getImage(SESSION), object, sessionBeans);
            sessionTable.put(ejbJar, this.sessionProvider);
            localChildren.add(this.sessionProvider);
        } else {
            localChildren.add((GroupedEJBItemProvider)((Object)sessionTable.get(ejbJar)));
        }
        if (entityTable.get(ejbJar) == null) {
            this.entityProvider = new GroupedEntityItemProvider(this.adapterFactory, null, this.getImage(ENTITY), object, entityBeans);
            entityTable.put(ejbJar, this.entityProvider);
            localChildren.add(this.entityProvider);
        } else {
            localChildren.add((GroupedEJBItemProvider)((Object)entityTable.get(ejbJar)));
        }
        if (is20Jar) {
            if (messageTable.get(ejbJar) == null) {
                this.messageProvider = new GroupedMessageItemProvider(this.adapterFactory, null, this.getImage(MESSAGE), object, messageBeans);
                messageTable.put(ejbJar, this.messageProvider);
                localChildren.add(this.messageProvider);
            } else {
                localChildren.add((GroupedEJBItemProvider)((Object)messageTable.get(ejbJar)));
            }
        }
        this.children.put(object, localChildren);
        return localChildren;
    }

    protected void orderBeans(List beans) {
        Object[] beansArray = beans.toArray();
        Arrays.sort(beansArray, EJBNameComparator.singleton());
        beans.clear();
        beans.addAll(Arrays.asList(beansArray));
    }

    protected static List getAllRootBeans(EJBJar ejbJar) {
        return ejbJar.getEnterpriseBeans();
    }

    protected void catagorizeBeans(List allRootBeans, List entityBeans, List sessionBeans, List messageBeans) {
        int i = 0;
        while (i < allRootBeans.size()) {
            if (((EnterpriseBean)allRootBeans.get(i)).isSession()) {
                sessionBeans.add(allRootBeans.get(i));
            } else if (((EnterpriseBean)allRootBeans.get(i)).isEntity()) {
                entityBeans.add(allRootBeans.get(i));
            } else if (((EnterpriseBean)allRootBeans.get(i)).isMessageDriven()) {
                messageBeans.add(allRootBeans.get(i));
            }
            ++i;
        }
    }

    protected static GroupedSessionItemProvider getSessionNode(Object object) {
        return (GroupedSessionItemProvider)((Object)sessionTable.get(object));
    }

    protected static GroupedEntityItemProvider getEntityNode(Object object) {
        return (GroupedEntityItemProvider)((Object)entityTable.get(object));
    }

    protected static GroupedMessageItemProvider getMessageNode(Object object) {
        return (GroupedMessageItemProvider)((Object)messageTable.get(object));
    }

    public Object getImage(String type) {
        if (type.equals(SESSION)) {
            return J2EEPlugin.getPlugin().getImage("sessionBean_obj");
        }
        if (type.equals(MESSAGE)) {
            return J2EEPlugin.getPlugin().getImage("message_bean_obj");
        }
        if (type.equals(ENTITY)) {
            return J2EEPlugin.getPlugin().getImage("entitybean_obj");
        }
        return null;
    }

    private boolean is20Jar(EJBJar ejbJar) {
        switch (ejbJar.getVersionID()) {
            case 10: 
            case 11: {
                return false;
            }
        }
        return true;
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 8 && notification.getOldValue() == this && !this.isDisposing) {
            this.removeTarget(notification);
            return;
        }
        if (notification.getFeature() == EjbPackage.eINSTANCE.getEJBJar_EnterpriseBeans()) {
            J2EEItemProvider provider = this.beansChanged((EJBJar)notification.getNotifier(), notification.getEventType(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
            if (provider == null) {
                NotificationImpl msg = new NotificationImpl(3, null, (Object)GroupedEJBJarItemProvider.getEJBItemProvider((EnterpriseBean)notification.getNewValue()), 1);
                NotificationWrapper notificationWrapper = new NotificationWrapper(notification.getNotifier(), (Notification)msg);
                this.fireNotifyChanged((Notification)notificationWrapper);
                provider = this.beansChanged((EJBJar)notification.getNotifier(), notification.getEventType(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
            }
            NotificationWrapper notificationWrapper = new NotificationWrapper((Object)provider, notification);
            this.fireNotifyChanged((Notification)notificationWrapper);
        } else {
            super.notifyChanged(notification);
        }
    }

    protected J2EEItemProvider beansChanged(EJBJar ejbJar, int eventType, Object oldValue, Object newValue, int pos) {
        J2EEItemProvider provider;
        block13: {
            block12: {
                provider = this.getItemProvider(ejbJar, oldValue, newValue);
                if (provider == null) break block12;
                EList grandChildren = provider.getChildren();
                switch (eventType) {
                    case 3: {
                        if (!grandChildren.contains(newValue)) {
                            grandChildren.add(newValue);
                            break;
                        }
                        break block13;
                    }
                    case 5: {
                        grandChildren.addAll((Collection)newValue);
                        break;
                    }
                    case 4: {
                        grandChildren.remove(oldValue);
                        break;
                    }
                    case 6: {
                        grandChildren.removeAll((Collection)oldValue);
                    }
                }
                break block13;
            }
            List allRootBeans = GroupedEJBJarItemProvider.getAllRootBeans(ejbJar);
            ArrayList entityBeans = new ArrayList();
            ArrayList sessionBeans = new ArrayList();
            ArrayList messageBeans = new ArrayList();
            this.catagorizeBeans(allRootBeans, entityBeans, sessionBeans, messageBeans);
            if (newValue instanceof Session) {
                this.sessionProvider = new GroupedSessionItemProvider(this.adapterFactory, null, this.getImage(SESSION), ejbJar, sessionBeans);
                sessionTable.put(ejbJar, this.sessionProvider);
            } else if (newValue instanceof Entity) {
                this.entityProvider = new GroupedEntityItemProvider(this.adapterFactory, null, this.getImage(ENTITY), ejbJar, entityBeans);
                entityTable.put(ejbJar, this.entityProvider);
            } else if (newValue instanceof MessageDriven) {
                this.messageProvider = new GroupedMessageItemProvider(this.adapterFactory, null, this.getImage(MESSAGE), ejbJar, messageBeans);
                messageTable.put(ejbJar, this.messageProvider);
            }
        }
        return provider;
    }

    public static J2EEItemProvider getEJBJarItemProvider(EJBJar ejbJar, Object bean) {
        GroupedEJBItemProvider provider = null;
        if (ejbJar != null && bean != null) {
            if (bean instanceof Session) {
                provider = GroupedEJBJarItemProvider.getSessionNode(ejbJar);
            } else if (bean instanceof Entity) {
                provider = GroupedEJBJarItemProvider.getEntityNode(ejbJar);
            } else if (bean instanceof MessageDriven) {
                provider = GroupedEJBJarItemProvider.getMessageNode(ejbJar);
            }
        }
        return provider;
    }

    public static J2EEItemProvider getEJBItemProvider(EnterpriseBean bean) {
        if (bean != null) {
            EJBJar ejbJar = bean.getEjbJar();
            return GroupedEJBJarItemProvider.getEJBJarItemProvider(ejbJar, bean);
        }
        return null;
    }

    protected J2EEItemProvider getItemProvider(EJBJar ejbJar, Object oldValue, Object newValue) {
        if (newValue != null) {
            return GroupedEJBJarItemProvider.getEJBJarItemProvider(ejbJar, newValue);
        }
        if (oldValue != null) {
            return GroupedEJBJarItemProvider.getEJBJarItemProvider(ejbJar, oldValue);
        }
        return null;
    }

    public static boolean isRootBean(EnterpriseBean bean) {
        List allRootBeans = GroupedEJBJarItemProvider.getAllRootBeans(bean.getEjbJar());
        return allRootBeans != null && allRootBeans.contains(bean);
    }

    public static void flushOutTableEntriesForEJBJar(EJBJar ejbJar) {
        sessionTable.remove(ejbJar);
        entityTable.remove(ejbJar);
        messageTable.remove(ejbJar);
    }

    public boolean hasChildren(Object parent) {
        return true;
    }

    protected void removeTarget(Notification not) {
        if (not.getNotifier() instanceof EJBJar) {
            GroupedEJBJarItemProvider.flushOutTableEntriesForEJBJar((EJBJar)not.getNotifier());
        }
    }

    public void dispose() {
        try {
            this.isDisposing = true;
            super.dispose();
        }
        finally {
            this.isDisposing = false;
        }
    }
}

