/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.GeneratedValue;
import org.eclipse.jpt.core.context.GenerationType;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.java.JavaGeneratedValue;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaGeneratedValue
extends AbstractJavaJpaContextNode
implements JavaGeneratedValue {
    protected GeneratedValueAnnotation resourceGeneratedValue;
    protected GenerationType specifiedStrategy;
    protected String specifiedGenerator;
    protected String defaultGenerator = null;

    public GenericJavaGeneratedValue(JavaIdMapping parent) {
        super(parent);
    }

    @Override
    public void initialize(GeneratedValueAnnotation generatedValueAnnotation) {
        this.resourceGeneratedValue = generatedValueAnnotation;
        this.specifiedStrategy = this.buildSpecifiedStrategy();
        this.specifiedGenerator = generatedValueAnnotation.getGenerator();
    }

    @Override
    public GenerationType getStrategy() {
        return this.specifiedStrategy != null ? this.specifiedStrategy : this.getDefaultStrategy();
    }

    @Override
    public GenerationType getDefaultStrategy() {
        return GeneratedValue.DEFAULT_STRATEGY;
    }

    @Override
    public GenerationType getSpecifiedStrategy() {
        return this.specifiedStrategy;
    }

    @Override
    public void setSpecifiedStrategy(GenerationType strategy) {
        GenerationType old = this.specifiedStrategy;
        this.specifiedStrategy = strategy;
        this.resourceGeneratedValue.setStrategy(GenerationType.toJavaResourceModel(strategy));
        this.firePropertyChanged("specifiedStrategy", (Object)old, (Object)strategy);
    }

    protected void setSpecifiedStrategy_(GenerationType strategy) {
        GenerationType old = this.specifiedStrategy;
        this.specifiedStrategy = strategy;
        this.firePropertyChanged("specifiedStrategy", (Object)old, (Object)strategy);
    }

    @Override
    public String getGenerator() {
        return this.specifiedGenerator != null ? this.specifiedGenerator : this.defaultGenerator;
    }

    @Override
    public String getDefaultGenerator() {
        return this.defaultGenerator;
    }

    @Override
    public String getSpecifiedGenerator() {
        return this.specifiedGenerator;
    }

    @Override
    public void setSpecifiedGenerator(String generator) {
        String old = this.specifiedGenerator;
        this.specifiedGenerator = generator;
        this.resourceGeneratedValue.setGenerator(generator);
        this.firePropertyChanged("specifiedGenerator", old, generator);
    }

    protected void setSpecifiedGenerator_(String generator) {
        String old = this.specifiedGenerator;
        this.specifiedGenerator = generator;
        this.firePropertyChanged("specifiedGenerator", old, generator);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.resourceGeneratedValue.getTextRange(astRoot);
    }

    @Override
    public TextRange getGeneratorTextRange(CompilationUnit astRoot) {
        return this.resourceGeneratedValue.getGeneratorTextRange(astRoot);
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.generatorTouches(pos, astRoot)) {
            return this.javaCandidateGeneratorNames(filter);
        }
        return null;
    }

    protected boolean generatorTouches(int pos, CompilationUnit astRoot) {
        return this.resourceGeneratedValue.generatorTouches(pos, astRoot);
    }

    protected Iterator<String> javaCandidateGeneratorNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateGeneratorNames(filter));
    }

    protected Iterator<String> candidateGeneratorNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateGeneratorNames(), filter);
    }

    protected Iterator<String> candidateGeneratorNames() {
        return new TransformationIterator<Generator, String>(this.candidateGenerators()){

            protected String transform(Generator generator) {
                return generator.getName();
            }
        };
    }

    protected Iterator<Generator> candidateGenerators() {
        return this.getPersistenceUnit().generators();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        String generator = this.getGenerator();
        if (generator == null) {
            return;
        }
        ListIterator<Generator> stream = this.getPersistenceUnit().generators();
        while (stream.hasNext()) {
            if (!generator.equals(((Generator)stream.next()).getName())) continue;
            return;
        }
        messages.add(DefaultJpaValidationMessages.buildMessage(1, "ID_MAPPING_UNRESOLVED_GENERATOR_NAME", new String[]{generator}, this.getParent(), this.getGeneratorTextRange(astRoot)));
    }

    @Override
    public void update(GeneratedValueAnnotation generatedValueAnnotation) {
        this.resourceGeneratedValue = generatedValueAnnotation;
        this.setSpecifiedStrategy_(this.buildSpecifiedStrategy());
        this.setSpecifiedGenerator_(generatedValueAnnotation.getGenerator());
    }

    protected GenerationType buildSpecifiedStrategy() {
        return GenerationType.fromJavaResourceModel(this.resourceGeneratedValue.getStrategy());
    }
}

