/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceBaseTemporalAnnotation
extends SourceAnnotation<Attribute>
implements TemporalAnnotation {
    protected final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    private TemporalType value;

    protected SourceBaseTemporalAnnotation(JavaResourceNode parent, Attribute attribute, DeclarationAnnotationAdapter daa) {
        super(parent, attribute, daa);
        this.valueDeclarationAdapter = new EnumDeclarationAnnotationElementAdapter(daa, this.getValueElementName());
        this.valueAdapter = new MemberAnnotationElementAdapter<String>(attribute, this.valueDeclarationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncValue(this.buildValue(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.value);
    }

    @Override
    public TemporalType getValue() {
        return this.value;
    }

    @Override
    public void setValue(TemporalType value) {
        if (this.attributeValueHasChanged((Object)this.value, (Object)value)) {
            this.value = value;
            this.valueAdapter.setValue(TemporalType.toJavaAnnotationValue(value));
        }
    }

    private void syncValue(TemporalType astValue) {
        TemporalType old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", (Object)old, (Object)astValue);
    }

    private TemporalType buildValue(CompilationUnit astRoot) {
        return TemporalType.fromJavaAnnotationValue(this.valueAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astRoot);
    }

    protected abstract String getValueElementName();
}

