/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;

public class GenericJavaIdClassReference
extends AbstractJavaJpaContextNode
implements JavaIdClassReference {
    protected String idClassName;
    protected String fullyQualifiedIdClassName;
    protected JavaPersistentType idClass;

    public GenericJavaIdClassReference(JavaTypeMapping parent) {
        super(parent);
    }

    protected JavaTypeMapping getTypeMapping() {
        return (JavaTypeMapping)this.getParent();
    }

    protected JavaPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    public AccessType getOverridePersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    public String getSpecifiedIdClassName() {
        return this.idClassName;
    }

    public void setSpecifiedIdClassName(String newClassName) {
        String oldClassName = this.idClassName;
        this.idClassName = newClassName;
        if (this.valuesAreDifferent(newClassName, oldClassName)) {
            if (newClassName != null) {
                if (this.getIdClassAnnotation() == null) {
                    this.addIdClassAnnotation();
                }
                this.getIdClassAnnotation().setValue(newClassName);
            } else {
                this.removeIdClassAnnotation();
            }
        }
        this.firePropertyChanged("specifiedIdClassName", oldClassName, newClassName);
    }

    protected void setIdClassName_(String newClassName) {
        String oldClassName = this.idClassName;
        this.idClassName = newClassName;
        this.firePropertyChanged("specifiedIdClassName", oldClassName, newClassName);
    }

    protected String buildIdClassName() {
        IdClassAnnotation annotation = this.getIdClassAnnotation();
        if (annotation != null) {
            return annotation.getValue();
        }
        return null;
    }

    public String getDefaultIdClassName() {
        return null;
    }

    public String getIdClassName() {
        return this.getSpecifiedIdClassName();
    }

    public boolean isSpecified() {
        return this.getSpecifiedIdClassName() != null;
    }

    public JavaPersistentType getIdClass() {
        return this.idClass;
    }

    protected void setIdClass_(JavaPersistentType newIdClass) {
        JavaPersistentType oldIdClass = this.idClass;
        this.idClass = newIdClass;
        this.firePropertyChanged("idClass", oldIdClass, newIdClass);
    }

    protected JavaPersistentType buildIdClass() {
        JavaResourcePersistentType resourceIdClass = this.getResourceIdClass();
        return resourceIdClass == null ? null : this.buildIdClass(resourceIdClass);
    }

    protected JavaPersistentType buildIdClass(JavaResourcePersistentType resourceClass) {
        return this.getJpaFactory().buildJavaPersistentType(this, resourceClass);
    }

    protected JavaResourcePersistentType getResourcePersistentType() {
        return this.getPersistentType().getResourcePersistentType();
    }

    protected IdClassAnnotation getIdClassAnnotation() {
        return (IdClassAnnotation)this.getResourcePersistentType().getAnnotation("javax.persistence.IdClass");
    }

    protected void addIdClassAnnotation() {
        this.getResourcePersistentType().addAnnotation("javax.persistence.IdClass");
    }

    protected void removeIdClassAnnotation() {
        this.getResourcePersistentType().removeAnnotation("javax.persistence.IdClass");
    }

    protected JavaResourcePersistentType getResourceIdClass() {
        return this.fullyQualifiedIdClassName == null ? null : this.getJpaProject().getJavaResourcePersistentType(this.fullyQualifiedIdClassName);
    }

    public String getFullyQualifiedIdClassName() {
        return this.fullyQualifiedIdClassName;
    }

    protected void setFullyQualifiedIdClassName(String idClass) {
        String old = this.fullyQualifiedIdClassName;
        this.fullyQualifiedIdClassName = idClass;
        this.firePropertyChanged("fullyQualifiedIdClass", old, idClass);
    }

    protected String buildFullyQualifiedIdClassName() {
        IdClassAnnotation annotation = this.getIdClassAnnotation();
        return annotation == null ? null : annotation.getFullyQualifiedClassName();
    }

    public char getIdClassEnclosingTypeSeparator() {
        return '.';
    }

    public void initialize() {
        this.idClassName = this.buildIdClassName();
        this.fullyQualifiedIdClassName = this.buildFullyQualifiedIdClassName();
        this.idClass = this.buildIdClass();
    }

    public void update() {
        this.setIdClassName_(this.buildIdClassName());
        this.setFullyQualifiedIdClassName(this.buildFullyQualifiedIdClassName());
        this.updateIdClass();
    }

    protected void updateIdClass() {
        JavaResourcePersistentType resourceIdClass = this.getResourceIdClass();
        if (resourceIdClass == null) {
            this.setIdClass_(null);
        } else {
            if (this.idClass == null || this.idClass.getResourcePersistentType() != resourceIdClass) {
                this.setIdClass_(this.buildIdClass(resourceIdClass));
            }
            this.idClass.update(resourceIdClass);
        }
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getIdClassAnnotation() == null ? this.getTypeMapping().getValidationTextRange(astRoot) : this.getIdClassAnnotation().getTextRange(astRoot);
    }
}

