/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui.refactoring;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.ui.refactoring.RenameContextRootRefactoringProcessor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ContextRootInputPage
extends UserInputWizardPage {
    private final RenameContextRootRefactoringProcessor fProcessor;
    private Text fNameField;

    public ContextRootInputPage(String name, RenameContextRootRefactoringProcessor processor) {
        super(name);
        this.fProcessor = processor;
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        Label label = new Label(c, 0);
        label.setText(J2EEUIMessages.getResourceString("NewContextRoot"));
        this.fNameField = new Text(c, 2048);
        this.fNameField.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ContextRootInputPage.this.validatePage();
            }
        });
        String oldName = this.fProcessor.getOldContextRoot();
        if (oldName != null && oldName.length() > 0) {
            this.fNameField.setText(oldName);
            this.fNameField.setSelection(0, oldName.length());
        }
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(c);
        this.setControl((Control)c);
        this.fNameField.setFocus();
        this.validatePage();
    }

    private void validatePage() {
        String text = this.fNameField.getText();
        RefactoringStatus status = this.fProcessor.validateNewElementName(text);
        this.setPageComplete(status);
    }

    protected boolean performFinish() {
        this.initializeRefactoring();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        return super.getNextPage();
    }

    private void initializeRefactoring() {
        this.fProcessor.setNewName(this.fNameField.getText());
    }
}

