/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa2.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.CollectionMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmConverter;
import org.eclipse.jpt.core.context.orm.OrmOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlAttributeOverrideColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.core.jpa2.context.PersistentAttribute2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaElementCollectionMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCollectionTable2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmElementCollectionMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOrderable2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmXml2_0ContextNodeFactory;
import org.eclipse.jpt.core.resource.orm.Attributes;
import org.eclipse.jpt.core.resource.orm.MapKey;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlClassReference;
import org.eclipse.jpt.core.resource.orm.XmlCollectionTable;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlConvertibleMapping;
import org.eclipse.jpt.core.resource.orm.XmlElementCollection;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmElementCollectionMapping2_0<T extends XmlElementCollection>
extends AbstractOrmAttributeMapping<T>
implements OrmElementCollectionMapping2_0 {
    protected String specifiedTargetClass;
    protected String defaultTargetClass;
    protected PersistentType resolvedTargetType;
    protected Embeddable resolvedTargetEmbeddable;
    protected FetchType specifiedFetch = this.getResourceFetch();
    protected final OrmOrderable2_0 orderable = this.getXmlContextNodeFactory().buildOrmOrderable(this, this.buildOrderableOwner());
    protected final OrmCollectionTable2_0 collectionTable;
    protected CollectionMapping.Type valueType;
    protected final OrmColumn valueColumn;
    protected OrmConverter valueConverter;
    protected final OrmConverter nullValueConverter;
    protected final OrmAttributeOverrideContainer valueAttributeOverrideContainer;
    protected final OrmAssociationOverrideContainer valueAssociationOverrideContainer;
    protected CollectionMapping.Type keyType;
    protected String specifiedMapKey;
    protected boolean noMapKey = false;
    protected boolean pkMapKey = false;
    protected boolean customMapKey = false;
    protected String specifiedMapKeyClass;
    protected String defaultMapKeyClass;
    protected PersistentType resolvedMapKeyType;
    protected Embeddable resolvedMapKeyEmbeddable;
    protected Entity resolvedMapKeyEntity;
    protected final OrmColumn mapKeyColumn;
    protected final OrmAttributeOverrideContainer mapKeyAttributeOverrideContainer;

    protected AbstractOrmElementCollectionMapping2_0(OrmPersistentAttribute parent, T resourceMapping) {
        super(parent, resourceMapping);
        this.specifiedTargetClass = this.getResourceTargetClass();
        this.defaultTargetClass = this.buildDefaultTargetClass();
        this.resolvedTargetType = this.resolveTargetType();
        this.resolvedTargetEmbeddable = this.resolveTargetEmbeddable();
        this.collectionTable = this.getXmlContextNodeFactory().buildOrmCollectionTable(this, this.getResourceCollectionTable());
        this.valueType = this.buildValueType();
        this.valueColumn = this.getXmlContextNodeFactory().buildOrmColumn(this, new ValueColumnOwner());
        this.nullValueConverter = this.getXmlContextNodeFactory().buildOrmNullConverter(this);
        this.valueConverter = this.buildConverter(this.getResourceConverterType());
        this.valueAssociationOverrideContainer = this.buildValueAssociationOverrideContainer();
        this.valueAttributeOverrideContainer = this.buildValueAttributeOverrideContainer();
        this.resolvedMapKeyType = this.resolveMapKeyType();
        this.resolvedMapKeyEmbeddable = this.resolveMapKeyEmbeddable();
        this.resolvedMapKeyEntity = this.resolveMapKeyEntity();
        this.initializeMapKey();
        this.defaultMapKeyClass = this.buildDefaultMapKeyClass();
        this.specifiedMapKeyClass = this.getResourceMapKeyClass();
        this.mapKeyColumn = this.getXmlContextNodeFactory().buildOrmColumn(this, new MapKeyColumnOwner());
        this.mapKeyAttributeOverrideContainer = this.buildMapKeyAttributeOverrideContainer();
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedTargetClass_(this.getResourceTargetClass());
        this.setDefaultTargetClass(this.buildDefaultTargetClass());
        this.resolvedTargetType = this.resolveTargetType();
        this.setResolvedTargetEmbeddable(this.resolveTargetEmbeddable());
        this.setSpecifiedFetch_(this.getResourceFetch());
        this.orderable.update();
        this.collectionTable.update();
        this.setValueType(this.buildValueType());
        this.valueColumn.update(this.getResourceColumn());
        this.valueAttributeOverrideContainer.update();
        this.valueAssociationOverrideContainer.update();
        this.updateValueConverter();
        this.resolvedMapKeyType = this.resolveMapKeyType();
        this.setResolvedMapKeyEmbeddable(this.resolveMapKeyEmbeddable());
        this.setResolvedMapKeyEntity(this.resolveMapKeyEntity());
        this.setKeyType(this.buildKeyType());
        this.updateMapKey();
        this.setDefaultMapKeyClass(this.buildDefaultMapKeyClass());
        this.setSpecifiedMapKeyClass_(this.getResourceMapKeyClass());
        this.mapKeyColumn.update(this.getResourceMapKeyColumn());
        this.mapKeyAttributeOverrideContainer.update();
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.valueAssociationOverrideContainer.postUpdate();
    }

    @Override
    protected OrmXml2_0ContextNodeFactory getXmlContextNodeFactory() {
        return super.getXmlContextNodeFactory();
    }

    @Override
    public Entity getEntity() {
        return this.getTypeMapping().getKey() == "entity" ? (Entity)((Object)this.getTypeMapping()) : null;
    }

    @Override
    public String getKey() {
        return "elementCollection";
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmAttributeMapping(this);
    }

    @Override
    public int getXmlSequence() {
        return 75;
    }

    @Override
    public void addToResourceModel(Attributes resourceAttributes) {
        resourceAttributes.getElementCollections().add((Object)((XmlElementCollection)this.resourceAttributeMapping));
    }

    @Override
    public void removeFromResourceModel(Attributes resourceAttributes) {
        resourceAttributes.getElementCollections().remove((Object)this.resourceAttributeMapping);
    }

    @Override
    public char getTargetClassEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public String getTargetClass() {
        return this.specifiedTargetClass != null ? this.specifiedTargetClass : this.defaultTargetClass;
    }

    @Override
    public String getSpecifiedTargetClass() {
        return this.specifiedTargetClass;
    }

    @Override
    public void setSpecifiedTargetClass(String targetClass) {
        String old = this.specifiedTargetClass;
        this.specifiedTargetClass = targetClass;
        ((XmlElementCollection)this.resourceAttributeMapping).setTargetClass(targetClass);
        this.firePropertyChanged("specifiedTargetClass", old, targetClass);
    }

    protected void setSpecifiedTargetClass_(String targetClass) {
        String old = this.specifiedTargetClass;
        this.specifiedTargetClass = targetClass;
        this.firePropertyChanged("specifiedTargetClass", old, targetClass);
    }

    @Override
    public String getDefaultTargetClass() {
        return this.defaultTargetClass;
    }

    protected void setDefaultTargetClass(String targetClass) {
        String old = this.defaultTargetClass;
        this.defaultTargetClass = targetClass;
        this.firePropertyChanged("defaultTargetClass", old, targetClass);
    }

    @Override
    public Embeddable getResolvedTargetEmbeddable() {
        return this.resolvedTargetEmbeddable;
    }

    protected void setResolvedTargetEmbeddable(Embeddable targetEmbeddable) {
        Embeddable old = this.resolvedTargetEmbeddable;
        this.resolvedTargetEmbeddable = targetEmbeddable;
        this.firePropertyChanged("resolvedTargetEmbeddable", old, targetEmbeddable);
    }

    @Override
    public PersistentType getResolvedTargetType() {
        return this.resolvedTargetType;
    }

    protected String getResourceTargetClass() {
        return ((XmlElementCollection)this.resourceAttributeMapping).getTargetClass();
    }

    protected String buildDefaultTargetClass() {
        if (this.getJavaPersistentAttribute() != null) {
            return this.getJavaPersistentAttribute().getMultiReferenceTargetTypeName();
        }
        return null;
    }

    protected PersistentType resolveTargetType() {
        return this.resolvePersistentType(this.getTargetClass());
    }

    protected Embeddable resolveTargetEmbeddable() {
        if (this.resolvedTargetType == null) {
            return null;
        }
        TypeMapping typeMapping = this.resolvedTargetType.getMapping();
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    @Override
    public FetchType getFetch() {
        return this.getSpecifiedFetch() == null ? this.getDefaultFetch() : this.getSpecifiedFetch();
    }

    @Override
    public FetchType getDefaultFetch() {
        return DEFAULT_FETCH_TYPE;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        ((XmlElementCollection)this.resourceAttributeMapping).setFetch(FetchType.toOrmResourceModel(newSpecifiedFetch));
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected void setSpecifiedFetch_(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected FetchType getResourceFetch() {
        return FetchType.fromOrmResourceModel(((XmlElementCollection)this.resourceAttributeMapping).getFetch());
    }

    @Override
    public OrmCollectionTable2_0 getCollectionTable() {
        return this.collectionTable;
    }

    public XmlCollectionTable getResourceCollectionTable() {
        return ((XmlElementCollection)this.resourceAttributeMapping).getCollectionTable();
    }

    @Override
    public OrmColumn getValueColumn() {
        return this.valueColumn;
    }

    protected XmlColumn getResourceColumn() {
        return ((XmlElementCollection)this.resourceAttributeMapping).getColumn();
    }

    @Override
    public OrmConverter getConverter() {
        return this.valueConverter;
    }

    protected String getConverterType() {
        return this.valueConverter.getType();
    }

    @Override
    public void setConverter(String converterType) {
        if (this.valuesAreEqual(this.getConverterType(), converterType)) {
            return;
        }
        OrmConverter oldConverter = this.valueConverter;
        OrmConverter newConverter = this.buildConverter(converterType);
        this.valueConverter = this.nullValueConverter;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.valueConverter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void setConverter(OrmConverter newConverter) {
        OrmConverter oldConverter = this.valueConverter;
        this.valueConverter = newConverter;
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected OrmConverter buildConverter(String converterType) {
        if (this.valuesAreEqual(converterType, "noConverter")) {
            return this.nullValueConverter;
        }
        if (this.valuesAreEqual(converterType, "enumeratedConverter")) {
            return this.getXmlContextNodeFactory().buildOrmEnumeratedConverter(this, (XmlConvertibleMapping)((Object)this.resourceAttributeMapping));
        }
        if (this.valuesAreEqual(converterType, "temporalConverter")) {
            return this.getXmlContextNodeFactory().buildOrmTemporalConverter(this, (XmlConvertibleMapping)((Object)this.resourceAttributeMapping));
        }
        if (this.valuesAreEqual(converterType, "lobConverter")) {
            return this.getXmlContextNodeFactory().buildOrmLobConverter(this, (XmlConvertibleMapping)((Object)this.resourceAttributeMapping));
        }
        return null;
    }

    protected String getResourceConverterType() {
        if (((XmlElementCollection)this.resourceAttributeMapping).getEnumerated() != null) {
            return "enumeratedConverter";
        }
        if (((XmlElementCollection)this.resourceAttributeMapping).getTemporal() != null) {
            return "temporalConverter";
        }
        if (((XmlElementCollection)this.resourceAttributeMapping).isLob()) {
            return "lobConverter";
        }
        return "noConverter";
    }

    protected void updateValueConverter() {
        if (this.valuesAreEqual(this.getResourceConverterType(), this.getConverterType())) {
            this.getConverter().update();
        } else {
            this.setConverter(this.buildConverter(this.getResourceConverterType()));
        }
    }

    @Override
    public CollectionMapping.Type getValueType() {
        return this.valueType;
    }

    protected void setValueType(CollectionMapping.Type newValueType) {
        CollectionMapping.Type old = this.valueType;
        this.valueType = newValueType;
        this.firePropertyChanged("valueType", (Object)old, (Object)newValueType);
    }

    protected CollectionMapping.Type buildValueType() {
        if (this.getResolvedTargetEmbeddable() != null) {
            return CollectionMapping.Type.EMBEDDABLE_TYPE;
        }
        if (this.getTargetClass() == null) {
            return CollectionMapping.Type.NO_TYPE;
        }
        return CollectionMapping.Type.BASIC_TYPE;
    }

    @Override
    public CollectionMapping.Type getKeyType() {
        return this.keyType;
    }

    protected void setKeyType(CollectionMapping.Type newKeyType) {
        CollectionMapping.Type old = this.keyType;
        this.keyType = newKeyType;
        this.firePropertyChanged("keyType", (Object)old, (Object)newKeyType);
    }

    protected CollectionMapping.Type buildKeyType() {
        if (this.getResolvedMapKeyEmbeddable() != null) {
            return CollectionMapping.Type.EMBEDDABLE_TYPE;
        }
        if (this.getResolvedMapKeyEntity() != null) {
            return CollectionMapping.Type.ENTITY_TYPE;
        }
        if (this.getMapKeyClass() == null) {
            return CollectionMapping.Type.NO_TYPE;
        }
        return CollectionMapping.Type.BASIC_TYPE;
    }

    @Override
    public OrmColumn getMapKeyColumn() {
        return this.mapKeyColumn;
    }

    protected XmlColumn getResourceMapKeyColumn() {
        return ((XmlElementCollection)this.resourceAttributeMapping).getMapKeyColumn();
    }

    @Override
    public OrmOrderable2_0 getOrderable() {
        return this.orderable;
    }

    protected Orderable2_0.Owner buildOrderableOwner() {
        return new Orderable2_0.Owner(){

            public String getTableName() {
                return AbstractOrmElementCollectionMapping2_0.this.getCollectionTable().getName();
            }

            public Table getDbTable(String tableName) {
                return AbstractOrmElementCollectionMapping2_0.this.getCollectionTable().getDbTable();
            }
        };
    }

    @Override
    public OrmAttributeOverrideContainer getValueAttributeOverrideContainer() {
        return this.valueAttributeOverrideContainer;
    }

    protected OrmAttributeOverrideContainer buildValueAttributeOverrideContainer() {
        return this.getXmlContextNodeFactory().buildOrmAttributeOverrideContainer(this, new ValueAttributeOverrideContainerOwner());
    }

    protected JavaAttributeOverride getJavaValueAttributeOverrideNamed(String attributeName) {
        if (this.getJavaElementCollectionMapping() != null) {
            return this.getJavaElementCollectionMapping().getValueAttributeOverrideContainer().getAttributeOverrideNamed(attributeName);
        }
        return null;
    }

    @Override
    public OrmAssociationOverrideContainer getValueAssociationOverrideContainer() {
        return this.valueAssociationOverrideContainer;
    }

    protected OrmAssociationOverrideContainer buildValueAssociationOverrideContainer() {
        return this.getXmlContextNodeFactory().buildOrmAssociationOverrideContainer(this, (OrmAssociationOverrideContainer.Owner)new AssociationOverrideContainerOwner());
    }

    protected JavaAssociationOverride getJavaValueAssociationOverrideNamed(String attributeName) {
        if (this.getJavaElementCollectionMapping() != null) {
            return this.getJavaElementCollectionMapping().getValueAssociationOverrideContainer().getAssociationOverrideNamed(attributeName);
        }
        return null;
    }

    protected JavaElementCollectionMapping2_0 getJavaElementCollectionMapping() {
        if (this.getJavaPersistentAttribute() == null) {
            return null;
        }
        JavaAttributeMapping javaAttributeMapping = this.getJavaPersistentAttribute().getMapping();
        if (javaAttributeMapping.getKey() == "elementCollection") {
            return (JavaElementCollectionMapping2_0)javaAttributeMapping;
        }
        return null;
    }

    @Override
    public OrmAttributeOverrideContainer getMapKeyAttributeOverrideContainer() {
        return this.mapKeyAttributeOverrideContainer;
    }

    protected OrmAttributeOverrideContainer buildMapKeyAttributeOverrideContainer() {
        return this.getXmlContextNodeFactory().buildOrmAttributeOverrideContainer(this, new MapKeyAttributeOverrideContainerOwner());
    }

    protected JavaAttributeOverride getJavaMapKeyAttributeOverrideNamed(String attributeName) {
        if (this.getJavaElementCollectionMapping() != null) {
            return this.getJavaElementCollectionMapping().getMapKeyAttributeOverrideContainer().getAttributeOverrideNamed(attributeName);
        }
        return null;
    }

    @Override
    public String getMapKey() {
        if (this.noMapKey) {
            return null;
        }
        if (this.pkMapKey) {
            return null;
        }
        if (this.customMapKey) {
            return this.specifiedMapKey;
        }
        throw new IllegalStateException("unknown map key");
    }

    @Override
    public String getSpecifiedMapKey() {
        return this.specifiedMapKey;
    }

    @Override
    public void setSpecifiedMapKey(String mapKey) {
        String old = this.specifiedMapKey;
        this.specifiedMapKey = mapKey;
        if (this.attributeValueHasChanged(old, mapKey)) {
            MapKey xmlMapKey = this.getXmlMapKey();
            if (mapKey == null) {
                if (xmlMapKey != null) {
                    this.removeXmlMapKey();
                }
            } else {
                if (xmlMapKey == null) {
                    xmlMapKey = this.addXmlMapKey();
                }
                xmlMapKey.setName(mapKey);
            }
        }
        this.firePropertyChanged("specifiedMapKey", old, mapKey);
    }

    protected void setSpecifiedMapKey_(String mapKey) {
        String old = this.specifiedMapKey;
        this.specifiedMapKey = mapKey;
        this.firePropertyChanged("specifiedMapKey", old, mapKey);
    }

    protected void initializeMapKey() {
        MapKey xmlMapKey = this.getXmlMapKey();
        if (xmlMapKey == null) {
            this.noMapKey = true;
        } else {
            this.specifiedMapKey = xmlMapKey.getName();
            if (this.specifiedMapKey == null) {
                this.pkMapKey = true;
            } else {
                this.customMapKey = true;
            }
        }
    }

    protected void updateMapKey() {
        MapKey xmlMapKey = this.getXmlMapKey();
        if (xmlMapKey == null) {
            this.setSpecifiedMapKey_(null);
            this.setNoMapKey_(true);
            this.setPkMapKey_(false);
            this.setCustomMapKey_(false);
        } else {
            String mk = xmlMapKey.getName();
            this.setSpecifiedMapKey_(mk);
            this.setNoMapKey_(false);
            this.setPkMapKey_(mk == null);
            this.setCustomMapKey_(mk != null);
        }
    }

    protected MapKey getXmlMapKey() {
        return ((XmlElementCollection)this.resourceAttributeMapping).getMapKey();
    }

    protected MapKey addXmlMapKey() {
        MapKey mapKey = OrmFactory.eINSTANCE.createMapKey();
        ((XmlElementCollection)this.resourceAttributeMapping).setMapKey(mapKey);
        return mapKey;
    }

    protected void removeXmlMapKey() {
        ((XmlElementCollection)this.resourceAttributeMapping).setMapKey(null);
    }

    @Override
    public Iterator<String> candidateMapKeyNames() {
        return this.allTargetEmbeddableAttributeNames();
    }

    public Iterator<String> allTargetEmbeddableAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<AttributeMapping, Iterator<String>>(this.allTargetEmbeddableAttributeMappings()){

            protected Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allMappingNames();
            }
        });
    }

    protected Iterator<String> allEmbeddableAttributeMappingNames() {
        return this.embeddableOverrideableMappingNames(new Transformer<AttributeMapping, Iterator<String>>(){

            public Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allMappingNames();
            }
        });
    }

    @Override
    public Iterator<String> allMappingNames() {
        return new CompositeIterator((Object)this.getName(), this.allEmbeddableAttributeMappingNames());
    }

    protected Iterator<AttributeMapping> allTargetEmbeddableAttributeMappings() {
        return this.resolvedTargetEmbeddable != null ? this.resolvedTargetEmbeddable.allAttributeMappings() : EmptyIterator.instance();
    }

    protected Iterator<AttributeMapping> embeddableAttributeMappings() {
        Embeddable targetEmbeddable = this.getResolvedTargetEmbeddable();
        if (targetEmbeddable != null && targetEmbeddable != this.getPersistentAttribute().getOwningTypeMapping()) {
            return targetEmbeddable.attributeMappings();
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allOverrideableAttributeMappingNames() {
        return this.embeddableOverrideableAttributeMappingNames();
    }

    protected Iterator<String> embeddableOverrideableAttributeMappingNames() {
        return this.embeddableOverrideableMappingNames(new Transformer<AttributeMapping, Iterator<String>>(){

            public Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAttributeMappingNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverrideableAssociationMappingNames() {
        return this.embeddableOverrideableAssociationMappingNames();
    }

    protected Iterator<String> embeddableOverrideableAssociationMappingNames() {
        return this.embeddableOverrideableMappingNames(new Transformer<AttributeMapping, Iterator<String>>(){

            public Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAssociationMappingNames();
            }
        });
    }

    protected Iterator<String> embeddableOverrideableMappingNames(Transformer<AttributeMapping, Iterator<String>> transformer) {
        return new TransformationIterator<String, String>((Iterator)new CompositeIterator((Iterator)new TransformationIterator(this.embeddableAttributeMappings(), transformer))){

            protected String transform(String next) {
                return String.valueOf(AbstractOrmElementCollectionMapping2_0.this.getName()) + '.' + next;
            }
        };
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        if (this.getName() == null) {
            return null;
        }
        int dotIndex = attributeName.indexOf(46);
        if (dotIndex != -1 && this.getName().equals(attributeName.substring(0, dotIndex))) {
            attributeName = attributeName.substring(dotIndex + 1);
            OrmAttributeOverride override = this.getValueAttributeOverrideContainer().getAttributeOverrideNamed(attributeName);
            if (override != null && !override.isVirtual()) {
                return override.getColumn();
            }
            if (this.getResolvedTargetEmbeddable() == null) {
                return null;
            }
            return this.getResolvedTargetEmbeddable().resolveOverriddenColumn(attributeName);
        }
        return null;
    }

    protected Iterator<String> embeddableAttributeMappingNames() {
        return new TransformationIterator<String, String>((Iterator)new CompositeIterator((Iterator)new TransformationIterator<AttributeMapping, Iterator<String>>(this.embeddableAttributeMappings()){

            protected Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allMappingNames();
            }
        })){

            protected String transform(String next) {
                return String.valueOf(AbstractOrmElementCollectionMapping2_0.this.getName()) + '.' + next;
            }
        };
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String attributeName) {
        if (this.getName() == null) {
            return null;
        }
        AttributeMapping resolvedMapping = super.resolveAttributeMapping(attributeName);
        if (resolvedMapping != null) {
            return resolvedMapping;
        }
        int dotIndex = attributeName.indexOf(46);
        if (dotIndex != -1 && this.getName().equals(attributeName.substring(0, dotIndex))) {
            for (AttributeMapping attributeMapping : CollectionTools.iterable(this.embeddableAttributeMappings())) {
                resolvedMapping = attributeMapping.resolveAttributeMapping(attributeName.substring(dotIndex + 1));
                if (resolvedMapping == null) continue;
                return resolvedMapping;
            }
        }
        return null;
    }

    @Override
    public RelationshipReference resolveRelationshipReference(String attributeName) {
        if (this.getName() == null) {
            return null;
        }
        int dotIndex = attributeName.indexOf(46);
        if (dotIndex != -1 && this.getName().equals(attributeName.substring(0, dotIndex))) {
            attributeName = attributeName.substring(dotIndex + 1);
            OrmAssociationOverride override = this.getValueAssociationOverrideContainer().getAssociationOverrideNamed(attributeName);
            if (override != null && !override.isVirtual()) {
                return override.getRelationshipReference();
            }
            if (this.getResolvedTargetEmbeddable() == null) {
                return null;
            }
            return this.getResolvedTargetEmbeddable().resolveRelationshipReference(attributeName);
        }
        return null;
    }

    @Override
    public boolean isNoMapKey() {
        return this.noMapKey;
    }

    @Override
    public void setNoMapKey(boolean noMapKey) {
        boolean old = this.noMapKey;
        this.noMapKey = noMapKey;
        if (noMapKey && this.getXmlMapKey() != null) {
            this.removeXmlMapKey();
        }
        this.firePropertyChanged("noMapKey", old, noMapKey);
    }

    protected void setNoMapKey_(boolean noMapKey) {
        boolean old = this.noMapKey;
        this.noMapKey = noMapKey;
        this.firePropertyChanged("noMapKey", old, noMapKey);
    }

    @Override
    public boolean isPkMapKey() {
        return this.pkMapKey;
    }

    @Override
    public void setPkMapKey(boolean pkMapKey) {
        boolean old = this.pkMapKey;
        this.pkMapKey = pkMapKey;
        MapKey xmlMapKey = this.getXmlMapKey();
        if (pkMapKey) {
            if (xmlMapKey == null) {
                this.addXmlMapKey();
            } else {
                xmlMapKey.setName(null);
            }
        }
        this.firePropertyChanged("pkMapKey", old, pkMapKey);
    }

    protected void setPkMapKey_(boolean pkMapKey) {
        boolean old = this.pkMapKey;
        this.pkMapKey = pkMapKey;
        this.firePropertyChanged("pkMapKey", old, pkMapKey);
    }

    @Override
    public boolean isCustomMapKey() {
        return this.customMapKey;
    }

    @Override
    public void setCustomMapKey(boolean customMapKey) {
        boolean old = this.customMapKey;
        this.customMapKey = customMapKey;
        if (customMapKey) {
            this.setSpecifiedMapKey("");
        }
        this.firePropertyChanged("customMapKey", old, customMapKey);
    }

    protected void setCustomMapKey_(boolean customMapKey) {
        boolean old = this.customMapKey;
        this.customMapKey = customMapKey;
        this.firePropertyChanged("customMapKey", old, customMapKey);
    }

    @Override
    public char getMapKeyClassEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public String getMapKeyClass() {
        return this.specifiedMapKeyClass != null ? this.specifiedMapKeyClass : this.defaultMapKeyClass;
    }

    @Override
    public String getSpecifiedMapKeyClass() {
        return this.specifiedMapKeyClass;
    }

    @Override
    public void setSpecifiedMapKeyClass(String mapKeyClass) {
        String old = this.specifiedMapKeyClass;
        this.specifiedMapKeyClass = mapKeyClass;
        if (this.attributeValueHasChanged(old, mapKeyClass)) {
            XmlClassReference xmlMapKeyClass = this.getXmlMapKeyClass();
            if (mapKeyClass == null) {
                if (xmlMapKeyClass != null) {
                    this.removeXmlMapKeyClass();
                }
            } else {
                if (xmlMapKeyClass == null) {
                    xmlMapKeyClass = this.addXmlMapKeyClass();
                }
                xmlMapKeyClass.setClassName(mapKeyClass);
            }
        }
        this.firePropertyChanged("specifiedMapKeyClass", old, mapKeyClass);
    }

    protected void setSpecifiedMapKeyClass_(String mapKeyClass) {
        String old = this.specifiedMapKeyClass;
        this.specifiedMapKeyClass = mapKeyClass;
        this.firePropertyChanged("specifiedMapKeyClass", old, mapKeyClass);
    }

    protected XmlClassReference getXmlMapKeyClass() {
        return ((XmlElementCollection)this.resourceAttributeMapping).getMapKeyClass();
    }

    protected XmlClassReference addXmlMapKeyClass() {
        XmlClassReference mapKeyClass = OrmFactory.eINSTANCE.createXmlClassReference();
        ((XmlElementCollection)this.resourceAttributeMapping).setMapKeyClass(mapKeyClass);
        return mapKeyClass;
    }

    protected void removeXmlMapKeyClass() {
        ((XmlElementCollection)this.resourceAttributeMapping).setMapKeyClass(null);
    }

    @Override
    public String getDefaultMapKeyClass() {
        return this.defaultMapKeyClass;
    }

    protected void setDefaultMapKeyClass(String mapKeyClass) {
        String old = this.defaultMapKeyClass;
        this.defaultMapKeyClass = mapKeyClass;
        this.firePropertyChanged("defaultMapKeyClass", old, mapKeyClass);
    }

    protected String getResourceMapKeyClass() {
        XmlClassReference mapKeyClass = ((XmlElementCollection)this.resourceAttributeMapping).getMapKeyClass();
        return mapKeyClass == null ? null : mapKeyClass.getClassName();
    }

    protected String buildDefaultMapKeyClass() {
        if (this.getJavaPersistentAttribute() != null) {
            return this.getJavaPersistentAttribute().getMultiReferenceMapKeyTypeName();
        }
        return null;
    }

    @Override
    public Embeddable getResolvedMapKeyEmbeddable() {
        return this.resolvedMapKeyEmbeddable;
    }

    protected void setResolvedMapKeyEmbeddable(Embeddable embeddable) {
        Embeddable old = this.resolvedMapKeyEmbeddable;
        this.resolvedMapKeyEmbeddable = embeddable;
        this.firePropertyChanged("resolvedMapKeyEmbeddable", old, embeddable);
    }

    @Override
    public Entity getResolvedMapKeyEntity() {
        return this.resolvedMapKeyEntity;
    }

    protected void setResolvedMapKeyEntity(Entity entity) {
        Entity old = this.resolvedMapKeyEntity;
        this.resolvedMapKeyEntity = entity;
        this.firePropertyChanged("resolvedMapKeyEntity", old, entity);
    }

    public PersistentType getResolvedMapKeyType() {
        return this.getResolvedMapKeyEmbeddable() == null ? null : this.getResolvedMapKeyEmbeddable().getPersistentType();
    }

    protected PersistentType resolveMapKeyType() {
        return this.resolvePersistentType(this.getMapKeyClass());
    }

    protected Embeddable resolveMapKeyEmbeddable() {
        if (this.resolvedMapKeyType == null) {
            return null;
        }
        TypeMapping typeMapping = this.resolvedMapKeyType.getMapping();
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    protected Entity resolveMapKeyEntity() {
        if (this.resolvedMapKeyType == null) {
            return null;
        }
        TypeMapping typeMapping = this.resolvedMapKeyType.getMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    protected String getMetamodelFieldTypeName() {
        return ((PersistentAttribute2_0)((Object)this.getPersistentAttribute())).getMetamodelContainerFieldTypeName();
    }

    @Override
    public String getMetamodelTypeName() {
        if (this.valueType == CollectionMapping.Type.BASIC_TYPE) {
            return this.getTargetClass();
        }
        if (this.resolvedTargetType == null) {
            return MetamodelField.DEFAULT_TYPE_NAME;
        }
        String targetTypeName = this.resolvedTargetType.getName();
        return targetTypeName != null ? targetTypeName : MetamodelField.DEFAULT_TYPE_NAME;
    }

    @Override
    protected void addMetamodelFieldTypeArgumentNamesTo(ArrayList<String> typeArgumentNames) {
        this.addMetamodelFieldMapKeyTypeArgumentNameTo(typeArgumentNames);
        super.addMetamodelFieldTypeArgumentNamesTo(typeArgumentNames);
    }

    protected void addMetamodelFieldMapKeyTypeArgumentNameTo(ArrayList<String> typeArgumentNames) {
        String keyTypeName = ((PersistentAttribute2_0)((Object)this.getPersistentAttribute())).getMetamodelContainerFieldMapKeyTypeName();
        if (keyTypeName != null) {
            typeArgumentNames.add(keyTypeName);
        }
    }

    @Override
    public String getMetamodelFieldMapKeyTypeName() {
        return MappingTools.getMetamodelFieldMapKeyTypeName(this);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateTargetClass(messages);
        this.validateMapKeyClass(messages);
        this.getOrderable().validate(messages, reporter);
        this.getCollectionTable().validate(messages, reporter);
        this.validateValue(messages, reporter);
        this.validateMapKey(messages, reporter);
    }

    public void validateValue(List<IMessage> messages, IReporter reporter) {
        if (this.getValueType() == CollectionMapping.Type.BASIC_TYPE) {
            this.getValueColumn().validate(messages, reporter);
            this.getConverter().validate(messages, reporter);
        }
        if (this.getValueType() == CollectionMapping.Type.EMBEDDABLE_TYPE) {
            this.getValueAttributeOverrideContainer().validate(messages, reporter);
            this.getValueAssociationOverrideContainer().validate(messages, reporter);
        }
    }

    public void validateMapKey(List<IMessage> messages, IReporter reporter) {
        if (this.getMapKey() != null) {
            return;
        }
        if (this.getKeyType() == CollectionMapping.Type.BASIC_TYPE) {
            this.getMapKeyColumn().validate(messages, reporter);
        } else if (this.getKeyType() != CollectionMapping.Type.ENTITY_TYPE && this.getKeyType() == CollectionMapping.Type.EMBEDDABLE_TYPE) {
            this.getMapKeyAttributeOverrideContainer().validate(messages, reporter);
        }
    }

    protected void validateTargetClass(List<IMessage> messages) {
        if (this.getTargetClass() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_NOT_DEFINED", new String[]{this.getName()}, this, this.getValidationTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ELEMENT_COLLECTION_TARGET_CLASS_NOT_DEFINED", new String[0], this, this.getValidationTextRange()));
            }
        }
        if (this.resolvedTargetType != null && this.getResolvedTargetEmbeddable() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_MUST_BE_EMBEDDABLE_OR_BASIC_TYPE", new String[]{this.getName(), this.getTargetClass()}, this, this.getValidationTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ELEMENT_COLLECTION_TARGET_CLASS_MUST_BE_EMBEDDABLE_OR_BASIC_TYPE", new String[]{this.getTargetClass(), this.getName()}, this, this.getTargetClassTextRange()));
            }
        }
    }

    protected void validateMapKeyClass(List<IMessage> messages) {
        if (this.getJavaPersistentAttribute() != null && !this.getJavaPersistentAttribute().getJpaContainer().isMap()) {
            return;
        }
        if (this.getMapKeyClass() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_MAP_KEY_CLASS_NOT_DEFINED", new String[]{this.getName()}, this, this.getValidationTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ELEMENT_COLLECTION_MAP_KEY_CLASS_NOT_DEFINED", new String[0], this, this.getValidationTextRange()));
            }
        }
    }

    protected TextRange getTargetClassTextRange() {
        return ((XmlElementCollection)this.resourceAttributeMapping).getTargetClassTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AssociationOverrideContainerOwner
    extends OverrideContainerOwner
    implements OrmAssociationOverrideContainer.Owner {
        protected AssociationOverrideContainerOwner() {
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractOrmElementCollectionMapping2_0.this.getResolvedTargetEmbeddable();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : typeMapping.allOverridableAssociationNames();
        }

        @Override
        public EList<XmlAssociationOverride> getResourceAssociationOverrides() {
            return ((XmlElementCollection)AbstractOrmElementCollectionMapping2_0.this.resourceAttributeMapping).getAssociationOverrides();
        }

        @Override
        public RelationshipReference resolveRelationshipReference(String associationOverrideName) {
            JavaAssociationOverride javaAssociationOverride;
            if (AbstractOrmElementCollectionMapping2_0.this.getPersistentAttribute().isVirtual() && !this.getTypeMapping().isMetadataComplete() && (javaAssociationOverride = AbstractOrmElementCollectionMapping2_0.this.getJavaValueAssociationOverrideNamed(associationOverrideName)) != null && !javaAssociationOverride.isVirtual()) {
                return javaAssociationOverride.getRelationshipReference();
            }
            return MappingTools.resolveRelationshipReference(this.getOverridableTypeMapping(), associationOverrideName);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualAttributeColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualAttributeColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID", new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualAttributeColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualAttributeColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedReferencedColumnNameMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualAttributeColumnUnresolvedReferencedColumnNameMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnUnresolvedReferencedColumnNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME", new String[]{column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualAttributeColumnUnresolvedReferencedColumnNameMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), overrideName, column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnUnresolvedReferencedColumnNameMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME", new String[]{overrideName, column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualAttributeUnspecifiedNameMultipleJoinColumnsMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideUnspecifiedNameMultipleJoinColumnsMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualAttributeUnspecifiedNameMultipleJoinColumnsMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), overrideName}, column, textRange);
        }

        protected IMessage buildVirtualOverrideUnspecifiedNameMultipleJoinColumnsMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{overrideName}, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualAttributeUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualAttributeUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), overrideName}, column, textRange);
        }

        protected IMessage buildVirtualOverrideUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{overrideName}, column, textRange);
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractOrmElementCollectionMapping2_0.this.getValidationTextRange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ColumnOwner
    implements OrmColumn.Owner {
        protected ColumnOwner() {
        }

        @Override
        public String getDefaultTableName() {
            return AbstractOrmElementCollectionMapping2_0.this.getCollectionTable().getName();
        }

        @Override
        public TypeMapping getTypeMapping() {
            return AbstractOrmElementCollectionMapping2_0.this.getTypeMapping();
        }

        @Override
        public Table getDbTable(String tableName) {
            if (AbstractOrmElementCollectionMapping2_0.this.getCollectionTable().getName().equals(tableName)) {
                return AbstractOrmElementCollectionMapping2_0.this.getCollectionTable().getDbTable();
            }
            return null;
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return EmptyIterator.instance();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return !StringTools.stringsAreEqual((String)this.getDefaultTableName(), (String)tableName);
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractOrmElementCollectionMapping2_0.this.getValidationTextRange();
        }

        @Override
        public IMessage buildTableNotValidMessage(BaseColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualTableNotValidMessage(column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, this.getColumnTableNotValidMessage(), new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualTableNotValidMessage(BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualAttributeColumnTableNotValidMessage(), new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        @Override
        public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualUnresolvedNameMessage(column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, this.getColumnUnresolvedNameMessage(), new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualAttributeColumnUnresolvedNameMessage(), new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected abstract String getColumnTableNotValidMessage();

        protected abstract String getVirtualAttributeColumnTableNotValidMessage();

        protected abstract String getColumnUnresolvedNameMessage();

        protected abstract String getVirtualAttributeColumnUnresolvedNameMessage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MapKeyAttributeOverrideContainerOwner
    extends OverrideContainerOwner
    implements OrmAttributeOverrideContainer.Owner {
        protected MapKeyAttributeOverrideContainerOwner() {
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractOrmElementCollectionMapping2_0.this.getResolvedMapKeyEmbeddable();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : typeMapping.allOverridableAttributeNames();
        }

        @Override
        public EList<XmlAttributeOverride> getResourceAttributeOverrides() {
            return ((XmlElementCollection)AbstractOrmElementCollectionMapping2_0.this.resourceAttributeMapping).getMapKeyAttributeOverrides();
        }

        @Override
        public Column resolveOverriddenColumn(String attributeOverrideName) {
            JavaAttributeOverride javaAttributeOverride;
            if (AbstractOrmElementCollectionMapping2_0.this.getPersistentAttribute().isVirtual() && !this.getTypeMapping().isMetadataComplete() && (javaAttributeOverride = AbstractOrmElementCollectionMapping2_0.this.getJavaMapKeyAttributeOverrideNamed(attributeOverrideName)) != null && !javaAttributeOverride.isVirtual()) {
                return javaAttributeOverride.getColumn();
            }
            return MappingTools.resolveOverridenColumn(this.getOverridableTypeMapping(), attributeOverrideName);
        }

        @Override
        public XmlColumn buildVirtualXmlColumn(Column overridableColumn, String attributeName, boolean isMetadataComplete) {
            return new VirtualXmlAttributeOverrideColumn(overridableColumn);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualAttributeColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualAttributeColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualAttributeColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualAttributeColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractOrmElementCollectionMapping2_0.this.getValidationTextRange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MapKeyColumnOwner
    extends ColumnOwner {
        protected MapKeyColumnOwner() {
        }

        @Override
        public XmlColumn getResourceColumn() {
            return ((XmlElementCollection)AbstractOrmElementCollectionMapping2_0.this.resourceAttributeMapping).getMapKeyColumn();
        }

        @Override
        public void addResourceColumn() {
            ((XmlElementCollection)AbstractOrmElementCollectionMapping2_0.this.resourceAttributeMapping).setMapKeyColumn(OrmFactory.eINSTANCE.createXmlColumn());
        }

        @Override
        public void removeResourceColumn() {
            ((XmlElementCollection)AbstractOrmElementCollectionMapping2_0.this.resourceAttributeMapping).setMapKeyColumn(null);
        }

        @Override
        public String getDefaultColumnName() {
            return String.valueOf(AbstractOrmElementCollectionMapping2_0.this.getName()) + "_KEY";
        }

        @Override
        protected String getColumnTableNotValidMessage() {
            return "MAP_KEY_COLUMN_TABLE_NOT_VALID";
        }

        @Override
        protected String getVirtualAttributeColumnTableNotValidMessage() {
            return "VIRTUAL_ATTRIBUTE_MAP_KEY_COLUMN_TABLE_NOT_VALID";
        }

        @Override
        public String getColumnUnresolvedNameMessage() {
            return "MAP_KEY_COLUMN_UNRESOLVED_NAME";
        }

        @Override
        public String getVirtualAttributeColumnUnresolvedNameMessage() {
            return "VIRTUAL_ATTRIBUTE_MAP_KEY_COLUMN_UNRESOLVED_NAME";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class OverrideContainerOwner
    implements OrmOverrideContainer.Owner {
        protected OverrideContainerOwner() {
        }

        @Override
        public OrmTypeMapping getTypeMapping() {
            return AbstractOrmElementCollectionMapping2_0.this.getTypeMapping();
        }

        @Override
        public String getDefaultTableName() {
            return AbstractOrmElementCollectionMapping2_0.this.getCollectionTable().getName();
        }

        @Override
        public Table getDbTable(String tableName) {
            return AbstractOrmElementCollectionMapping2_0.this.getCollectionTable().getDbTable();
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return EmptyIterator.instance();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return !StringTools.stringsAreEqual((String)this.getDefaultTableName(), (String)tableName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueAttributeOverrideContainerOwner
    extends OverrideContainerOwner
    implements OrmAttributeOverrideContainer.Owner {
        protected ValueAttributeOverrideContainerOwner() {
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractOrmElementCollectionMapping2_0.this.getResolvedTargetEmbeddable();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : typeMapping.allOverridableAttributeNames();
        }

        @Override
        public EList<XmlAttributeOverride> getResourceAttributeOverrides() {
            return ((XmlElementCollection)AbstractOrmElementCollectionMapping2_0.this.resourceAttributeMapping).getAttributeOverrides();
        }

        @Override
        public Column resolveOverriddenColumn(String attributeOverrideName) {
            JavaAttributeOverride javaAttributeOverride;
            if (AbstractOrmElementCollectionMapping2_0.this.getPersistentAttribute().isVirtual() && !this.getTypeMapping().isMetadataComplete() && (javaAttributeOverride = AbstractOrmElementCollectionMapping2_0.this.getJavaValueAttributeOverrideNamed(attributeOverrideName)) != null && !javaAttributeOverride.isVirtual()) {
                return javaAttributeOverride.getColumn();
            }
            return MappingTools.resolveOverridenColumn(this.getOverridableTypeMapping(), attributeOverrideName);
        }

        @Override
        public XmlColumn buildVirtualXmlColumn(Column overridableColumn, String attributeName, boolean isMetadataComplete) {
            return new VirtualXmlAttributeOverrideColumn(overridableColumn);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualAttributeColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualAttributeColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (AbstractOrmElementCollectionMapping2_0.this.isVirtual()) {
                return this.buildVirtualAttributeColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualAttributeColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{AbstractOrmElementCollectionMapping2_0.this.getName(), overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractOrmElementCollectionMapping2_0.this.getValidationTextRange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueColumnOwner
    extends ColumnOwner {
        protected ValueColumnOwner() {
        }

        @Override
        public XmlColumn getResourceColumn() {
            return ((XmlElementCollection)AbstractOrmElementCollectionMapping2_0.this.resourceAttributeMapping).getColumn();
        }

        @Override
        public void addResourceColumn() {
            ((XmlElementCollection)AbstractOrmElementCollectionMapping2_0.this.resourceAttributeMapping).setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        }

        @Override
        public void removeResourceColumn() {
            ((XmlElementCollection)AbstractOrmElementCollectionMapping2_0.this.resourceAttributeMapping).setColumn(null);
        }

        @Override
        public String getDefaultColumnName() {
            return AbstractOrmElementCollectionMapping2_0.this.getName();
        }

        @Override
        public String getColumnTableNotValidMessage() {
            return "COLUMN_TABLE_NOT_VALID";
        }

        @Override
        public String getVirtualAttributeColumnTableNotValidMessage() {
            return "VIRTUAL_ATTRIBUTE_COLUMN_TABLE_NOT_VALID";
        }

        @Override
        public String getColumnUnresolvedNameMessage() {
            return "COLUMN_UNRESOLVED_NAME";
        }

        @Override
        public String getVirtualAttributeColumnUnresolvedNameMessage() {
            return "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME";
        }
    }
}

