/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa2;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.jpa2.JpaProject2_0;
import org.eclipse.jpt.core.jpa2.context.AttributeMapping2_0;
import org.eclipse.jpt.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.core.jpa2.context.MetamodelSourceType;
import org.eclipse.jpt.core.jpa2.resource.java.JavaResourcePersistentType2_0;
import org.eclipse.jpt.core.utility.BodySourceWriter;
import org.eclipse.jpt.utility.internal.ClassName;
import org.eclipse.jpt.utility.internal.SimpleStack;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMetamodelSynchronizer
implements MetamodelSourceType.Synchronizer {
    protected final MetamodelSourceType sourceType;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public GenericMetamodelSynchronizer(MetamodelSourceType sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public IFile getFile() {
        return (IFile)this.getPackageFragment().getCompilationUnit(this.getFileName()).getResource();
    }

    @Override
    public void synchronize(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        try {
            this.synchronize_(memberTypeTree);
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
        }
    }

    protected void synchronize_(Map<String, Collection<MetamodelSourceType>> memberTypeTree) throws JavaModelException {
        String fileName;
        IPackageFragment pkg = this.getPackageFragment();
        ICompilationUnit compilationUnit = pkg.getCompilationUnit(fileName = this.getFileName());
        if (compilationUnit.exists()) {
            String newSource = this.buildSource(compilationUnit, memberTypeTree);
            if (newSource != null) {
                pkg.createCompilationUnit(fileName, newSource, true, null);
            }
        } else {
            if (!pkg.exists()) {
                this.getSourceFolder().createPackageFragment(pkg.getElementName(), true, null);
            }
            pkg.createCompilationUnit(fileName, this.buildSource(memberTypeTree), false, null);
        }
    }

    protected String buildSource(ICompilationUnit compilationUnit, Map<String, Collection<MetamodelSourceType>> memberTypeTree) throws JavaModelException {
        IFile file = (IFile)compilationUnit.getResource();
        JavaResourcePersistentType2_0 genType = this.getJpaProject().getGeneratedMetamodelTopLevelType(file);
        if (genType == null) {
            return null;
        }
        String oldSource = compilationUnit.getSource();
        int oldLength = oldSource.length();
        String newSource = this.buildSource(memberTypeTree);
        int newLength = newSource.length();
        if (newLength != oldLength) {
            return newSource;
        }
        String date = genType.getGeneratedAnnotation().getDate();
        int dateBegin = oldSource.indexOf(date);
        if (dateBegin == -1) {
            return null;
        }
        int dateEnd = dateBegin + date.length();
        if (dateEnd > oldLength) {
            return null;
        }
        if (newSource.regionMatches(0, oldSource, 0, dateBegin) && newSource.regionMatches(dateEnd, oldSource, dateEnd, oldLength - dateEnd)) {
            return null;
        }
        return newSource;
    }

    protected IPackageFragment getPackageFragment() {
        return this.getSourceFolder().getPackageFragment(this.getPackageName());
    }

    protected IPackageFragmentRoot getSourceFolder() {
        return this.getJpaProject().getMetamodelPackageFragmentRoot();
    }

    protected JpaProject2_0 getJpaProject() {
        return (JpaProject2_0)this.sourceType.getJpaProject();
    }

    protected String getPackageName() {
        return this.buildPackageName(this.sourceType.getName());
    }

    protected String buildPackageName(String topLevelSourceTypeName) {
        return this.buildPackageName_(ClassName.getPackageName((String)topLevelSourceTypeName));
    }

    protected String buildPackageName_(String sourcePackageName) {
        return sourcePackageName;
    }

    protected String getFileName() {
        return String.valueOf(ClassName.getSimpleName((String)this.getClassName())) + ".java";
    }

    protected String getClassName() {
        return this.buildClassName(this.sourceType.getName());
    }

    protected String buildClassName(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        return this.buildClassName(this.sourceType.getName(), memberTypeTree);
    }

    protected String buildClassName(String sourceTypeName, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        String current = sourceTypeName;
        SimpleStack stack = new SimpleStack();
        while (true) {
            stack.push((Object)ClassName.getSimpleName((String)current));
            String declaringTypeName = this.getDeclaringTypeName(current, memberTypeTree);
            if (declaringTypeName == null) break;
            current = declaringTypeName;
        }
        StringBuilder sb = new StringBuilder(sourceTypeName.length() + 10);
        sb.append(this.buildPackageName(current));
        while (!stack.isEmpty()) {
            sb.append('.');
            sb.append(this.buildSimpleClassName((String)stack.pop()));
        }
        return sb.toString();
    }

    protected String buildClassName(String topLevelSourceTypeName) {
        return String.valueOf(this.buildPackageName(topLevelSourceTypeName)) + '.' + this.buildSimpleClassName(ClassName.getSimpleName((String)topLevelSourceTypeName));
    }

    protected String getSimpleClassName() {
        return this.buildSimpleClassName(ClassName.getSimpleName((String)this.sourceType.getName()));
    }

    protected String buildSimpleClassName(String simpleSourceTypeName) {
        return String.valueOf(simpleSourceTypeName) + '_';
    }

    protected String buildSource(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        BodySourceWriter bodySourceWriter = this.buildBodySourceWriter(memberTypeTree);
        StringWriter sw = new StringWriter(bodySourceWriter.getLength() + 2000);
        PrintWriter pw = new PrintWriter(sw);
        this.printPackageAndImportsOn(pw, bodySourceWriter);
        pw.print(bodySourceWriter.getSource());
        return sw.toString();
    }

    protected BodySourceWriter buildBodySourceWriter(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        BodySourceWriter pw = new BodySourceWriter(this.getPackageName(), this.getClassName());
        this.printBodySourceOn(pw, memberTypeTree);
        return pw;
    }

    @Override
    public void printBodySourceOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        this.printClassDeclarationOn(pw, memberTypeTree);
        pw.print(" {");
        pw.println();
        pw.indent();
        boolean attributesPrinted = this.printAttributesOn(pw);
        this.printMemberTypesOn(pw, memberTypeTree, attributesPrinted);
        pw.undent();
        pw.print('}');
        pw.println();
    }

    protected void printClassDeclarationOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        boolean topLevel = this.sourceTypeIsTopLevel(memberTypeTree);
        if (topLevel) {
            this.printGeneratedAnnotationOn(pw);
        }
        if (this.sourceType.isManaged()) {
            this.printStaticMetamodelAnnotationOn(pw);
        }
        pw.print("public ");
        if (!topLevel) {
            pw.print("static ");
        }
        pw.print("class ");
        pw.print(this.getSimpleClassName());
        PersistentType superPersistentType = this.sourceType.getSuperPersistentType();
        if (superPersistentType != null) {
            pw.print(" extends ");
            pw.printTypeDeclaration(this.buildClassName(superPersistentType.getName(), memberTypeTree));
        }
    }

    protected boolean sourceTypeIsTopLevel(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        return this.sourceTypeIsTopLevel(this.sourceType.getName(), memberTypeTree);
    }

    protected boolean sourceTypeIsTopLevel(String sourceTypeName, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        return this.getDeclaringTypeName(sourceTypeName, memberTypeTree) == null;
    }

    protected String getDeclaringTypeName(String sourceTypeName, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        int lastPeriod = sourceTypeName.lastIndexOf(46);
        if (lastPeriod == -1) {
            return null;
        }
        String declaringTypeName = sourceTypeName.substring(0, lastPeriod);
        return memberTypeTree.get(declaringTypeName) == null ? null : declaringTypeName;
    }

    protected void printGeneratedAnnotationOn(BodySourceWriter pw) {
        pw.printAnnotation("javax.annotation.Generated");
        pw.print('(');
        pw.print("value=");
        pw.printStringLiteral("Dali");
        pw.print(", ");
        pw.print("date=");
        pw.printStringLiteral(GenericMetamodelSynchronizer.format(new Date()));
        pw.print(')');
        pw.println();
    }

    protected void printStaticMetamodelAnnotationOn(BodySourceWriter pw) {
        pw.printAnnotation("javax.persistence.metamodel.StaticMetamodel");
        pw.print('(');
        pw.printTypeDeclaration(this.sourceType.getName());
        pw.print(".class");
        pw.print(')');
        pw.println();
    }

    protected static synchronized String format(Date date) {
        return DATE_FORMAT.format(date);
    }

    protected boolean printAttributesOn(BodySourceWriter pw) {
        boolean printed = false;
        ListIterator stream = this.sourceType.attributes();
        while (stream.hasNext()) {
            this.printAttributeOn((PersistentAttribute)stream.next(), pw);
            printed = true;
        }
        return printed;
    }

    protected void printAttributeOn(PersistentAttribute persistentAttribute, BodySourceWriter pw) {
        AttributeMapping attributeMapping = persistentAttribute.getMapping();
        if (attributeMapping != null) {
            this.printAttributeMappingOn(attributeMapping, pw);
        }
    }

    protected void printAttributeMappingOn(AttributeMapping attributeMapping, BodySourceWriter pw) {
        MetamodelField field = ((AttributeMapping2_0)attributeMapping).getMetamodelField();
        if (field != null) {
            this.printFieldOn(field, pw);
        }
    }

    protected void printFieldOn(MetamodelField field, BodySourceWriter pw) {
        for (String modifier : field.getModifiers()) {
            pw.print(modifier);
            pw.print(' ');
        }
        pw.printTypeDeclaration(field.getTypeName());
        pw.print('<');
        Iterator<String> stream = field.getTypeArgumentNames().iterator();
        while (stream.hasNext()) {
            pw.printTypeDeclaration(stream.next());
            if (!stream.hasNext()) continue;
            pw.print(", ");
        }
        pw.print('>');
        pw.print(' ');
        pw.print(field.getName());
        pw.print(';');
        pw.println();
    }

    protected void printMemberTypesOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType>> memberTypeTree, boolean attributesPrinted) {
        Collection<MetamodelSourceType> memberTypes = memberTypeTree.get(this.sourceType.getName());
        if (memberTypes != null) {
            if (attributesPrinted) {
                pw.println();
            }
            Iterator<MetamodelSourceType> stream = memberTypes.iterator();
            while (stream.hasNext()) {
                stream.next().printBodySourceOn(pw, memberTypeTree);
                if (!stream.hasNext()) continue;
                pw.println();
            }
        }
    }

    protected void printPackageAndImportsOn(PrintWriter pw, BodySourceWriter bodySourceWriter) {
        if (this.getPackageName().length() != 0) {
            pw.print("package ");
            pw.print(this.getPackageName());
            pw.print(';');
            pw.println();
            pw.println();
        }
        for (String import_ : bodySourceWriter.getImports()) {
            pw.print("import ");
            pw.print(import_);
            pw.print(';');
            pw.println();
        }
        pw.println();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.sourceType.getName());
    }
}

