/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.LocaleConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.SupportedLocaleType;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.jst.jsf.validation.internal.appconfig.ClassNameEObjectValidationVisitor;
import org.eclipse.jst.jsf.validation.internal.appconfig.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.appconfig.EObjectValidationVisitor;

public class ApplicationValidationVisitor
extends EObjectValidationVisitor {
    public ApplicationValidationVisitor(String version) {
        super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getFacesConfigType_Application(), version);
    }

    protected void doValidate(EObject object, List messages, IFile file) {
    }

    protected EObjectValidationVisitor[] getChildNodeValidators() {
        return new EObjectValidationVisitor[]{new ActionListenerValidationVisitor(this.getVersion()), new NavigationHandlerValidationVisitor(this.getVersion()), new ViewHandlerValidationVisitor(this.getVersion()), new StateManagerValidationVisitior(this.getVersion()), new PropertyResolverValidationVisitor(this.getVersion()), new VariableResolverValidationVisitor(this.getVersion()), new ELResolverValidationVisitor(this.getVersion()), new LocaleConfigValidationVisitor(this.getVersion()), new ResourceHandlerValidationVisitor(this.getVersion()), new SystemEventListenerTypeValidationVisitor(this.getVersion()), new DefaultValidatorsValidationVisitor(this.getVersion())};
    }

    protected void validateManagedBeanNames(FacesConfigType facesConfig, List messages, IFile file) {
    }

    private static class ActionListenerValidationVisitor
    extends ApplicationClassNameBasedValidationVisitor {
        public ActionListenerValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_ActionListener(), version, "javax.faces.event.ActionListener", true);
        }
    }

    private static abstract class ApplicationClassNameBasedValidationVisitor
    extends ClassNameEObjectValidationVisitor {
        private final String _instanceOf;
        private final boolean _mustBeClass;

        protected ApplicationClassNameBasedValidationVisitor(EStructuralFeature feature, String version, String instanceOf, boolean mustBeClass) {
            super(feature, version);
            this._instanceOf = instanceOf;
            this._mustBeClass = mustBeClass;
        }

        protected String getFullyQualifiedName(EObject eobj) {
            EStructuralFeature feature = eobj.eClass().getEStructuralFeature("textContent");
            if (feature != null) {
                return (String)eobj.eGet(feature);
            }
            return null;
        }

        protected boolean mustBeClass() {
            return this._mustBeClass;
        }

        protected EObjectValidationVisitor[] getChildNodeValidators() {
            return NO_CHILDREN;
        }

        protected String getInstanceOf() {
            return this._instanceOf;
        }
    }

    private static class DefaultValidatorsValidationVisitor
    extends EObjectValidationVisitor {
        DefaultValidatorsValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_DefaultValidators(), version);
        }

        protected void doValidate(EObject eObject, List messages, IFile file) {
        }

        protected EObjectValidationVisitor[] getChildNodeValidators() {
            return NO_CHILDREN;
        }
    }

    private static class ELResolverValidationVisitor
    extends ApplicationClassNameBasedValidationVisitor {
        ELResolverValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_ELResolver(), version, "javax.el.ELResolver", true);
        }

        protected void doValidate(EObject object, List messages, IFile file) {
            String version = this.getVersion();
            if ("1.0".equals(version) || "1.1".equals(version)) {
                ELResolverValidationVisitor.addMessageInfo(messages, DiagnosticFactory.create_API_NOT_AVAILABLE_BEFORE_VERSION("el-resolver", "1.2", "variable-resolver or property-resolver"), object, file);
            } else {
                super.doValidate(object, messages, file);
            }
        }
    }

    private static class LocaleConfigValidationVisitor
    extends EObjectValidationVisitor {
        public LocaleConfigValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_LocaleConfig(), version);
        }

        protected void doValidate(EObject object, List messages, IFile file) {
            LocaleConfigType localeConfig = (LocaleConfigType)object;
            DefaultLocaleType defaultLocale = localeConfig.getDefaultLocale();
            if (defaultLocale != null) {
                LocaleConfigValidationVisitor.addMessageInfo(messages, AppConfigValidationUtil.validateLocaleType(defaultLocale.getTextContent()), (EObject)defaultLocale, file);
            }
            for (SupportedLocaleType supportedLocale : localeConfig.getSupportedLocale()) {
                LocaleConfigValidationVisitor.addMessageInfo(messages, AppConfigValidationUtil.validateLocaleType(supportedLocale.getTextContent()), (EObject)supportedLocale, file);
            }
        }

        protected EObjectValidationVisitor[] getChildNodeValidators() {
            return NO_CHILDREN;
        }
    }

    private static class NavigationHandlerValidationVisitor
    extends ApplicationClassNameBasedValidationVisitor {
        public NavigationHandlerValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_NavigationHandler(), version, "javax.faces.application.NavigationHandler", true);
        }
    }

    private static class PropertyResolverValidationVisitor
    extends ApplicationClassNameBasedValidationVisitor {
        PropertyResolverValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_PropertyResolver(), version, "javax.faces.el.PropertyResolver", true);
        }

        protected void doValidate(EObject object, List messages, IFile file) {
            super.doValidate(object, messages, file);
            String version = this.getVersion();
            if (!"1.0".equals(version) && !"1.1".equals(version)) {
                PropertyResolverValidationVisitor.addMessageInfo(messages, DiagnosticFactory.create_API_DEPRECATED_AFTER_VERSION_ID("property-resolver", "1.1", "el-resolver"), object, file);
            }
        }
    }

    private static class ResourceHandlerValidationVisitor
    extends ApplicationClassNameBasedValidationVisitor {
        ResourceHandlerValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_ResourceHandler(), version, "javax.faces.application.ResourceHandler", true);
        }
    }

    private static class StateManagerValidationVisitior
    extends ApplicationClassNameBasedValidationVisitor {
        StateManagerValidationVisitior(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_StateManager(), version, "javax.faces.application.StateManager", true);
        }
    }

    private static class SystemEventListenerClassValidationVisitor
    extends ApplicationClassNameBasedValidationVisitor {
        SystemEventListenerClassValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getSystemEventListenerType_SystemEventClass(), version, "javax.faces.event.SystemEvent", true);
        }
    }

    private static class SystemEventListenerSourceClassValidationVisitor
    extends ApplicationClassNameBasedValidationVisitor {
        SystemEventListenerSourceClassValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getSystemEventListenerType_SourceClass(), version, "java.lang.Object", true);
        }
    }

    private static class SystemEventListenerTypeValidationVisitor
    extends EObjectValidationVisitor {
        SystemEventListenerTypeValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_SystemEventListener(), version);
        }

        protected void doValidate(EObject eObject, List messages, IFile file) {
        }

        protected EObjectValidationVisitor[] getChildNodeValidators() {
            return new EObjectValidationVisitor[]{new SystemEventListenerValidationVisitor(this.getVersion()), new SystemEventListenerClassValidationVisitor(this.getVersion()), new SystemEventListenerSourceClassValidationVisitor(this.getVersion())};
        }
    }

    private static class SystemEventListenerValidationVisitor
    extends ApplicationClassNameBasedValidationVisitor {
        SystemEventListenerValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getSystemEventListenerType_SystemEventListenerClass(), version, "javax.faces.event.SystemEventListener", true);
        }
    }

    private static class VariableResolverValidationVisitor
    extends ApplicationClassNameBasedValidationVisitor {
        VariableResolverValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_VariableResolver(), version, "javax.faces.el.VariableResolver", true);
        }

        protected void doValidate(EObject object, List messages, IFile file) {
            super.doValidate(object, messages, file);
            String version = this.getVersion();
            if (!"1.0".equals(version) && !"1.1".equals(version)) {
                VariableResolverValidationVisitor.addMessageInfo(messages, DiagnosticFactory.create_API_DEPRECATED_AFTER_VERSION_ID("variable-resolver", "1.1", "el-resolver"), object, file);
            }
        }
    }

    private static class ViewHandlerValidationVisitor
    extends ApplicationClassNameBasedValidationVisitor {
        ViewHandlerValidationVisitor(String version) {
            super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getApplicationType_ViewHandler(), version, "javax.faces.application.ViewHandler", true);
        }
    }
}

