/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.widgets.ChooserPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.ClassName;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassChooserPane<T extends Model>
extends ChooserPane<T> {
    protected JavaTypeCompletionProcessor javaTypeCompletionProcessor;
    private PropertyChangeListener subjectChangeListener;

    public ClassChooserPane(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public ClassChooserPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        this.subjectChangeListener = this.buildSubjectChangeListener();
        this.getSubjectHolder().addPropertyChangeListener("value", this.subjectChangeListener);
        this.classChooserSubjectChanged(this.getSubject());
    }

    private PropertyChangeListener buildSubjectChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildSubjectChangeListener_());
    }

    private PropertyChangeListener buildSubjectChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                ClassChooserPane.this.classChooserSubjectChanged((Model)e.getNewValue());
            }
        };
    }

    protected void classChooserSubjectChanged(T newSubject) {
        IPackageFragmentRoot root;
        IPackageFragment packageFragment = null;
        if (newSubject != null && (root = this.getPackageFragmentRoot()) != null) {
            packageFragment = root.getPackageFragment("");
        }
        this.javaTypeCompletionProcessor.setPackageFragment(packageFragment);
    }

    @Override
    protected Control addLeftControl(Composite container) {
        if (!this.allowTypeCreation()) {
            return super.addLeftControl(container);
        }
        Hyperlink labelLink = this.addHyperlink(container, this.getLabelText(), this.buildHyperLinkAction());
        return labelLink;
    }

    private Runnable buildHyperLinkAction() {
        return new Runnable(){

            public void run() {
                ClassChooserPane.this.hyperLinkSelected();
            }
        };
    }

    protected void hyperLinkSelected() {
        IType type = this.getType();
        if (type != null) {
            this.openInEditor(type);
        } else if (this.allowTypeCreation()) {
            this.createType();
        }
    }

    protected IType getType() {
        if (this.getClassName() == null) {
            return null;
        }
        IType type = null;
        try {
            type = this.getJpaProject().getJavaProject().findType(this.getClassName().replace('$', '.'));
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
        }
        return type;
    }

    protected void createType() {
        StructuredSelection selection = new StructuredSelection((Object)this.getJpaProject().getProject());
        NewClassWizardPage newClassWizardPage = new NewClassWizardPage();
        newClassWizardPage.init((IStructuredSelection)selection);
        newClassWizardPage.setSuperClass(this.getSuperclassName(), true);
        newClassWizardPage.setSuperInterfaces(this.getSuperInterfaceNames(), true);
        if (!StringTools.stringIsEmpty((String)this.getClassName())) {
            newClassWizardPage.setTypeName(ClassName.getSimpleName((String)this.getClassName()), true);
            String packageName = ClassName.getPackageName((String)this.getClassName());
            newClassWizardPage.setPackageFragment(this.getFirstJavaSourceFolder().getPackageFragment(packageName), true);
        }
        NewClassCreationWizard wizard = new NewClassCreationWizard(newClassWizardPage, false);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        int dResult = dialog.open();
        if (dResult == 0) {
            String className = newClassWizardPage.getCreatedType().getFullyQualifiedName(this.getEnclosingTypeSeparator());
            this.setClassName(className);
        }
    }

    protected abstract void setClassName(String var1);

    protected char getEnclosingTypeSeparator() {
        return '$';
    }

    protected String getSuperclassName() {
        return "";
    }

    protected List<String> getSuperInterfaceNames() {
        return this.getSuperInterfaceName() != null ? Collections.singletonList(this.getSuperInterfaceName()) : Collections.emptyList();
    }

    protected String getSuperInterfaceName() {
        return null;
    }

    protected boolean allowTypeCreation() {
        return true;
    }

    protected void openInEditor(IType type) {
        IJavaElement javaElement = type.getParent();
        try {
            JavaUI.openInEditor((IJavaElement)javaElement, (boolean)true, (boolean)true);
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
        }
        catch (PartInitException e) {
            JptUiPlugin.log(e);
        }
    }

    protected abstract JpaProject getJpaProject();

    @Override
    protected final Runnable buildBrowseAction() {
        return new Runnable(){

            public void run() {
                ClassChooserPane.this.promptType();
            }
        };
    }

    @Override
    protected Control addMainControl(Composite container) {
        Composite subPane = this.addSubPane(container);
        Text text = this.addText(subPane, this.buildTextHolder());
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.javaTypeCompletionProcessor);
        return subPane;
    }

    protected abstract WritablePropertyValueModel<String> buildTextHolder();

    protected IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IJavaElement[] elements = new IJavaElement[]{this.getJpaProject().getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)scope, (int)this.getTypeDialogStyle(), (boolean)false, (String)(StringTools.stringIsEmpty((String)this.getClassName()) ? "" : ClassName.getSimpleName((String)this.getClassName())));
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(JptUiMessages.ClassChooserPane_dialogTitle);
        typeSelectionDialog.setMessage(JptUiMessages.ClassChooserPane_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    protected int getTypeDialogStyle() {
        return 2;
    }

    protected abstract String getClassName();

    protected IPackageFragmentRoot getFirstJavaSourceFolder() {
        Iterator i = JDTTools.getJavaSourceFolders((IJavaProject)this.getJpaProject().getJavaProject()).iterator();
        return i.hasNext() ? (IPackageFragmentRoot)i.next() : null;
    }

    protected void promptType() {
        IType type = this.chooseType();
        if (type != null) {
            String className = type.getFullyQualifiedName(this.getEnclosingTypeSeparator());
            this.setClassName(className);
        }
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        return JDTTools.getCodeCompletionContextRoot((IJavaProject)this.getJpaProject().getJavaProject());
    }

    @Override
    public void dispose() {
        this.getSubjectHolder().removePropertyChangeListener("value", this.subjectChangeListener);
        super.dispose();
    }
}

