/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.crossfire.Tracing;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFEventPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFRequestPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFResponsePacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.HandShakePacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.JSON;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.socket.SocketConnection;

public class CFSocketConnection
extends SocketConnection {
    public CFSocketConnection(Socket socket) throws IOException {
        super(socket);
    }

    public void writePacket(Packet packet) throws IOException {
        String serialized = JSON.serialize((CFPacket)packet);
        if (CFPacket.TRACE) {
            Tracing.writeString("WRITE PACKET: " + serialized);
        }
        Writer writer = this.getWriter();
        writer.write(serialized);
        writer.flush();
    }

    public void writeHandShake(String[] tools) throws IOException {
        if (CFPacket.TRACE) {
            Tracing.writeString("WRITE HANDSHAKE: " + HandShakePacket.getHandshake(tools));
        }
        Writer writer = this.getWriter();
        writer.write(HandShakePacket.getHandshake(tools));
        writer.flush();
    }

    public CFPacket readHandShake() throws IOException {
        StringBuffer buffer = new StringBuffer();
        int c = 0;
        boolean r = false;
        Reader reader = this.getReader();
        while ((c = reader.read()) > -1) {
            buffer.append((char)c);
            if (r && c == 10) break;
            boolean bl = r = c == 13;
        }
        r = false;
        while (reader.ready() && (c = reader.read()) > -1) {
            if (r && c == 10) {
                buffer.append((char)c);
                break;
            }
            boolean bl = r = c == 13;
            if (!r) continue;
            buffer.append((char)c);
        }
        if (buffer.toString().equals(HandShakePacket.getHandshake(null))) {
            HandShakePacket ack = new HandShakePacket();
            if (CFPacket.TRACE) {
                Tracing.writeString("ACK HANDSHAKE: " + buffer.toString());
            }
            return ack;
        }
        if (CFPacket.TRACE) {
            Tracing.writeString("Did not get correct CrossFire handshake: " + buffer.toString());
        }
        throw new IOException("Did not get correct CrossFire handshake: " + buffer.toString());
    }

    public Packet readPacket() throws IOException {
        Map json;
        String type;
        StringBuffer buffer = new StringBuffer();
        StringBuffer raw = new StringBuffer();
        int c = -1;
        boolean r = false;
        String len = null;
        Reader reader = this.getReader();
        while ((c = reader.read()) > -1) {
            if (CFPacket.TRACE) {
                raw.append((char)c);
            }
            if (r) {
                if (c != 10) continue;
                String str = buffer.toString();
                if (str.startsWith("Content-Length:")) {
                    len = this.grabAttrib(str);
                } else if (str.equals("\r")) break;
                buffer = new StringBuffer();
                r = false;
                continue;
            }
            buffer.append((char)c);
            boolean bl = r = c == 13;
        }
        int length = 0;
        try {
            length = Integer.parseInt(len);
        }
        catch (NumberFormatException numberFormatException) {
            if (CFPacket.TRACE) {
                Tracing.writeString("[SOCKET] failed to read content length: " + raw.toString());
            }
            throw new IOException("Failed to parse content length: " + raw.toString());
        }
        char[] message = new char[length];
        int n = 0;
        int off = 0;
        while (n < length) {
            int count = reader.read(message, off + n, length - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        if (CFPacket.TRACE) {
            raw.append(message);
            Tracing.writeString("READ PACKET: " + raw.toString());
        }
        if ("event".equals(type = CFPacket.getType(json = (Map)JSON.read(new String(message))))) {
            return new CFEventPacket(json);
        }
        if ("request".equals(type)) {
            return new CFRequestPacket(json);
        }
        if ("response".equals(type)) {
            return new CFResponsePacket(json);
        }
        throw new IOException("Unknown packet type: " + type);
    }

    String grabAttrib(String str) {
        int idx;
        if (str != null && (idx = str.indexOf(58)) > -1) {
            return str.substring(idx + 1, str.length() - 1);
        }
        return null;
    }
}

