/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.widgets.bean;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.jst.ws.internal.common.JavaMOFUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.common.JavaResourceFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class ValidateObjectSelectionCommand
extends AbstractDataModelOperation {
    private String JAVA_EXTENSION = ".java";
    private String CLASS_EXTENSION = ".class";
    private IStructuredSelection objectSelection;
    private String serviceProjectName;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        String javaBeanName = null;
        if (this.objectSelection != null && !this.objectSelection.isEmpty()) {
            Object object = this.objectSelection.getFirstElement();
            if (object instanceof String) {
                javaBeanName = (String)object;
            } else {
                try {
                    System.out.println(object.getClass().toString());
                    javaBeanName = this.getJavaBeanFromObjectSelection(this.objectSelection);
                }
                catch (CoreException coreException) {
                    IStatus errorStatus = StatusUtils.errorStatus((String)AxisCreationUIMessages.MSG_ERROR_CANNOT_NO_JAVA_BEAN);
                    environment.getStatusHandler().reportError(errorStatus);
                    return errorStatus;
                }
            }
        }
        if (javaBeanName == null || javaBeanName.length() == 0) {
            IStatus errorStatus = StatusUtils.errorStatus((String)AxisCreationUIMessages.MSG_ERROR_CANNOT_NO_JAVA_BEAN);
            environment.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
        IProject serviceProject = ProjectUtilities.getProject((String)this.serviceProjectName);
        if (serviceProject == null) {
            IStatus errorStatus = StatusUtils.errorStatus((String)AxisCreationUIMessages.MSG_ERROR_NO_PROJECT);
            environment.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
        if (javaBeanName.toLowerCase().endsWith(this.JAVA_EXTENSION) || javaBeanName.toLowerCase().endsWith(this.CLASS_EXTENSION)) {
            javaBeanName = javaBeanName.substring(0, javaBeanName.lastIndexOf(46));
        }
        try {
            JavaClass javaClass = JavaMOFUtils.getJavaClass((String)javaBeanName, (IProject)serviceProject);
            if (!javaClass.isExistingType()) {
                IStatus errorStatus = StatusUtils.errorStatus((String)NLS.bind((String)AxisCreationUIMessages.MSG_ERROR_CANNOT_LOAD_JAVA_BEAN, (Object[])new String[]{javaBeanName, this.serviceProjectName}));
                environment.getStatusHandler().reportError(errorStatus);
                return errorStatus;
            }
        }
        catch (CoreException coreException) {
            IStatus errorStatus = StatusUtils.errorStatus((String)NLS.bind((String)AxisCreationUIMessages.MSG_ERROR_CANNOT_LOAD_JAVA_BEAN, (Object[])new String[]{javaBeanName, this.serviceProjectName}));
            environment.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    public void setServiceProjectName(String serviceProjectName) {
        this.serviceProjectName = serviceProjectName;
    }

    public void setObjectSelection(IStructuredSelection objectSelection) {
        this.objectSelection = objectSelection;
    }

    private String getJavaBeanFromObjectSelection(IStructuredSelection objectSelection) throws CoreException {
        Object obj;
        String beanClass = "";
        JavaResourceFilter filter = new JavaResourceFilter();
        if (objectSelection != null && (obj = objectSelection.getFirstElement()) != null) {
            String beanPackage;
            IResource res = null;
            res = ResourceUtils.getResourceFromSelection((Object)obj);
            if (filter.accepts((Object)res) && ((beanClass = String.valueOf(beanPackage = (beanPackage = ResourceUtils.getJavaResourcePackageName((IPath)res.getFullPath())) == null ? "" : String.valueOf(beanPackage) + ".") + res.getName()).toLowerCase().endsWith(".java") || beanClass.toLowerCase().endsWith(".class"))) {
                beanClass = beanClass.substring(0, beanClass.lastIndexOf(46));
            }
        }
        return beanClass;
    }
}

