/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityURIConverter;
import org.eclipse.wst.common.internal.emf.utilities.Revisit;

public class ZipStreamSaveStrategyImpl
extends SaveStrategyImpl {
    protected OutputStream destinationStream;
    protected ZipOutputStream zipOutputStream;

    public ZipStreamSaveStrategyImpl(OutputStream out) {
        this.setDestinationStream(out);
        this.setZipOutputStream(new ZipOutputStream(out));
    }

    public void close() throws IOException {
        this.getDestinationStream().close();
    }

    protected SaveStrategy createNestedSaveStrategy(Archive anArchive) {
        return new ZipStreamSaveStrategyImpl(this.getZipOutputStream());
    }

    public void finish() throws IOException {
        this.getZipOutputStream().finish();
        if (!(this.getDestinationStream() instanceof ZipOutputStream)) {
            this.getDestinationStream().close();
        }
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return this.getZipOutputStream();
    }

    public void saveMofResource(Resource aResource, OutputStream out) throws IOException {
        Revisit.revisit();
        URI uri = aResource.getURI();
        URIConverter conv = this.getArchive().getResourceSet().getURIConverter();
        if (conv instanceof CompatibilityURIConverter) {
            uri = ((CompatibilityURIConverter)conv).deNormalize(uri);
        }
        ZipEntry entry = new ZipEntry(uri.toString());
        this.zipOutputStream.putNextEntry(entry);
        super.saveMofResource(aResource, out);
        this.zipOutputStream.closeEntry();
    }

    protected ZipOutputStream getZipOutputStream() {
        return this.zipOutputStream;
    }

    public void save(ArchiveManifest aManifest) throws SaveFailureException {
        try {
            ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
            this.getZipOutputStream().putNextEntry(entry);
            aManifest.write(this.getZipOutputStream());
            this.getZipOutputStream().closeEntry();
        }
        catch (IOException iox) {
            throw new SaveFailureException("META-INF/MANIFEST.MF", iox);
        }
    }

    public void save(Archive anArchive) throws SaveFailureException {
        try {
            ZipEntry entry = new ZipEntry(anArchive.getURI());
            this.getZipOutputStream().putNextEntry(entry);
            super.save(anArchive);
            this.getZipOutputStream().closeEntry();
        }
        catch (IOException iox) {
            throw new SaveFailureException(anArchive.getURI(), iox);
        }
    }

    public void save(File aFile, InputStream in) throws SaveFailureException {
        try {
            String entryName = aFile.getURI();
            if (aFile.isDirectoryEntry() && !entryName.endsWith("/")) {
                entryName = String.valueOf(entryName) + '/';
            }
            ZipEntry entry = new ZipEntry(entryName);
            if (aFile.getLastModified() > 0L) {
                entry.setTime(aFile.getLastModified());
            }
            this.getZipOutputStream().putNextEntry(entry);
            if (!aFile.isDirectoryEntry()) {
                ArchiveUtil.copy(in, this.getZipOutputStream());
            }
            this.getZipOutputStream().closeEntry();
        }
        catch (IOException iox) {
            throw new SaveFailureException(aFile.getURI(), iox);
        }
    }

    public void setDestinationStream(OutputStream newDestinationStream) {
        this.destinationStream = newDestinationStream;
    }

    protected void setZipOutputStream(ZipOutputStream newZipOutputStream) {
        this.zipOutputStream = newZipOutputStream;
    }
}

