/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ui.ModuleCoreUIPlugin;

public class Trace {
    public static final byte CONFIG = 0;
    public static final byte INFO = 1;
    public static final byte WARNING = 2;
    public static final byte SEVERE = 3;
    public static final byte FINEST = 4;
    public static final byte FINER = 5;
    public static final byte PERFORMANCE = 6;
    public static final byte EXTENSION_POINT = 7;
    private static final String[] levelNames = new String[]{"CONFIG ", "INFO   ", "WARNING", "SEVERE ", "FINER  ", "FINEST ", "PERF   ", "EXTENSION"};
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");
    private static Set<String> logged = new HashSet<String>();

    private Trace() {
    }

    public static void trace(byte level, String s) {
        Trace.trace(level, s, null);
    }

    public static void trace(byte level, String s, Throwable t) {
        if (s == null) {
            return;
        }
        if (level == 3 && !logged.contains(s)) {
            ModuleCoreUIPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.wst.common.modulecore.ui", s, t));
            logged.add(s);
        }
        if (!ModuleCoreUIPlugin.getInstance().isDebugging()) {
            return;
        }
        StringBuffer sb = new StringBuffer("org.eclipse.wst.common.modulecore.ui");
        sb.append(" ");
        sb.append(levelNames[level]);
        sb.append(" ");
        sb.append(sdf.format(new Date()));
        sb.append(" ");
        sb.append(s);
        System.out.println(sb.toString());
        if (t != null) {
            t.printStackTrace();
        }
    }
}

