/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.persistence;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Tools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericClassRef
extends AbstractPersistenceXmlContextNode
implements ClassRef {
    protected final XmlJavaClassRef xmlJavaClassRef;
    protected String className;
    protected JavaPersistentType javaPersistentType;

    public GenericClassRef(PersistenceUnit parent, XmlJavaClassRef classRef) {
        this(parent, classRef, classRef.getJavaClass());
    }

    public GenericClassRef(PersistenceUnit parent, String className) {
        this(parent, null, className);
    }

    protected GenericClassRef(PersistenceUnit parent, XmlJavaClassRef classRef, String className) {
        super(parent);
        this.xmlJavaClassRef = classRef;
        this.initialize(className);
    }

    protected void initialize(String typeName) {
        this.className = typeName;
        this.javaPersistentType = this.buildJavaPersistentType();
    }

    @Override
    public PersistenceUnit getParent() {
        return (PersistenceUnit)super.getParent();
    }

    @Override
    public XmlJavaClassRef getResourceClassRef() {
        return this.xmlJavaClassRef;
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.classRef";
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.isVirtual() ? null : this.xmlJavaClassRef.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        if (this.javaPersistentType != null) {
            this.javaPersistentType.dispose();
        }
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public boolean isFor(String typeName) {
        return Tools.valuesAreEqual((Object)typeName, (Object)this.getJavaClassName());
    }

    @Override
    public boolean isVirtual() {
        return this.xmlJavaClassRef == null;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.isNotVirtual() && this.xmlJavaClassRef.containsOffset(textOffset);
    }

    protected boolean isNotVirtual() {
        return !this.isVirtual();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        String old = this.className;
        this.className = className;
        this.xmlJavaClassRef.setJavaClass(className);
        this.firePropertyChanged("className", old, className);
    }

    protected void setClassName_(String newClassName) {
        String old = this.className;
        this.className = newClassName;
        this.firePropertyChanged("className", old, newClassName);
    }

    protected String getJavaClassName() {
        return StringTools.stringIsEmpty((String)this.className) ? null : this.className.replace('$', '.');
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.javaPersistentType;
    }

    protected void setJavaPersistentType(JavaPersistentType javaPersistentType) {
        JavaPersistentType old = this.javaPersistentType;
        this.javaPersistentType = javaPersistentType;
        this.firePropertyChanged("javaPersistentType", old, javaPersistentType);
    }

    protected JavaPersistentType buildJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJavaResourcePersistentType();
        return jrpt == null ? null : this.buildJavaPersistentType(jrpt);
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourcePersistentType jrpt) {
        return this.getJpaFactory().buildJavaPersistentType(this, jrpt);
    }

    protected void updateJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJavaResourcePersistentType();
        if (jrpt == null) {
            if (this.javaPersistentType != null) {
                this.javaPersistentType.dispose();
                this.setJavaPersistentType(null);
            }
        } else if (this.javaPersistentType == null) {
            this.setJavaPersistentType(this.buildJavaPersistentType(jrpt));
        } else {
            this.javaPersistentType.update(jrpt);
        }
    }

    protected JavaResourcePersistentType getJavaResourcePersistentType() {
        String javaClassName = this.getJavaClassName();
        return javaClassName == null ? null : this.getJpaProject().getJavaResourcePersistentType(javaClassName);
    }

    @Override
    public void update() {
        this.update(this.xmlJavaClassRef.getJavaClass());
    }

    @Override
    public void update(String typeName) {
        this.setClassName_(typeName);
        this.updateJavaPersistentType();
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.javaPersistentType != null) {
            this.javaPersistentType.postUpdate();
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.isVirtual() ? null : this.xmlJavaClassRef.getValidationTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.stringIsEmpty((String)this.className)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_CLASS", this, this.getValidationTextRange()));
            return;
        }
        if (this.javaPersistentType == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_NONEXISTENT_CLASS", new String[]{this.getJavaClassName()}, this, this.getValidationTextRange()));
            return;
        }
        boolean validateJavaPersistentType = true;
        Iterator<MappingFileRef> stream = this.getPersistenceUnit().mappingFileRefsContaining(this.getJavaClassName());
        while (stream.hasNext()) {
            validateJavaPersistentType = false;
            MappingFileRef mappingFileRef = stream.next();
            messages.add(DefaultJpaValidationMessages.buildMessage(4, "PERSISTENCE_UNIT_REDUNDANT_CLASS", new String[]{this.getJavaClassName(), mappingFileRef.getFileName()}, this, this.getValidationTextRange()));
        }
        if (validateJavaPersistentType) {
            this.validateJavaPersistentType(messages, reporter);
        }
    }

    protected void validateJavaPersistentType(List<IMessage> messages, IReporter reporter) {
        try {
            this.javaPersistentType.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getJavaClassName());
    }
}

