/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa2.context.persistence.options;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceUnitProperties;
import org.eclipse.jpt.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.core.jpa2.context.persistence.options.JpaOptions2_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOptions2_0
extends AbstractPersistenceUnitProperties
implements JpaOptions2_0 {
    private Integer lockTimeout;
    private Integer queryTimeout;
    private String validationGroupPrePersist;
    private String validationGroupPreUpdate;
    private String validationGroupPreRemove;

    public GenericOptions2_0(PersistenceUnit parent) {
        super(parent);
    }

    @Override
    protected void initializeProperties() {
        this.lockTimeout = this.getIntegerValue("javax.persistence.lock.timeout");
        this.queryTimeout = this.getIntegerValue("javax.persistence.query.timeout");
        this.validationGroupPrePersist = this.getStringValue("javax.persistence.validation.group.pre-persist");
        this.validationGroupPreUpdate = this.getStringValue("javax.persistence.validation.group.pre-update");
        this.validationGroupPreRemove = this.getStringValue("javax.persistence.validation.group.pre-remove");
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("javax.persistence.lock.timeout")) {
            this.lockTimeoutChanged(newValue);
        } else if (propertyName.equals("javax.persistence.query.timeout")) {
            this.queryTimeoutChanged(newValue);
        } else if (propertyName.equals("javax.persistence.validation.group.pre-persist")) {
            this.validationGroupPrePersistChanged(newValue);
        } else if (propertyName.equals("javax.persistence.validation.group.pre-update")) {
            this.validationGroupPreUpdateChanged(newValue);
        } else if (propertyName.equals("javax.persistence.validation.group.pre-remove")) {
            this.validationGroupPreRemoveChanged(newValue);
        }
    }

    @Override
    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("javax.persistence.lock.timeout")) {
            this.lockTimeoutChanged(null);
        } else if (propertyName.equals("javax.persistence.query.timeout")) {
            this.queryTimeoutChanged(null);
        } else if (propertyName.equals("javax.persistence.validation.group.pre-persist")) {
            this.validationGroupPrePersistChanged(null);
        } else if (propertyName.equals("javax.persistence.validation.group.pre-update")) {
            this.validationGroupPreUpdateChanged(null);
        } else if (propertyName.equals("javax.persistence.validation.group.pre-remove")) {
            this.validationGroupPreRemoveChanged(null);
        }
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("javax.persistence.lock.timeout", "lockTimeout");
        propertyNames.put("javax.persistence.query.timeout", "queryTimeout");
        propertyNames.put("javax.persistence.validation.group.pre-persist", "validationGroupPrePersist");
        propertyNames.put("javax.persistence.validation.group.pre-update", "validationGroupPreUpdate");
        propertyNames.put("javax.persistence.validation.group.pre-remove", "validationGroupPreRemove");
    }

    @Override
    public PersistenceUnit2_0 getPersistenceUnit() {
        return (PersistenceUnit2_0)super.getPersistenceUnit();
    }

    @Override
    public Integer getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public void setLockTimeout(Integer newLockTimeout) {
        Integer old = this.lockTimeout;
        this.lockTimeout = newLockTimeout;
        this.putProperty("lockTimeout", newLockTimeout);
        this.firePropertyChanged("lockTimeout", old, newLockTimeout);
    }

    private void lockTimeoutChanged(String stringValue) {
        Integer newValue = GenericOptions2_0.getIntegerValueOf(stringValue);
        Integer old = this.lockTimeout;
        this.lockTimeout = newValue;
        this.firePropertyChanged("lockTimeout", old, newValue);
    }

    @Override
    public Integer getDefaultLockTimeout() {
        return DEFAULT_LOCK_TIMEOUT;
    }

    @Override
    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(Integer newQueryTimeout) {
        Integer old = this.queryTimeout;
        this.queryTimeout = newQueryTimeout;
        this.putProperty("queryTimeout", newQueryTimeout);
        this.firePropertyChanged("queryTimeout", old, newQueryTimeout);
    }

    private void queryTimeoutChanged(String stringValue) {
        Integer newValue = GenericOptions2_0.getIntegerValueOf(stringValue);
        Integer old = this.queryTimeout;
        this.queryTimeout = newValue;
        this.firePropertyChanged("queryTimeout", old, newValue);
    }

    @Override
    public Integer getDefaultQueryTimeout() {
        return DEFAULT_QUERY_TIMEOUT;
    }

    @Override
    public String getValidationGroupPrePersist() {
        return this.validationGroupPrePersist;
    }

    @Override
    public void setValidationGroupPrePersist(String newValidationGroupPrePersist) {
        String old = this.validationGroupPrePersist;
        this.validationGroupPrePersist = newValidationGroupPrePersist;
        this.putProperty("validationGroupPrePersist", newValidationGroupPrePersist);
        this.firePropertyChanged("validationGroupPrePersist", old, newValidationGroupPrePersist);
    }

    private void validationGroupPrePersistChanged(String newValue) {
        String old = this.validationGroupPrePersist;
        this.validationGroupPrePersist = newValue;
        this.firePropertyChanged("validationGroupPrePersist", old, newValue);
    }

    @Override
    public String getDefaultValidationGroupPrePersist() {
        return "Default";
    }

    @Override
    public String getValidationGroupPreUpdate() {
        return this.validationGroupPreUpdate;
    }

    @Override
    public void setValidationGroupPreUpdate(String newValidationGroupPreUpdate) {
        String old = this.validationGroupPreUpdate;
        this.validationGroupPreUpdate = newValidationGroupPreUpdate;
        this.putProperty("validationGroupPreUpdate", newValidationGroupPreUpdate);
        this.firePropertyChanged("validationGroupPreUpdate", old, newValidationGroupPreUpdate);
    }

    private void validationGroupPreUpdateChanged(String newValue) {
        String old = this.validationGroupPreUpdate;
        this.validationGroupPreUpdate = newValue;
        this.firePropertyChanged("validationGroupPreUpdate", old, newValue);
    }

    @Override
    public String getDefaultValidationGroupPreUpdate() {
        return "Default";
    }

    @Override
    public String getValidationGroupPreRemove() {
        return this.validationGroupPreRemove;
    }

    @Override
    public void setValidationGroupPreRemove(String newValidationGroupPreRemove) {
        String old = this.validationGroupPreRemove;
        this.validationGroupPreRemove = newValidationGroupPreRemove;
        this.putProperty("validationGroupPreRemove", newValidationGroupPreRemove);
        this.firePropertyChanged("validationGroupPreRemove", old, newValidationGroupPreRemove);
    }

    private void validationGroupPreRemoveChanged(String newValue) {
        String old = this.validationGroupPreRemove;
        this.validationGroupPreRemove = newValue;
        this.firePropertyChanged("validationGroupPreRemove", old, newValue);
    }

    @Override
    public String getDefaultValidationGroupPreRemove() {
        return "";
    }
}

