/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.binary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryClassFile;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryNode;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryPersistentType;
import org.eclipse.jpt.core.resource.java.JavaResourceClassFile;
import org.eclipse.jpt.core.resource.java.JavaResourcePackageFragment;
import org.eclipse.jpt.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryPackageFragment
extends BinaryNode
implements JavaResourcePackageFragment {
    private final IPackageFragment packageFragment;
    private final Vector<JavaResourceClassFile> classFiles = new Vector();
    protected static final IJavaElement[] EMPTY_JAVA_ELEMENT_ARRAY = new IJavaElement[0];

    BinaryPackageFragment(JavaResourcePackageFragmentRoot parent, IPackageFragment packageFragment) {
        super(parent);
        this.packageFragment = packageFragment;
        this.classFiles.addAll(this.buildClassFiles());
    }

    private Collection<JavaResourceClassFile> buildClassFiles() {
        IJavaElement[] children = this.getJDTChildren();
        ArrayList<JavaResourceClassFile> result = new ArrayList<JavaResourceClassFile>(children.length);
        IJavaElement[] iJavaElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            IClassFile jdtClassFile = (IClassFile)child;
            IType jdtType = jdtClassFile.getType();
            if (BinaryPackageFragment.typeIsRelevant(jdtType)) {
                BinaryClassFile classFile = new BinaryClassFile(this, jdtClassFile, jdtType);
                result.add(classFile);
            }
            ++n2;
        }
        return result;
    }

    static boolean typeIsRelevant(IType type) {
        if (BinaryPersistentType.typeIsPersistable(type)) {
            return BinaryPackageFragment.typeHasAnyAnnotations(type);
        }
        return false;
    }

    static boolean typeHasAnyAnnotations(IType type) {
        try {
            return type.getAnnotations().length > 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateClassFiles();
    }

    private void updateClassFiles() {
        throw new UnsupportedOperationException();
    }

    public ListIterator<JavaResourceClassFile> classFiles() {
        return new CloneListIterator(this.classFiles);
    }

    @Override
    public int classFilesSize() {
        return this.classFiles.size();
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistedTypes() {
        return new TransformationIterator<JavaResourceClassFile, JavaResourcePersistentType>(this.classFiles()){

            protected JavaResourcePersistentType transform(JavaResourceClassFile classFile) {
                return classFile.getPersistentType();
            }
        };
    }

    private IJavaElement[] getJDTChildren() {
        try {
            return this.packageFragment.getChildren();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return EMPTY_JAVA_ELEMENT_ARRAY;
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.packageFragment.getElementName());
    }
}

