/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JpaPlatformVariation;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaBaseJoinColumn;
import org.eclipse.jpt.core.context.java.JavaDiscriminatorColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaQueryContainer;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.PrimaryKeyTextRangeResolver;
import org.eclipse.jpt.core.internal.context.PrimaryKeyValidator;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.GenericJavaIdClassReference;
import org.eclipse.jpt.core.internal.context.java.JavaEntityTextRangeResolver;
import org.eclipse.jpt.core.internal.jpa1.context.GenericEntityPrimaryKeyValidator;
import org.eclipse.jpt.core.internal.resource.java.NullPrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaCacheableHolder2_0;
import org.eclipse.jpt.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaEntity
extends AbstractJavaTypeMapping
implements JavaEntity,
JavaCacheableHolder2_0 {
    protected String specifiedName;
    protected String defaultName;
    protected final JavaIdClassReference idClassReference = this.buildIdClassReference();
    protected final JavaTable table = this.getJpaFactory().buildJavaTable(this);
    protected boolean specifiedTableIsAllowed;
    protected boolean tableIsUndefined;
    protected final List<JavaSecondaryTable> specifiedSecondaryTables;
    protected final List<JavaPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns;
    protected JavaPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String defaultDiscriminatorValue;
    protected String specifiedDiscriminatorValue;
    protected boolean specifiedDiscriminatorValueIsAllowed;
    protected boolean discriminatorValueIsUndefined;
    protected final JavaDiscriminatorColumn discriminatorColumn = this.buildJavaDiscriminatorColumn();
    protected boolean specifiedDiscriminatorColumnIsAllowed;
    protected boolean discriminatorColumnIsUndefined;
    protected final JavaAttributeOverrideContainer attributeOverrideContainer;
    protected final JavaAssociationOverrideContainer associationOverrideContainer;
    protected final JavaQueryContainer queryContainer;
    protected final JavaGeneratorContainer generatorContainer;
    protected Entity rootEntity;
    protected static final String[] SUPPORTING_ANNOTATION_NAMES_ARRAY = new String[]{"javax.persistence.Table", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables", "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns", "javax.persistence.IdClass", "javax.persistence.Inheritance", "javax.persistence.DiscriminatorValue", "javax.persistence.DiscriminatorColumn", "javax.persistence.SequenceGenerator", "javax.persistence.TableGenerator", "javax.persistence.NamedQuery", "javax.persistence.NamedQueries", "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries", "javax.persistence.SqlResultSetMapping", "javax.persistence.ExcludeDefaultListeners", "javax.persistence.ExcludeSuperclassListeners", "javax.persistence.EntityListeners", "javax.persistence.PrePersist", "javax.persistence.PostPersist", "javax.persistence.PreRemove", "javax.persistence.PostRemove", "javax.persistence.PreUpdate", "javax.persistence.PostUpdate", "javax.persistence.PostLoad", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides", "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides"};
    protected static final Iterable<String> SUPPORTING_ANNOTATION_NAMES = new ArrayIterable((Object[])SUPPORTING_ANNOTATION_NAMES_ARRAY);

    protected AbstractJavaEntity(JavaPersistentType parent) {
        super(parent);
        this.specifiedSecondaryTables = new ArrayList<JavaSecondaryTable>();
        this.specifiedPrimaryKeyJoinColumns = new ArrayList<JavaPrimaryKeyJoinColumn>();
        this.attributeOverrideContainer = this.getJpaFactory().buildJavaAttributeOverrideContainer(this, new AttributeOverrideContainerOwner());
        this.associationOverrideContainer = this.getJpaFactory().buildJavaAssociationOverrideContainer(this, new AssociationOverrideContainerOwner());
        this.queryContainer = this.getJpaFactory().buildJavaQueryContainer(this);
        this.generatorContainer = this.getJpaFactory().buildJavaGeneratorContainer(this);
    }

    protected JavaIdClassReference buildIdClassReference() {
        return new GenericJavaIdClassReference(this);
    }

    protected JavaBaseJoinColumn.Owner buildPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected JavaDiscriminatorColumn buildJavaDiscriminatorColumn() {
        return this.getJpaFactory().buildJavaDiscriminatorColumn(this, this.buildDiscriminatorColumnOwner());
    }

    protected JavaDiscriminatorColumn.Owner buildDiscriminatorColumnOwner() {
        return new JavaDiscriminatorColumn.Owner(){

            public String getDefaultTableName() {
                return AbstractJavaEntity.this.getPrimaryTableName();
            }

            public org.eclipse.jpt.db.Table getDbTable(String tableName) {
                return AbstractJavaEntity.this.getDbTable(tableName);
            }

            public TextRange getValidationTextRange(CompilationUnit astRoot) {
                return AbstractJavaEntity.this.getValidationTextRange(astRoot);
            }

            public TypeMapping getTypeMapping() {
                return AbstractJavaEntity.this;
            }

            public String getDefaultColumnName() {
                return AbstractJavaEntity.this.isDescendant() ? AbstractJavaEntity.this.getRootEntity().getDiscriminatorColumn().getName() : (AbstractJavaEntity.this.discriminatorColumnIsUndefined() ? null : "DTYPE");
            }

            public int getDefaultLength() {
                return AbstractJavaEntity.this.isDescendant() ? AbstractJavaEntity.this.getRootEntity().getDiscriminatorColumn().getLength() : (AbstractJavaEntity.this.discriminatorColumnIsUndefined() ? 0 : 31);
            }

            public DiscriminatorType getDefaultDiscriminatorType() {
                return AbstractJavaEntity.this.isDescendant() ? AbstractJavaEntity.this.getRootEntity().getDiscriminatorColumn().getDiscriminatorType() : (AbstractJavaEntity.this.discriminatorColumnIsUndefined() ? null : DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE);
            }

            public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
                return DefaultJpaValidationMessages.buildMessage(1, "DISCRIMINATOR_COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
            }
        };
    }

    @Override
    public void initialize(JavaResourcePersistentType resourcePersistentType) {
        super.initialize(resourcePersistentType);
        this.specifiedName = this.getResourceName();
        this.defaultName = this.getResourceDefaultName();
        this.idClassReference.initialize();
        this.rootEntity = this.calculateRootEntity();
        this.defaultInheritanceStrategy = this.buildDefaultInheritanceStrategy();
        this.specifiedInheritanceStrategy = this.getResourceInheritanceStrategy(this.getResourceInheritance());
        this.specifiedDiscriminatorValueIsAllowed = this.buildSpecifiedDiscriminatorValueIsAllowed();
        this.discriminatorValueIsUndefined = this.buildDiscriminatorValueIsUndefined();
        this.specifiedDiscriminatorValue = this.getResourceDiscriminatorValue().getValue();
        this.defaultDiscriminatorValue = this.buildDefaultDiscriminatorValue();
        this.specifiedDiscriminatorColumnIsAllowed = this.buildSpecifiedDiscriminatorColumnIsAllowed();
        this.discriminatorColumnIsUndefined = this.buildDiscriminatorColumnIsUndefined();
        this.discriminatorColumn.initialize(this.getResourceDiscriminatorColumn());
        this.specifiedTableIsAllowed = this.buildSpecifiedTableIsAllowed();
        this.tableIsUndefined = this.buildTableIsUndefined();
        this.table.initialize(resourcePersistentType);
        this.initializeSecondaryTables();
        this.generatorContainer.initialize(resourcePersistentType);
        this.queryContainer.initialize(resourcePersistentType);
        this.initializePrimaryKeyJoinColumns();
        this.initializeDefaultPrimaryKeyJoinColumn();
        this.attributeOverrideContainer.initialize(resourcePersistentType);
        this.associationOverrideContainer.initialize(resourcePersistentType);
    }

    protected void initializeSecondaryTables() {
        Iterator<NestableAnnotation> stream = this.javaResourcePersistentType.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        while (stream.hasNext()) {
            this.specifiedSecondaryTables.add(this.buildSecondaryTable((SecondaryTableAnnotation)((Object)stream.next())));
        }
    }

    protected void initializePrimaryKeyJoinColumns() {
        Iterator<NestableAnnotation> stream = this.javaResourcePersistentType.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (stream.hasNext()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)((Object)stream.next())));
        }
    }

    protected boolean shouldBuildDefaultPrimaryKeyJoinColumn() {
        return !this.containsSpecifiedPrimaryKeyJoinColumns();
    }

    protected void initializeDefaultPrimaryKeyJoinColumn() {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            return;
        }
        this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumnAnnotation(this.javaResourcePersistentType));
    }

    protected InheritanceAnnotation getResourceInheritance() {
        return (InheritanceAnnotation)this.javaResourcePersistentType.getNonNullAnnotation("javax.persistence.Inheritance");
    }

    protected DiscriminatorValueAnnotation getResourceDiscriminatorValue() {
        return (DiscriminatorValueAnnotation)this.javaResourcePersistentType.getNonNullAnnotation("javax.persistence.DiscriminatorValue");
    }

    protected DiscriminatorColumnAnnotation getResourceDiscriminatorColumn() {
        return (DiscriminatorColumnAnnotation)this.javaResourcePersistentType.getNonNullAnnotation("javax.persistence.DiscriminatorColumn");
    }

    @Override
    protected EntityAnnotation getResourceMappingAnnotation() {
        return (EntityAnnotation)super.getResourceMappingAnnotation();
    }

    public TypeMapping getTypeMapping() {
        return this;
    }

    public TypeMapping getOverridableTypeMapping() {
        PersistentType superPersistentType = this.getPersistentType().getSuperPersistentType();
        return superPersistentType == null ? null : superPersistentType.getMapping();
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public JavaPersistentType getIdClass() {
        return this.idClassReference.getIdClass();
    }

    @Override
    public String getPrimaryTableName() {
        return this.getTable().getName();
    }

    @Override
    public org.eclipse.jpt.db.Table getPrimaryDbTable() {
        return this.getTable().getDbTable();
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable(String tableName) {
        return this.getDataSource().selectDatabaseObjectForIdentifier(this.getAssociatedDbTablesIncludingInherited(), tableName);
    }

    protected Iterable<org.eclipse.jpt.db.Table> getAssociatedDbTablesIncludingInherited() {
        return new FilteringIterable<org.eclipse.jpt.db.Table>(this.getAssociatedDbTablesIncludingInherited_()){

            protected boolean accept(org.eclipse.jpt.db.Table t) {
                return t != null;
            }
        };
    }

    protected Iterable<org.eclipse.jpt.db.Table> getAssociatedDbTablesIncludingInherited_() {
        return new TransformationIterable<Table, org.eclipse.jpt.db.Table>(this.getAssociatedTablesIncludingInherited()){

            protected org.eclipse.jpt.db.Table transform(Table t) {
                return t.getDbTable();
            }
        };
    }

    @Override
    public Schema getDbSchema() {
        return this.getTable().getDbSchema();
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Entity";
    }

    @Override
    public Iterable<String> getSupportingAnnotationNames() {
        return SUPPORTING_ANNOTATION_NAMES;
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.getResourceMappingAnnotation().setName(newSpecifiedName);
        this.firePropertyChanged("specifiedName", oldSpecifiedName, newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedName", oldSpecifiedName, newSpecifiedName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultName", oldDefaultName, newDefaultName);
    }

    @Override
    public JavaIdClassReference getIdClassReference() {
        return this.idClassReference;
    }

    @Override
    public JavaTable getTable() {
        return this.table;
    }

    @Override
    public ListIterator<JavaSecondaryTable> specifiedSecondaryTables() {
        return new CloneListIterator(this.specifiedSecondaryTables);
    }

    @Override
    public int specifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTables.size();
    }

    @Override
    public JavaSecondaryTable addSpecifiedSecondaryTable(int index) {
        JavaSecondaryTable secondaryTable = this.getJpaFactory().buildJavaSecondaryTable(this);
        this.specifiedSecondaryTables.add(index, secondaryTable);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)((Object)this.javaResourcePersistentType.addAnnotation(index, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"));
        secondaryTable.initialize(secondaryTableResource);
        this.fireItemAdded("specifiedSecondaryTables", index, secondaryTable);
        return secondaryTable;
    }

    @Override
    public JavaSecondaryTable addSpecifiedSecondaryTable() {
        return this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size());
    }

    protected void addSpecifiedSecondaryTable(int index, JavaSecondaryTable secondaryTable) {
        this.addItemToList(index, secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    protected void addSpecifiedSecondaryTable(JavaSecondaryTable secondaryTable) {
        this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size(), secondaryTable);
    }

    @Override
    public void removeSpecifiedSecondaryTable(SecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTables.indexOf(secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        JavaSecondaryTable removedSecondaryTable = this.specifiedSecondaryTables.remove(index);
        this.javaResourcePersistentType.removeAnnotation(index, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.fireItemRemoved("specifiedSecondaryTables", index, removedSecondaryTable);
    }

    protected void removeSpecifiedSecondaryTable_(JavaSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedSecondaryTables, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.moveAnnotation(targetIndex, sourceIndex, "javax.persistence.SecondaryTables");
        this.fireItemMoved("specifiedSecondaryTables", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<JavaSecondaryTable> secondaryTables() {
        return this.specifiedSecondaryTables();
    }

    @Override
    public int secondaryTablesSize() {
        return this.specifiedSecondaryTablesSize();
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.getSpecifiedInheritanceStrategy() == null ? this.getDefaultInheritanceStrategy() : this.getSpecifiedInheritanceStrategy();
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        this.getResourceInheritance().setStrategy(InheritanceType.toJavaResourceModel(newInheritanceType));
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    @Override
    public JavaDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String newDefaultDiscriminatorValue) {
        String oldDefaultDiscriminatorValue = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = newDefaultDiscriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValue", oldDefaultDiscriminatorValue, newDefaultDiscriminatorValue);
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        this.getResourceDiscriminatorValue().setValue(newSpecifiedDiscriminatorValue);
        this.firePropertyChanged("specifiedDiscriminatorValue", oldSpecifiedDiscriminatorValue, newSpecifiedDiscriminatorValue);
    }

    protected void setSpecifiedDiscriminatorValue_(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        this.firePropertyChanged("specifiedDiscriminatorValue", oldSpecifiedDiscriminatorValue, newSpecifiedDiscriminatorValue);
    }

    @Override
    public String getDiscriminatorValue() {
        return this.getSpecifiedDiscriminatorValue() == null ? this.getDefaultDiscriminatorValue() : this.getSpecifiedDiscriminatorValue();
    }

    @Override
    public boolean specifiedDiscriminatorValueIsAllowed() {
        return this.specifiedDiscriminatorValueIsAllowed;
    }

    protected void setSpecifiedDiscriminatorValueIsAllowed(boolean specifiedDiscriminatorValueIsAllowed) {
        boolean old = this.specifiedDiscriminatorValueIsAllowed;
        this.specifiedDiscriminatorValueIsAllowed = specifiedDiscriminatorValueIsAllowed;
        this.firePropertyChanged("discriminatorValueIsAllowed", old, specifiedDiscriminatorValueIsAllowed);
    }

    @Override
    public boolean discriminatorValueIsUndefined() {
        return this.discriminatorValueIsUndefined;
    }

    protected void setDiscriminatorValueIsUndefined(boolean discriminatorValueIsUndefined) {
        boolean old = this.discriminatorValueIsUndefined;
        this.discriminatorValueIsUndefined = discriminatorValueIsUndefined;
        this.firePropertyChanged("discriminatorValueIsUndefined", old, discriminatorValueIsUndefined);
    }

    @Override
    public boolean specifiedDiscriminatorColumnIsAllowed() {
        return this.specifiedDiscriminatorColumnIsAllowed;
    }

    protected void setSpecifiedDiscriminatorColumnIsAllowed(boolean specifiedDiscriminatorColumnIsAllowed) {
        boolean old = this.specifiedDiscriminatorColumnIsAllowed;
        this.specifiedDiscriminatorColumnIsAllowed = specifiedDiscriminatorColumnIsAllowed;
        this.firePropertyChanged("specifiedDiscriminatorColumnIsAllowed", old, specifiedDiscriminatorColumnIsAllowed);
    }

    @Override
    public boolean discriminatorColumnIsUndefined() {
        return this.discriminatorColumnIsUndefined;
    }

    protected void setDiscriminatorColumnIsUndefined(boolean discriminatorColumnIsUndefined) {
        boolean old = this.discriminatorColumnIsUndefined;
        this.discriminatorColumnIsUndefined = discriminatorColumnIsUndefined;
        this.firePropertyChanged("discriminatorColumnIsUndefined", old, discriminatorColumnIsUndefined);
    }

    @Override
    public boolean specifiedTableIsAllowed() {
        return this.specifiedTableIsAllowed;
    }

    protected void setSpecifiedTableIsAllowed(boolean specifiedTableIsAllowed) {
        boolean old = this.specifiedTableIsAllowed;
        this.specifiedTableIsAllowed = specifiedTableIsAllowed;
        this.firePropertyChanged("specifiedTableIsAllowed", old, specifiedTableIsAllowed);
    }

    @Override
    public boolean tableIsUndefined() {
        return this.tableIsUndefined;
    }

    protected void setTableIsUndefined(boolean tableIsUndefined) {
        boolean old = this.tableIsUndefined;
        this.tableIsUndefined = tableIsUndefined;
        this.firePropertyChanged("tableIsUndefined", old, tableIsUndefined);
    }

    @Override
    public JavaGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumns() : this.defaultPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumnsSize() : this.defaultPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.specifiedPrimaryKeyJoinColumns.isEmpty();
    }

    @Override
    public JavaPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return this.defaultPrimaryKeyJoinColumn;
    }

    protected void setDefaultPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn newPkJoinColumn) {
        JavaPrimaryKeyJoinColumn oldPkJoinColumn = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = newPkJoinColumn;
        this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldPkJoinColumn, newPkJoinColumn);
    }

    protected ListIterator<JavaPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns() {
        if (this.defaultPrimaryKeyJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultPrimaryKeyJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumn == null ? 0 : 1;
    }

    @Override
    public JavaPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn oldDefaultPkJoinColumn = this.getDefaultPrimaryKeyJoinColumn();
        if (oldDefaultPkJoinColumn != null) {
            this.defaultPrimaryKeyJoinColumn = null;
        }
        JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.buildPrimaryKeyJoinColumnOwner());
        this.specifiedPrimaryKeyJoinColumns.add(index, primaryKeyJoinColumn);
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = (PrimaryKeyJoinColumnAnnotation)((Object)this.javaResourcePersistentType.addAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"));
        primaryKeyJoinColumn.initialize(pkJoinColumnResource);
        this.fireItemAdded("specifiedPrimaryKeyJoinColumns", index, primaryKeyJoinColumn);
        if (oldDefaultPkJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldDefaultPkJoinColumn, null);
        }
        return primaryKeyJoinColumn;
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(int index, JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.size(), primaryKeyJoinColumn);
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(primaryKeyJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn removedPrimaryKeyJoinColumn = this.specifiedPrimaryKeyJoinColumns.remove(index);
        if (!this.containsSpecifiedPrimaryKeyJoinColumns()) {
            this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumnAnnotation(this.javaResourcePersistentType));
        }
        this.javaResourcePersistentType.removeAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumns", index, removedPrimaryKeyJoinColumn);
        if (this.defaultPrimaryKeyJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", null, this.defaultPrimaryKeyJoinColumn);
        }
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeItemFromList(primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        this.javaResourcePersistentType.moveAnnotation(targetIndex, sourceIndex, "javax.persistence.PrimaryKeyJoinColumns");
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    @Override
    public JavaAttributeOverrideContainer getAttributeOverrideContainer() {
        return this.attributeOverrideContainer;
    }

    @Override
    public JavaAssociationOverrideContainer getAssociationOverrideContainer() {
        return this.associationOverrideContainer;
    }

    @Override
    public JavaQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    @Override
    public Entity getParentEntity() {
        Iterator<PersistentType> stream = this.getPersistentType().ancestors();
        while (stream.hasNext()) {
            TypeMapping typeMapping = stream.next().getMapping();
            if (!(typeMapping instanceof Entity)) continue;
            return (Entity)typeMapping;
        }
        return null;
    }

    @Override
    public Entity getRootEntity() {
        return this.rootEntity;
    }

    @Override
    public boolean isRoot() {
        return this == this.getRootEntity();
    }

    protected boolean isDescendant() {
        return !this.isRoot();
    }

    @Override
    public String getDefaultTableName() {
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getName() : (this.isAbstractTablePerClass() ? null : this.getName());
    }

    @Override
    public String getDefaultSchema() {
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getSchema() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultSchema());
    }

    @Override
    public String getDefaultCatalog() {
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getCatalog() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultCatalog());
    }

    protected boolean isSingleTableDescendant() {
        return this.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE && this.isDescendant();
    }

    protected boolean isRootNoDescendantsNoStrategyDefined() {
        return this.isRoot() && !this.getPersistenceUnit().entityIsRootWithSubEntities(this.getName()) && this.getSpecifiedInheritanceStrategy() == null;
    }

    protected boolean isAbstractTablePerClass() {
        return this.isAbstract() && this.isTablePerClass();
    }

    protected boolean isTablePerClass() {
        return this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS;
    }

    protected boolean isTablePerClassDescendant() {
        return this.isTablePerClass() && this.isDescendant();
    }

    protected boolean isAbstract() {
        return this.javaResourcePersistentType.isAbstract();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return AbstractJavaEntity.getPrimaryKeyColumnName(this);
    }

    public static String getPrimaryKeyColumnName(Entity entity) {
        String pkColumnName = null;
        Iterator<PersistentAttribute> stream = entity.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            AttributeOverride attributeOverride;
            PersistentAttribute attribute = stream.next();
            String current = attribute.getPrimaryKeyColumnName();
            if (current != null && (attributeOverride = entity.getAttributeOverrideContainer().getAttributeOverrideNamed(attribute.getName())) != null) {
                current = attributeOverride.getColumn().getName();
            }
            if (pkColumnName == null) {
                pkColumnName = current;
                continue;
            }
            if (current == null) continue;
            return null;
        }
        return pkColumnName;
    }

    @Override
    public PersistentAttribute getIdAttribute() {
        Iterable<AttributeMapping> idAttributeMappings = this.getAllAttributeMappings("id");
        if (CollectionTools.size(idAttributeMappings) != 1) {
            return null;
        }
        return idAttributeMappings.iterator().next().getPersistentAttribute();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        if (this.tableIsUndefined()) {
            return false;
        }
        return !CollectionTools.contains(this.associatedTableNamesIncludingInherited(), (Object)tableName);
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return super.shouldValidateAgainstDatabase() && !this.isAbstractTablePerClass();
    }

    @Override
    public Iterator<Table> associatedTables() {
        return new CompositeIterator((Object)this.getTable(), this.secondaryTables());
    }

    @Override
    public Iterator<Table> associatedTablesIncludingInherited() {
        return this.getAssociatedTablesIncludingInherited().iterator();
    }

    protected Iterable<Table> getAssociatedTablesIncludingInherited() {
        return new CompositeIterable((Iterable)new TransformationIterable<TypeMapping, Iterable<Table>>(this.getInheritanceHierarchy()){

            protected Iterable<Table> transform(TypeMapping mapping) {
                return new FilteringIterable<Table>(CollectionTools.iterable(mapping.associatedTables())){

                    protected boolean accept(Table o) {
                        return true;
                    }
                };
            }
        });
    }

    @Override
    public Iterator<String> associatedTableNamesIncludingInherited() {
        return this.nonNullTableNames(this.associatedTablesIncludingInherited());
    }

    protected Iterator<String> nonNullTableNames(Iterator<Table> tables) {
        return new FilteringIterator<String>(this.tableNames(tables)){

            protected boolean accept(String o) {
                return o != null;
            }
        };
    }

    protected Iterator<String> tableNames(Iterator<Table> tables) {
        return new TransformationIterator<Table, String>(tables){

            protected String transform(Table t) {
                return t.getName();
            }
        };
    }

    protected Iterator<TypeMapping> ancestors() {
        return new TransformationIterator<PersistentType, TypeMapping>(this.getPersistentType().ancestors()){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        if (!this.isTablePerClass()) {
            return EmptyIterator.instance();
        }
        return super.overridableAttributeNames();
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        JavaAttributeOverride override = this.getAttributeOverrideContainer().getAttributeOverrideNamed(attributeName);
        if (override != null && !override.isVirtual()) {
            return override.getColumn();
        }
        return super.resolveOverriddenColumn(attributeName);
    }

    @Override
    public RelationshipReference resolveRelationshipReference(String attributeName) {
        JavaAssociationOverride override = this.getAssociationOverrideContainer().getAssociationOverrideNamed(attributeName);
        if (override != null && !override.isVirtual()) {
            return override.getRelationshipReference();
        }
        return super.resolveRelationshipReference(attributeName);
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        if (!this.isTablePerClass()) {
            return EmptyIterator.instance();
        }
        return super.overridableAssociationNames();
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String name) {
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.allAttributeMappings())) {
            AttributeMapping resolvedMapping = attributeMapping.resolveAttributeMapping(name);
            if (resolvedMapping == null) continue;
            return resolvedMapping;
        }
        return null;
    }

    @Override
    public void update(JavaResourcePersistentType resourcePersistentType) {
        super.update(resourcePersistentType);
        this.setSpecifiedName_(this.getResourceName());
        this.setDefaultName(this.getResourceDefaultName());
        this.idClassReference.update();
        this.updateRootEntity();
        this.updateInheritance(this.getResourceInheritance());
        this.updateDiscriminatorColumn();
        this.updateDiscriminatorValue(this.getResourceDiscriminatorValue());
        this.setSpecifiedTableIsAllowed(this.buildSpecifiedTableIsAllowed());
        this.setTableIsUndefined(this.buildTableIsUndefined());
        this.updateTable();
        this.updateSecondaryTables();
        this.generatorContainer.update(resourcePersistentType);
        this.queryContainer.update(resourcePersistentType);
        this.updateSpecifiedPrimaryKeyJoinColumns();
        this.updateDefaultPrimaryKeyJoinColumn();
        this.attributeOverrideContainer.update(resourcePersistentType);
        this.associationOverrideContainer.update(resourcePersistentType);
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.postUpdateDiscriminatorColumn();
        this.postUpdateDiscriminatorValue();
        this.associationOverrideContainer.postUpdate();
    }

    protected String getResourceName() {
        return this.getResourceMappingAnnotation().getName();
    }

    protected String getResourceDefaultName() {
        return this.javaResourcePersistentType.getName();
    }

    protected void updateTable() {
        this.getTable().update(this.javaResourcePersistentType);
    }

    protected void updateInheritance(InheritanceAnnotation inheritanceResource) {
        this.setSpecifiedInheritanceStrategy_(this.getResourceInheritanceStrategy(inheritanceResource));
        this.setDefaultInheritanceStrategy(this.buildDefaultInheritanceStrategy());
    }

    protected InheritanceType getResourceInheritanceStrategy(InheritanceAnnotation inheritanceResource) {
        return InheritanceType.fromJavaResourceModel(inheritanceResource.getStrategy());
    }

    protected InheritanceType buildDefaultInheritanceStrategy() {
        return this.isRoot() ? InheritanceType.SINGLE_TABLE : this.getRootEntity().getInheritanceStrategy();
    }

    protected void updateRootEntity() {
        this.rootEntity = this.calculateRootEntity();
        if (this.rootEntity != this) {
            this.rootEntity.addSubEntity(this);
        }
    }

    protected Entity calculateRootEntity() {
        Entity root = this;
        Iterator<TypeMapping> stream = this.inheritanceHierarchy();
        while (stream.hasNext()) {
            TypeMapping typeMapping = stream.next();
            if (!(typeMapping instanceof Entity)) continue;
            root = (Entity)typeMapping;
        }
        return root;
    }

    @Override
    public void addSubEntity(Entity subEntity) {
        this.getPersistenceUnit().addRootEntityWithSubEntities(this.getName());
    }

    protected void updateDiscriminatorColumn() {
        this.setSpecifiedDiscriminatorColumnIsAllowed(this.buildSpecifiedDiscriminatorColumnIsAllowed());
        this.getDiscriminatorColumn().update(this.getResourceDiscriminatorColumn());
    }

    protected void postUpdateDiscriminatorColumn() {
        this.setDiscriminatorColumnIsUndefined(this.buildDiscriminatorColumnIsUndefined());
        this.getDiscriminatorColumn().postUpdate();
    }

    protected void updateDiscriminatorValue(DiscriminatorValueAnnotation discriminatorValueResource) {
        this.setSpecifiedDiscriminatorValueIsAllowed(this.buildSpecifiedDiscriminatorValueIsAllowed());
        this.setSpecifiedDiscriminatorValue_(discriminatorValueResource.getValue());
    }

    protected void postUpdateDiscriminatorValue() {
        this.setDiscriminatorValueIsUndefined(this.buildDiscriminatorValueIsUndefined());
        this.setDefaultDiscriminatorValue(this.buildDefaultDiscriminatorValue());
    }

    protected String buildDefaultDiscriminatorValue() {
        if (this.discriminatorValueIsUndefined()) {
            return null;
        }
        if (this.getDiscriminatorType() != DiscriminatorType.STRING) {
            return null;
        }
        return this.getName();
    }

    protected DiscriminatorType getDiscriminatorType() {
        return this.getDiscriminatorColumn().getDiscriminatorType();
    }

    protected boolean buildSpecifiedDiscriminatorValueIsAllowed() {
        return !this.isTablePerClass() && !this.isAbstract();
    }

    protected boolean buildDiscriminatorValueIsUndefined() {
        return this.isTablePerClass() || this.isAbstract() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return !this.isTablePerClass() && this.isRoot();
    }

    protected boolean buildDiscriminatorColumnIsUndefined() {
        return this.isTablePerClass() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected boolean buildSpecifiedTableIsAllowed() {
        return !this.isAbstractTablePerClass() && !this.isSingleTableDescendant();
    }

    protected boolean buildTableIsUndefined() {
        return this.isAbstractTablePerClass();
    }

    protected void updateSecondaryTables() {
        ListIterator<JavaSecondaryTable> secondaryTables = this.specifiedSecondaryTables();
        Iterator<NestableAnnotation> resourceSecondaryTables = this.javaResourcePersistentType.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        while (secondaryTables.hasNext()) {
            JavaSecondaryTable secondaryTable = secondaryTables.next();
            if (resourceSecondaryTables.hasNext()) {
                secondaryTable.update((SecondaryTableAnnotation)((Object)resourceSecondaryTables.next()));
                continue;
            }
            this.removeSpecifiedSecondaryTable_(secondaryTable);
        }
        while (resourceSecondaryTables.hasNext()) {
            this.addSpecifiedSecondaryTable(this.buildSecondaryTable((SecondaryTableAnnotation)((Object)resourceSecondaryTables.next())));
        }
    }

    protected JavaSecondaryTable buildSecondaryTable(SecondaryTableAnnotation secondaryTableResource) {
        JavaSecondaryTable secondaryTable = this.getJpaFactory().buildJavaSecondaryTable(this);
        secondaryTable.initialize(secondaryTableResource);
        return secondaryTable;
    }

    protected void updateSpecifiedPrimaryKeyJoinColumns() {
        ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns = this.specifiedPrimaryKeyJoinColumns();
        Iterator<NestableAnnotation> resourcePrimaryKeyJoinColumns = this.javaResourcePersistentType.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (primaryKeyJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = primaryKeyJoinColumns.next();
            if (resourcePrimaryKeyJoinColumns.hasNext()) {
                primaryKeyJoinColumn.update((PrimaryKeyJoinColumnAnnotation)((Object)resourcePrimaryKeyJoinColumns.next()));
                continue;
            }
            this.removeSpecifiedPrimaryKeyJoinColumn_(primaryKeyJoinColumn);
        }
        while (resourcePrimaryKeyJoinColumns.hasNext()) {
            this.addSpecifiedPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)((Object)resourcePrimaryKeyJoinColumns.next())));
        }
    }

    protected JavaPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnResource) {
        JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.buildPrimaryKeyJoinColumnOwner());
        primaryKeyJoinColumn.initialize(primaryKeyJoinColumnResource);
        return primaryKeyJoinColumn;
    }

    protected void updateDefaultPrimaryKeyJoinColumn() {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            this.setDefaultPrimaryKeyJoinColumn(null);
            return;
        }
        if (this.getDefaultPrimaryKeyJoinColumn() == null) {
            this.setDefaultPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumnAnnotation(this.javaResourcePersistentType)));
        } else {
            this.defaultPrimaryKeyJoinColumn.update(new NullPrimaryKeyJoinColumnAnnotation(this.javaResourcePersistentType));
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getTable().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaSecondaryTable sTable : CollectionTools.iterable(this.secondaryTables())) {
            result = sTable.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaPrimaryKeyJoinColumn column : CollectionTools.iterable(this.primaryKeyJoinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        result = this.getAttributeOverrideContainer().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getAssociationOverrideContainer().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getDiscriminatorColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getGeneratorContainer().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validatePrimaryKey(messages, reporter, astRoot);
        this.validateTable(messages, reporter, astRoot);
        ListIterator<JavaSecondaryTable> stream = this.specifiedSecondaryTables();
        while (stream.hasNext()) {
            ((JavaSecondaryTable)stream.next()).validate(messages, reporter, astRoot);
        }
        this.validateInheritance(messages, reporter, astRoot);
        this.getGeneratorContainer().validate(messages, reporter, astRoot);
        this.getQueryContainer().validate(messages, reporter, astRoot);
        this.getAttributeOverrideContainer().validate(messages, reporter, astRoot);
        this.getAssociationOverrideContainer().validate(messages, reporter, astRoot);
    }

    protected void validatePrimaryKey(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.buildPrimaryKeyValidator(astRoot).validate(messages, reporter);
    }

    protected PrimaryKeyValidator buildPrimaryKeyValidator(CompilationUnit astRoot) {
        return new GenericEntityPrimaryKeyValidator(this, this.buildTextRangeResolver(astRoot));
    }

    protected PrimaryKeyTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaEntityTextRangeResolver(this, astRoot);
    }

    protected void validateTable(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.isAbstractTablePerClass()) {
            if (this.table.isResourceSpecified()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE", new String[]{this.getName()}, this, this.getTable().getValidationTextRange(astRoot)));
            }
            return;
        }
        if (this.isSingleTableDescendant()) {
            if (this.table.isResourceSpecified()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE", new String[]{this.getName()}, this, this.getTable().getValidationTextRange(astRoot)));
            }
            return;
        }
        this.table.validate(messages, reporter, astRoot);
    }

    protected void validateInheritance(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.validateInheritanceStrategy(messages, astRoot);
        this.validateDiscriminatorColumn(messages, reporter, astRoot);
        this.validateDiscriminatorValue(messages, astRoot);
    }

    protected void validateDiscriminatorColumn(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.specifiedDiscriminatorColumnIsAllowed() && !this.discriminatorColumnIsUndefined()) {
            this.getDiscriminatorColumn().validate(messages, reporter, astRoot);
        } else if (this.getDiscriminatorColumn().isResourceSpecified()) {
            if (!this.isRoot()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange(astRoot)));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange(astRoot)));
            }
        }
    }

    protected void validateDiscriminatorValue(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.discriminatorValueIsUndefined() && this.getSpecifiedDiscriminatorValue() != null) {
            if (this.isAbstract()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange(astRoot)));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange(astRoot)));
            }
        }
    }

    protected void validateInheritanceStrategy(List<IMessage> messages, CompilationUnit astRoot) {
        JpaPlatformVariation.Supported tablePerConcreteClassInheritanceIsSupported = this.getJpaPlatformVariation().getTablePerConcreteClassInheritanceIsSupported();
        if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.YES) {
            return;
        }
        if (this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS && this.isRoot()) {
            if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.NO) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange(astRoot)));
            }
        }
    }

    protected TextRange getDiscriminatorValueTextRange(CompilationUnit astRoot) {
        return this.getResourceDiscriminatorValue().getTextRange(astRoot);
    }

    protected TextRange getDiscriminatorColumnTextRange(CompilationUnit astRoot) {
        return this.getDiscriminatorColumn().getValidationTextRange(astRoot);
    }

    protected TextRange getInheritanceStrategyTextRange(CompilationUnit astRoot) {
        return this.getResourceInheritance().getStrategyTextRange(astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AssociationOverrideContainerOwner
    implements JavaAssociationOverrideContainer.Owner {
        protected AssociationOverrideContainerOwner() {
        }

        @Override
        public TypeMapping getTypeMapping() {
            return AbstractJavaEntity.this.getTypeMapping();
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractJavaEntity.this.getOverridableTypeMapping();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : typeMapping.allOverridableAssociationNames();
        }

        @Override
        public RelationshipReference resolveRelationshipReference(String associationOverrideName) {
            return MappingTools.resolveRelationshipReference(this.getOverridableTypeMapping(), associationOverrideName);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return AbstractJavaEntity.this.tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return AbstractJavaEntity.this.associatedTableNamesIncludingInherited();
        }

        @Override
        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return AbstractJavaEntity.this.getDbTable(tableName);
        }

        @Override
        public String getDefaultTableName() {
            return AbstractJavaEntity.this.getPrimaryTableName();
        }

        @Override
        public String getPossiblePrefix() {
            return null;
        }

        @Override
        public String getWritePrefix() {
            return null;
        }

        @Override
        public boolean isRelevant(String overrideName) {
            return true;
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaEntity.this.getValidationTextRange(astRoot);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedReferencedColumnNameMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedReferencedColumnNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME", new String[]{column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualColumnUnresolvedReferencedColumnNameMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME", new String[]{overrideName, column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualUnspecifiedNameMultipleJoinColumnsMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[0], column, textRange);
        }

        protected IMessage buildVirtualUnspecifiedNameMultipleJoinColumnsMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{overrideName}, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[0], column, textRange);
        }

        protected IMessage buildVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{overrideName}, column, textRange);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeOverrideContainerOwner
    implements JavaAttributeOverrideContainer.Owner {
        protected AttributeOverrideContainerOwner() {
        }

        @Override
        public TypeMapping getTypeMapping() {
            return AbstractJavaEntity.this.getTypeMapping();
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractJavaEntity.this.getOverridableTypeMapping();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : this.allOverridableAttributeNames_(typeMapping);
        }

        protected Iterator allOverridableAttributeNames_(TypeMapping typeMapping) {
            HashBag mappedByRelationshipAttributes = CollectionTools.collection((Iterator)new TransformationIterator<SingleRelationshipMapping2_0, String>(this.getMapsIdRelationships()){

                protected String transform(SingleRelationshipMapping2_0 next) {
                    return next.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getValue();
                }
            });
            return new FilteringIterator<String>(typeMapping.allOverridableAttributeNames(), (Collection)mappedByRelationshipAttributes){
                private final /* synthetic */ Collection val$mappedByRelationshipAttributes;
                {
                    this.val$mappedByRelationshipAttributes = collection;
                    super($anonymous0);
                }

                protected boolean accept(String o) {
                    if (this.val$mappedByRelationshipAttributes.isEmpty()) {
                        return true;
                    }
                    String qualifier = o.indexOf(46) > 0 ? o.substring(0, o.indexOf(46)) : o;
                    return !this.val$mappedByRelationshipAttributes.contains(qualifier);
                }
            };
        }

        protected Iterable<SingleRelationshipMapping2_0> getMapsIdRelationships() {
            return new FilteringIterable<SingleRelationshipMapping2_0>((Iterable)new SubIterableWrapper((Iterable)new CompositeIterable(new Iterable[]{this.getTypeMapping().getAllAttributeMappings("oneToOne"), this.getTypeMapping().getAllAttributeMappings("manyToOne")}))){

                protected boolean accept(SingleRelationshipMapping2_0 o) {
                    return o.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy();
                }
            };
        }

        @Override
        public Column resolveOverriddenColumn(String attributeOverrideName) {
            return MappingTools.resolveOverridenColumn(this.getOverridableTypeMapping(), attributeOverrideName);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return AbstractJavaEntity.this.tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return AbstractJavaEntity.this.associatedTableNamesIncludingInherited();
        }

        @Override
        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return AbstractJavaEntity.this.getDbTable(tableName);
        }

        @Override
        public String getDefaultTableName() {
            return AbstractJavaEntity.this.getPrimaryTableName();
        }

        @Override
        public String getPossiblePrefix() {
            return null;
        }

        @Override
        public String getWritePrefix() {
            return null;
        }

        @Override
        public boolean isRelevant(String overrideName) {
            return true;
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaEntity.this.getValidationTextRange(astRoot);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        protected IMessage buildVirtualColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }
    }

    protected class PrimaryKeyJoinColumnOwner
    implements JavaBaseJoinColumn.Owner {
        protected PrimaryKeyJoinColumnOwner() {
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaEntity.this.getValidationTextRange(astRoot);
        }

        public TypeMapping getTypeMapping() {
            return AbstractJavaEntity.this;
        }

        public String getDefaultTableName() {
            return AbstractJavaEntity.this.getPrimaryTableName();
        }

        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return AbstractJavaEntity.this.getDbTable(tableName);
        }

        public org.eclipse.jpt.db.Table getReferencedColumnDbTable() {
            Entity parentEntity = AbstractJavaEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return AbstractJavaEntity.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return AbstractJavaEntity.this.defaultPrimaryKeyJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            Entity parentEntity = AbstractJavaEntity.this.getParentEntity();
            return parentEntity == null ? AbstractJavaEntity.this.getPrimaryKeyColumnName() : parentEntity.getPrimaryKeyColumnName();
        }

        public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet: bug 148262");
        }

        public IMessage buildUnresolvedReferencedColumnNameMessage(BaseJoinColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet: bug 148262");
        }

        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet: bug 148262");
        }

        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet: bug 148262");
        }
    }
}

