/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.java.JavaJoinTableJoiningStrategy;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.jpa1.context.java.GenericJavaReferenceTable;
import org.eclipse.jpt.core.internal.resource.java.NullJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinTable
extends GenericJavaReferenceTable
implements JavaJoinTable {
    protected JavaJoinColumn defaultInverseJoinColumn;
    protected final Vector<JavaJoinColumn> specifiedInverseJoinColumns = new Vector();
    protected final JavaJoinColumn.Owner inverseJoinColumnOwner = this.buildInverseJoinColumnOwner();

    public GenericJavaJoinTable(JavaJoinTableJoiningStrategy parent) {
        super(parent);
    }

    @Override
    protected JavaJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    protected JavaJoinColumn.Owner buildInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getParent().getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public PersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    @Override
    public void initialize(JoinTableAnnotation joinTable) {
        super.initialize(joinTable);
        this.initializeSpecifiedInverseJoinColumns(joinTable);
        this.initializeDefaultInverseJoinColumn(joinTable);
    }

    @Override
    public void update(JoinTableAnnotation joinTable) {
        super.update(joinTable);
        this.updateSpecifiedInverseJoinColumns(joinTable);
        this.updateDefaultInverseJoinColumn(joinTable);
    }

    @Override
    public JavaJoinTableJoiningStrategy getParent() {
        return (JavaJoinTableJoiningStrategy)super.getParent();
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    protected String buildDefaultName() {
        return this.getParent().getJoinTableDefaultName();
    }

    @Override
    protected JoinTableAnnotation getAnnotation() {
        return this.getParent().getAnnotation();
    }

    @Override
    public ListIterator<JavaJoinColumn> inverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumns() : this.defaultInverseJoinColumns();
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumnsSize() : this.defaultInverseJoinColumnsSize();
    }

    @Override
    public void convertDefaultToSpecifiedInverseJoinColumn() {
        MappingTools.convertJoinTableDefaultToSpecifiedInverseJoinColumn(this);
    }

    protected JavaJoinColumn buildInverseJoinColumn(JoinColumnAnnotation joinColumnAnnotation) {
        return this.buildJoinColumn(joinColumnAnnotation, this.inverseJoinColumnOwner);
    }

    @Override
    public JavaJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(JavaJoinColumn defaultInverseJoinColumn) {
        JavaJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = defaultInverseJoinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, defaultInverseJoinColumn);
    }

    protected ListIterator<JavaJoinColumn> defaultInverseJoinColumns() {
        if (this.defaultInverseJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultInverseJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void initializeDefaultInverseJoinColumn(JoinTableAnnotation joinTableAnnotation) {
        if (this.shouldBuildDefaultInverseJoinColumn()) {
            this.defaultInverseJoinColumn = this.buildInverseJoinColumn(new NullJoinColumnAnnotation(joinTableAnnotation));
        }
    }

    protected boolean shouldBuildDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    protected void updateDefaultInverseJoinColumn(JoinTableAnnotation joinTableAnnotation) {
        if (this.shouldBuildDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(new NullJoinColumnAnnotation(joinTableAnnotation)));
            } else {
                this.defaultInverseJoinColumn.update(new NullJoinColumnAnnotation(joinTableAnnotation));
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedInverseJoinColumns() {
        return new CloneListIterator(this.specifiedInverseJoinColumns);
    }

    @Override
    public int specifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return this.specifiedInverseJoinColumns.size() != 0;
    }

    @Override
    public JavaJoinColumn addSpecifiedInverseJoinColumn(int index) {
        JavaJoinColumn oldDefault = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = null;
        JavaJoinColumn inverseJoinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.inverseJoinColumnOwner);
        this.specifiedInverseJoinColumns.add(index, inverseJoinColumn);
        JoinTableAnnotation joinTableAnnotation = this.getAnnotation();
        JoinColumnAnnotation joinColumnAnnotation = joinTableAnnotation.addInverseJoinColumn(index);
        inverseJoinColumn.initialize(joinColumnAnnotation);
        this.fireItemAdded("specifiedInverseJoinColumns", index, inverseJoinColumn);
        this.firePropertyChanged("defaultInverseJoinColumn", oldDefault, null);
        return inverseJoinColumn;
    }

    protected void addSpecifiedInverseJoinColumn(int index, JavaJoinColumn inverseJoinColumn) {
        this.addItemToList(index, inverseJoinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    protected void addSpecifiedInverseJoinColumn(JavaJoinColumn inverseJoinColumn) {
        this.addSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.size(), inverseJoinColumn);
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(JoinColumn inverseJoinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.indexOf(inverseJoinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedInverseJoinColumns.remove(index);
        if (!this.hasSpecifiedInverseJoinColumns()) {
            this.defaultInverseJoinColumn = this.buildInverseJoinColumn(new NullJoinColumnAnnotation(this.getAnnotation()));
        }
        this.getAnnotation().removeInverseJoinColumn(index);
        this.fireItemRemoved("specifiedInverseJoinColumns", index, removedJoinColumn);
        if (this.defaultInverseJoinColumn != null) {
            this.firePropertyChanged("defaultInverseJoinColumn", null, this.defaultInverseJoinColumn);
        }
    }

    protected void removeSpecifiedInverseJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedInverseJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getAnnotation().moveInverseJoinColumn(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedInverseJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedInverseJoinColumns() {
        int i = this.specifiedInverseJoinColumns.size();
        while (i-- > 0) {
            this.removeSpecifiedInverseJoinColumn(i);
        }
    }

    protected void initializeSpecifiedInverseJoinColumns(JoinTableAnnotation joinTableAnnotation) {
        ListIterator<JoinColumnAnnotation> stream = joinTableAnnotation.inverseJoinColumns();
        while (stream.hasNext()) {
            this.specifiedInverseJoinColumns.add(this.buildInverseJoinColumn(stream.next()));
        }
    }

    protected void updateSpecifiedInverseJoinColumns(JoinTableAnnotation joinTableAnnotation) {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedInverseJoinColumns();
        ListIterator<JoinColumnAnnotation> joinColumnAnnotations = joinTableAnnotation.inverseJoinColumns();
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (joinColumnAnnotations.hasNext()) {
                joinColumn.update(joinColumnAnnotations.next());
                continue;
            }
            this.removeSpecifiedInverseJoinColumn_(joinColumn);
        }
        while (joinColumnAnnotations.hasNext()) {
            this.addSpecifiedInverseJoinColumn(this.buildInverseJoinColumn(joinColumnAnnotations.next()));
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.inverseJoinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validateJoinColumns(messages, reporter, astRoot);
        this.validateJoinColumns(this.inverseJoinColumns(), messages, reporter, astRoot);
    }

    @Override
    protected boolean shouldValidateAgainstDatabase() {
        return this.getParent().shouldValidateAgainstDatabase();
    }

    @Override
    protected String getUnresolvedCatalogMessageId() {
        return "JOIN_TABLE_UNRESOLVED_CATALOG";
    }

    @Override
    protected String getUnresolvedSchemaMessageId() {
        return "JOIN_TABLE_UNRESOLVED_SCHEMA";
    }

    @Override
    protected String getUnresolvedNameMessageId() {
        return "JOIN_TABLE_UNRESOLVED_NAME";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractJoinColumnOwner
    implements JavaJoinColumn.Owner {
        protected AbstractJoinColumnOwner() {
        }

        @Override
        public TypeMapping getTypeMapping() {
            return GenericJavaJoinTable.this.getParent().getRelationshipReference().getTypeMapping();
        }

        @Override
        public PersistentAttribute getPersistentAttribute() {
            return GenericJavaJoinTable.this.getPersistentAttribute();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return !StringTools.stringsAreEqual((String)this.getDefaultTableName(), (String)tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return EmptyIterator.instance();
        }

        @Override
        public Table getDbTable(String tableName) {
            if (GenericJavaJoinTable.this.getName() == null) {
                return null;
            }
            return GenericJavaJoinTable.this.getName().equals(tableName) ? GenericJavaJoinTable.this.getDbTable() : null;
        }

        @Override
        public String getDefaultTableName() {
            return GenericJavaJoinTable.this.getName();
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaJoinTable.this.getValidationTextRange(astRoot);
        }

        @Override
        public IMessage buildTableNotValidMessage(BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getTableNotValidMessage(), new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_JOIN_TABLE}, column, textRange);
        }

        protected abstract String getTableNotValidMessage();

        @Override
        public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getUnresolvedNameMessage(), new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected abstract String getUnresolvedNameMessage();

        @Override
        public IMessage buildUnresolvedReferencedColumnNameMessage(BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getUnresolvedReferencedColumnNameMessage(), new String[]{column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        protected abstract String getUnresolvedReferencedColumnNameMessage();

        @Override
        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getUnspecifiedNameMultipleJoinColumnsMessage(), new String[0], column, textRange);
        }

        protected abstract String getUnspecifiedNameMultipleJoinColumnsMessage();

        @Override
        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(), new String[0], column, textRange);
        }

        protected abstract String getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage();
    }

    protected class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected InverseJoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericJavaJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericJavaJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        public Table getReferencedColumnDbTable() {
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericJavaJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericJavaJoinTable.this.inverseJoinColumnsSize();
        }

        protected String getUnresolvedNameMessage() {
            return "INVERSE_JOIN_COLUMN_UNRESOLVED_NAME";
        }

        protected String getTableNotValidMessage() {
            return "INVERSE_JOIN_COLUMN_TABLE_NOT_VALID";
        }

        protected String getUnresolvedReferencedColumnNameMessage() {
            return "INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME";
        }

        protected String getUnspecifiedNameMultipleJoinColumnsMessage() {
            return "INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }

        protected String getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
            return "INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }
    }

    protected class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected JoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            return GenericJavaJoinTable.this.getParent().getRelationshipReference().getEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericJavaJoinTable.this.getRelationshipMapping();
            if (relationshipMapping == null) {
                return null;
            }
            Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
            if (targetEntity == null) {
                return null;
            }
            for (PersistentAttribute each : CollectionTools.iterable(targetEntity.getPersistentType().allAttributes())) {
                if (!each.getMapping().isOwnedBy(relationshipMapping)) continue;
                return each.getName();
            }
            return null;
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericJavaJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericJavaJoinTable.this.joinColumnsSize();
        }

        protected String getUnresolvedNameMessage() {
            return "JOIN_COLUMN_UNRESOLVED_NAME";
        }

        protected String getTableNotValidMessage() {
            return "JOIN_COLUMN_TABLE_NOT_VALID";
        }

        protected String getUnspecifiedNameMultipleJoinColumnsMessage() {
            return "JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }

        protected String getUnresolvedReferencedColumnNameMessage() {
            return "JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME";
        }

        protected String getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
            return "JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS";
        }
    }
}

