/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.persistence;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.persistence.Persistence2_0;
import org.eclipse.jpt.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistence
extends AbstractPersistenceXmlContextNode
implements Persistence2_0 {
    protected XmlPersistence xmlPersistence;
    protected PersistenceUnit persistenceUnit;

    public GenericPersistence(PersistenceXml parent, XmlPersistence xmlPersistence) {
        super(parent);
        this.xmlPersistence = xmlPersistence;
        this.initializePersistenceUnits();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.persistence";
    }

    @Override
    public XmlPersistence getXmlPersistence() {
        return this.xmlPersistence;
    }

    @Override
    public PersistenceXml getParent() {
        return (PersistenceXml)super.getParent();
    }

    @Override
    public ListIterator<PersistenceUnit> persistenceUnits() {
        return this.persistenceUnit == null ? EmptyListIterator.instance() : this.persistenceUnits_();
    }

    protected ListIterator<PersistenceUnit> persistenceUnits_() {
        return new SingleElementListIterator((Object)this.persistenceUnit);
    }

    protected Iterable<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnit == null ? EmptyIterable.instance() : this.getPersistenceUnits_();
    }

    protected Iterable<PersistenceUnit> getPersistenceUnits_() {
        return new SingleElementIterable((Object)this.persistenceUnit);
    }

    @Override
    public int persistenceUnitsSize() {
        return this.persistenceUnit == null ? 0 : 1;
    }

    @Override
    public PersistenceUnit addPersistenceUnit() {
        return this.addPersistenceUnit(this.persistenceUnitsSize());
    }

    @Override
    public PersistenceUnit addPersistenceUnit(int index) {
        if (index > 0 || this.persistenceUnit != null) {
            throw new IllegalStateException("This implementation does not support multiple persistence units.");
        }
        XmlPersistenceUnit xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        this.persistenceUnit = this.buildPersistenceUnit(xmlPersistenceUnit);
        this.xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        this.fireItemAdded("persistenceUnits", index, this.persistenceUnit);
        return this.persistenceUnit;
    }

    @Override
    public void removePersistenceUnit(PersistenceUnit pu) {
        if (pu != this.persistenceUnit) {
            throw new IllegalArgumentException("Invalid persistence unit: " + pu);
        }
        this.removePersistenceUnit(0);
    }

    @Override
    public void removePersistenceUnit(int index) {
        if (index > 0 || this.persistenceUnit == null) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        PersistenceUnit oldPersistenceUnit = this.persistenceUnit;
        this.persistenceUnit.dispose();
        this.persistenceUnit = null;
        this.xmlPersistence.getPersistenceUnits().remove(index);
        this.fireItemRemoved("persistenceUnits", index, oldPersistenceUnit);
    }

    protected void addPersistenceUnit_(PersistenceUnit newPersistenceUnit) {
        this.persistenceUnit = newPersistenceUnit;
        this.fireItemAdded("persistenceUnits", 0, this.persistenceUnit);
    }

    protected void removePersistenceUnit_(PersistenceUnit oldPersistenceUnit) {
        this.persistenceUnit.dispose();
        this.persistenceUnit = null;
        this.fireItemRemoved("persistenceUnits", 0, oldPersistenceUnit);
    }

    @Override
    public void initializeMetamodel() {
        for (PersistenceUnit pu : this.getPersistenceUnits()) {
            ((PersistenceUnit2_0)pu).initializeMetamodel();
        }
    }

    @Override
    public void synchronizeMetamodel() {
        for (PersistenceUnit pu : this.getPersistenceUnits()) {
            ((PersistenceUnit2_0)pu).synchronizeMetamodel();
        }
    }

    @Override
    public void disposeMetamodel() {
        for (PersistenceUnit pu : this.getPersistenceUnits()) {
            ((PersistenceUnit2_0)pu).disposeMetamodel();
        }
    }

    protected void initializePersistenceUnits() {
        if (this.xmlPersistence.getPersistenceUnits().size() > 0) {
            this.persistenceUnit = this.buildPersistenceUnit((XmlPersistenceUnit)this.xmlPersistence.getPersistenceUnits().get(0));
        }
    }

    @Override
    public void update(XmlPersistence persistence) {
        this.xmlPersistence = persistence;
        XmlPersistenceUnit xmlPersistenceUnit = null;
        if (persistence.getPersistenceUnits().size() > 0) {
            xmlPersistenceUnit = (XmlPersistenceUnit)persistence.getPersistenceUnits().get(0);
        }
        if (this.persistenceUnit != null) {
            if (xmlPersistenceUnit != null) {
                this.persistenceUnit.update(xmlPersistenceUnit);
            } else {
                this.removePersistenceUnit_(this.persistenceUnit);
            }
        } else if (xmlPersistenceUnit != null) {
            this.addPersistenceUnit_(this.buildPersistenceUnit(xmlPersistenceUnit));
        }
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.persistenceUnit != null) {
            this.persistenceUnit.postUpdate();
        }
    }

    protected PersistenceUnit buildPersistenceUnit(XmlPersistenceUnit xmlPersistenceUnit) {
        return this.getContextNodeFactory().buildPersistenceUnit(this, xmlPersistenceUnit);
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (PersistenceUnit pu : this.getPersistenceUnits()) {
            if (!pu.containsOffset(textOffset)) continue;
            return pu.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlPersistence == null ? false : this.xmlPersistence.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlPersistence.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.xmlPersistence.getValidationTextRange();
    }

    @Override
    public void dispose() {
        for (PersistenceUnit pu : this.getPersistenceUnits()) {
            pu.dispose();
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateVersion(messages);
        this.checkForMultiplePersistenceUnits(messages);
        this.validatePersistenceUnit(messages, reporter);
    }

    protected void validateVersion(List<IMessage> messages) {
        if (!this.latestDocumentVersion().equals(this.xmlPersistence.getVersion())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(4, "XML_VERSION_NOT_LATEST", this, this.xmlPersistence.getVersionTextRange()));
        }
    }

    protected String latestDocumentVersion() {
        return this.getJpaPlatform().getMostRecentSupportedResourceType(JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE).getVersion();
    }

    protected void checkForMultiplePersistenceUnits(List<IMessage> messages) {
        if (this.xmlPersistence.getPersistenceUnits().size() > 1) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PERSISTENCE_MULTIPLE_PERSISTENCE_UNITS", this, this.getValidationTextRange()));
        }
    }

    protected void validatePersistenceUnit(List<IMessage> messages, IReporter reporter) {
        if (this.persistenceUnit == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_NO_PERSISTENCE_UNIT", this, this.getValidationTextRange()));
            return;
        }
        this.persistenceUnit.validate(messages, reporter);
    }
}

