/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.project.facet.ProductManager;

public class ConvertStaticWebToDyamnicOperation
extends AbstractDataModelOperation {
    public ConvertStaticWebToDyamnicOperation() {
    }

    public ConvertStaticWebToDyamnicOperation(IDataModel dm) {
        super(dm);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            this.doConvert();
        }
        catch (Exception e) {
            WebPlugin.log(e);
        }
        return OK_STATUS;
    }

    protected void doConvert() throws Exception {
        String selectedVersion = this.model.getStringProperty("IConvertStaticWebToDyamnicProperties.CONVERT_TO_WEB_VERSION");
        IProject project = (IProject)this.model.getProperty("IConvertStaticWebToDyamnicProperties.PROJECT");
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
        fixedFacets.addAll(facetedProject.getFixedProjectFacets());
        IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"wst.web");
        fixedFacets.remove(webFacet);
        fixedFacets.add(WebFacetUtils.WEB_FACET);
        fixedFacets.add(JavaFacetUtils.JAVA_FACET);
        facetedProject.setFixedProjectFacets(fixedFacets);
        IProjectFacetVersion webFv = WebFacetUtils.WEB_FACET.getVersion(selectedVersion);
        IProjectFacetVersion javaFv = JavaFacetUtils.compilerLevelToFacet((String)JavaFacetUtils.getCompilerLevel((IProject)project));
        IFacetedProject.Action uninstall = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, facetedProject.getInstalledVersion(webFacet), null);
        IDataModel webModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetInstallDataModelProvider());
        webModelCfg.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        String webRoot = webModelCfg.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        c.create(0, null);
        if (c.exists()) {
            IVirtualFolder root = c.getRootFolder();
            webRoot = root.getUnderlyingFolder().getName();
            webModelCfg.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", webRoot);
        }
        IDataModel javaModelCfg = null;
        if (ProductManager.shouldUseSingleRootStructure()) {
            javaModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
            javaModelCfg.setProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", (Object)(String.valueOf(webRoot) + "/" + "WEB-INF/classes"));
        }
        IFacetedProject.Action install = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, webFv, (Object)webModelCfg);
        IFacetedProject.Action javaInstall = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javaFv, (Object)javaModelCfg);
        HashSet<IFacetedProject.Action> set = new HashSet<IFacetedProject.Action>();
        set.add(uninstall);
        set.add(install);
        set.add(javaInstall);
        facetedProject.modify(set, (IProgressMonitor)new NullProgressMonitor());
    }
}

