/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import org.eclipse.jpt.ui.internal.widgets.Dialog;
import org.eclipse.jpt.utility.internal.node.Node;
import org.eclipse.jpt.utility.internal.node.Problem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidatingDialog<T extends Node>
extends Dialog<T> {
    public ValidatingDialog(Shell parent) {
        super(parent);
    }

    public ValidatingDialog(Shell parent, String title) {
        super(parent, title);
    }

    @Override
    final Node.Validator buildValidator() {
        return new Node.Validator(){

            public void pause() {
            }

            public void resume() {
            }

            public void validate() {
                ValidatingDialog.this.validate();
            }
        };
    }

    protected final void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    protected String getDescription() {
        return null;
    }

    protected Image getDescriptionImage() {
        return null;
    }

    protected String getDescriptionTitle() {
        return null;
    }

    protected Point getInitialSize() {
        Point result = this.getShell().computeSize(-1, -1);
        Point paneSize = this.getPane().getControl().computeSize(-1, -1);
        int width = this.convertHorizontalDLUsToPixels(400);
        result.x = Math.max(width, paneSize.x);
        return result;
    }

    @Override
    protected final boolean hasTitleArea() {
        return true;
    }

    @Override
    protected void initializeUI() {
        Image image;
        String description;
        super.initializeUI();
        String descriptionTitle = this.getDescriptionTitle();
        if (descriptionTitle != null) {
            this.setTitle(descriptionTitle);
        }
        if ((description = this.getDescription()) != null) {
            this.setMessage(description);
        }
        if ((image = this.getDescriptionImage()) != null) {
            this.setTitleImage(image);
        }
    }

    protected final void setErrorMessage(String errorMessage, Object ... arguments) {
        this.setErrorMessage(NLS.bind((String)errorMessage, (Object[])arguments));
    }

    private void updateErrorMessage() {
        if (this.getSubject().hasBranchProblems()) {
            Problem problem = (Problem)this.getSubject().branchProblems().next();
            this.setErrorMessage(problem.messageKey(), problem.messageArguments());
        } else {
            this.clearErrorMessage();
        }
    }

    private void validate() {
        this.getSubject().validateBranch();
        this.updateErrorMessage();
        this.getButton(0).setEnabled(!this.getSubject().hasBranchProblems());
    }
}

