/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.MappingFilePersistenceUnitDefaults;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.JarFileRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.core.context.persistence.PersistentTypeContainer;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.core.jpa2.JpaProject2_0;
import org.eclipse.jpt.core.jpa2.context.MappingFilePersistenceUnitDefaults2_0;
import org.eclipse.jpt.core.jpa2.context.MetamodelSourceType;
import org.eclipse.jpt.core.jpa2.context.PersistentType2_0;
import org.eclipse.jpt.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.core.jpa2.context.persistence.options.SharedCacheMode;
import org.eclipse.jpt.core.jpa2.context.persistence.options.ValidationMode;
import org.eclipse.jpt.core.jpa2.resource.java.JavaResourcePersistentType2_0;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlJarFileRef;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.core.resource.persistence.XmlProperty;
import org.eclipse.jpt.core.utility.BodySourceWriter;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.NotNullFilter;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.CompositeListIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistenceUnit
extends AbstractPersistenceXmlContextNode
implements PersistenceUnit2_0 {
    protected XmlPersistenceUnit xmlPersistenceUnit;
    protected String name;
    protected PersistenceUnitTransactionType specifiedTransactionType;
    protected PersistenceUnitTransactionType defaultTransactionType;
    protected String description;
    protected String provider;
    protected String jtaDataSource;
    protected String nonJtaDataSource;
    protected final Vector<MappingFileRef> specifiedMappingFileRefs = new Vector();
    protected MappingFileRef impliedMappingFileRef;
    protected final Vector<JarFileRef> jarFileRefs = new Vector();
    protected final Vector<ClassRef> specifiedClassRefs = new Vector();
    protected final Vector<ClassRef> impliedClassRefs = new Vector();
    protected Boolean specifiedExcludeUnlistedClasses;
    protected final Vector<PersistenceUnit.Property> properties = new Vector();
    protected final Vector<Generator> generators = new Vector();
    protected final Vector<Query> queries = new Vector();
    protected final Set<String> rootEntityNames = Collections.synchronizedSet(new HashSet());
    protected AccessType defaultAccess;
    protected String defaultCatalog;
    protected String defaultSchema;
    protected boolean defaultCascadePersist;
    protected boolean defaultDelimitedIdentifiers;
    private PersistenceUnitProperties connection;
    private PersistenceUnitProperties options;
    protected SharedCacheMode specifiedSharedCacheMode;
    protected SharedCacheMode defaultSharedCacheMode;
    protected ValidationMode specifiedValidationMode;
    protected ValidationMode defaultValidationMode;
    protected final Set<IFile> metamodelFiles = Collections.synchronizedSet(new HashSet());

    protected AbstractPersistenceUnit(Persistence parent, XmlPersistenceUnit xmlPersistenceUnit) {
        super(parent);
        this.xmlPersistenceUnit = xmlPersistenceUnit;
        this.name = xmlPersistenceUnit.getName();
        this.specifiedExcludeUnlistedClasses = xmlPersistenceUnit.getExcludeUnlistedClasses();
        this.specifiedTransactionType = this.buildSpecifiedTransactionType();
        this.defaultTransactionType = this.buildDefaultTransactionType();
        this.description = xmlPersistenceUnit.getDescription();
        this.provider = xmlPersistenceUnit.getProvider();
        this.jtaDataSource = xmlPersistenceUnit.getJtaDataSource();
        this.nonJtaDataSource = xmlPersistenceUnit.getNonJtaDataSource();
        this.specifiedExcludeUnlistedClasses = xmlPersistenceUnit.getExcludeUnlistedClasses();
        this.initializeProperties();
        this.initializeJarFileRefs();
        this.initializeSpecifiedClassRefs();
        this.initializeMappingFileRefs();
        this.initializeImpliedClassRefs();
        this.initializePersistenceUnitDefaults();
        this.specifiedSharedCacheMode = this.buildSpecifiedSharedCacheMode();
        this.defaultSharedCacheMode = this.buildDefaultSharedCacheMode();
        this.specifiedValidationMode = this.buildSpecifiedValidationMode();
        this.defaultValidationMode = this.buildDefaultValidationMode();
        this.initializeMetamodelFiles();
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("generators");
        nonUpdateAspectNames.add("queries");
    }

    @Override
    public void update(XmlPersistenceUnit xpu) {
        this.xmlPersistenceUnit = xpu;
        this.generators.clear();
        this.queries.clear();
        this.rootEntityNames.clear();
        this.setName(xpu.getName());
        this.setSpecifiedTransactionType(this.buildSpecifiedTransactionType());
        this.setDefaultTransactionType(this.buildDefaultTransactionType());
        this.setDescription(xpu.getDescription());
        this.setProvider(xpu.getProvider());
        this.setJtaDataSource(xpu.getJtaDataSource());
        this.setNonJtaDataSource(xpu.getNonJtaDataSource());
        this.updateJarFileRefs();
        this.updateSpecifiedClassRefs();
        this.updateMappingFileRefs();
        this.updateImpliedClassRefs();
        this.setSpecifiedExcludeUnlistedClasses(xpu.getExcludeUnlistedClasses());
        this.updateProperties();
        this.updatePersistenceUnitDefaults();
        this.setSpecifiedSharedCacheMode(this.buildSpecifiedSharedCacheMode());
        this.setDefaultSharedCacheMode(this.buildDefaultSharedCacheMode());
        this.setSpecifiedValidationMode(this.buildSpecifiedValidationMode());
        this.setDefaultValidationMode(this.buildDefaultValidationMode());
        this.fireListChanged("generators", this.generators);
        this.fireListChanged("queries", this.queries);
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        for (ClassRef classRef : this.getSpecifiedClassRefs()) {
            classRef.postUpdate();
        }
        for (ClassRef classRef : this.getImpliedClassRefs()) {
            classRef.postUpdate();
        }
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(this.specifiedMappingFileRefs())) {
            mappingFileRef.postUpdate();
        }
        if (this.impliedMappingFileRef != null) {
            this.impliedMappingFileRef.postUpdate();
        }
    }

    @Override
    public Persistence getParent() {
        return (Persistence)super.getParent();
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return this;
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.persistenceUnit";
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlPersistenceUnit.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        for (ClassRef classRef : this.getClassRefs()) {
            classRef.dispose();
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            mappingFileRef.dispose();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.xmlPersistenceUnit.setName(name);
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return this.specifiedTransactionType != null ? this.specifiedTransactionType : this.defaultTransactionType;
    }

    @Override
    public PersistenceUnitTransactionType getSpecifiedTransactionType() {
        return this.specifiedTransactionType;
    }

    @Override
    public void setSpecifiedTransactionType(PersistenceUnitTransactionType specifiedTransactionType) {
        PersistenceUnitTransactionType old = this.specifiedTransactionType;
        this.specifiedTransactionType = specifiedTransactionType;
        this.xmlPersistenceUnit.setTransactionType(PersistenceUnitTransactionType.toXmlResourceModel(specifiedTransactionType));
        this.firePropertyChanged("specifiedTransactionType", (Object)old, (Object)specifiedTransactionType);
    }

    @Override
    public PersistenceUnitTransactionType getDefaultTransactionType() {
        return this.defaultTransactionType;
    }

    protected void setDefaultTransactionType(PersistenceUnitTransactionType defaultTransactionType) {
        PersistenceUnitTransactionType old = this.defaultTransactionType;
        this.defaultTransactionType = defaultTransactionType;
        this.firePropertyChanged("defaultTransactionType", (Object)old, (Object)defaultTransactionType);
    }

    protected PersistenceUnitTransactionType buildSpecifiedTransactionType() {
        return PersistenceUnitTransactionType.fromXmlResourceModel(this.xmlPersistenceUnit.getTransactionType());
    }

    protected PersistenceUnitTransactionType buildDefaultTransactionType() {
        return PersistenceUnitTransactionType.JTA;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        String old = this.description;
        this.description = description;
        this.xmlPersistenceUnit.setDescription(description);
        this.firePropertyChanged("description", old, description);
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(String provider) {
        String old = this.provider;
        this.provider = provider;
        this.xmlPersistenceUnit.setProvider(provider);
        this.firePropertyChanged("provider", old, provider);
    }

    @Override
    public String getJtaDataSource() {
        return this.jtaDataSource;
    }

    @Override
    public void setJtaDataSource(String jtaDataSource) {
        String old = this.jtaDataSource;
        this.jtaDataSource = jtaDataSource;
        this.xmlPersistenceUnit.setJtaDataSource(jtaDataSource);
        this.firePropertyChanged("jtaDataSource", old, jtaDataSource);
    }

    @Override
    public String getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    @Override
    public void setNonJtaDataSource(String nonJtaDataSource) {
        String old = this.nonJtaDataSource;
        this.nonJtaDataSource = nonJtaDataSource;
        this.xmlPersistenceUnit.setNonJtaDataSource(nonJtaDataSource);
        this.firePropertyChanged("nonJtaDataSource", old, nonJtaDataSource);
    }

    @Override
    public ListIterator<MappingFileRef> mappingFileRefs() {
        return this.getMappingFileRefs().iterator();
    }

    protected ListIterable<MappingFileRef> getMappingFileRefs() {
        return this.impliedMappingFileRef == null ? this.getSpecifiedMappingFileRefs() : this.getCombinedMappingFileRefs();
    }

    protected ListIterator<MappingFileRef> combinedMappingFileRefs() {
        return this.getCombinedMappingFileRefs().iterator();
    }

    protected ListIterable<MappingFileRef> getCombinedMappingFileRefs() {
        return new CompositeListIterable(this.getSpecifiedMappingFileRefs(), (Object)this.impliedMappingFileRef);
    }

    @Override
    public int mappingFileRefsSize() {
        return this.impliedMappingFileRef == null ? this.specifiedMappingFileRefsSize() : this.combinedMappingFileRefsSize();
    }

    protected int combinedMappingFileRefsSize() {
        return this.specifiedMappingFileRefsSize() + 1;
    }

    @Override
    public Iterator<MappingFileRef> mappingFileRefsContaining(final String typeName) {
        return new FilteringIterator<MappingFileRef>(this.mappingFileRefs()){

            protected boolean accept(MappingFileRef mappingFileRef) {
                return mappingFileRef.getPersistentType(typeName) != null;
            }
        };
    }

    protected void initializeMappingFileRefs() {
        for (XmlMappingFileRef xmlMappingFileRef : this.xmlPersistenceUnit.getMappingFiles()) {
            this.specifiedMappingFileRefs.add(this.buildSpecifiedMappingFileRef(xmlMappingFileRef));
        }
        if (!this.impliedMappingFileIsSpecified() && this.impliedMappingFileExists()) {
            this.impliedMappingFileRef = this.buildImpliedMappingFileRef();
        }
    }

    protected void updateMappingFileRefs() {
        CloneIterator xmlFileRefs = new CloneIterator(this.xmlPersistenceUnit.getMappingFiles());
        ListIterator<MappingFileRef> contextFileRefs = this.specifiedMappingFileRefs();
        while (contextFileRefs.hasNext()) {
            MappingFileRef contextFileRef = (MappingFileRef)contextFileRefs.next();
            if (xmlFileRefs.hasNext()) {
                contextFileRef.update((XmlMappingFileRef)xmlFileRefs.next());
                continue;
            }
            this.removeSpecifiedMappingFileRef_(contextFileRef);
        }
        while (xmlFileRefs.hasNext()) {
            this.addSpecifiedMappingFileRef_(this.buildSpecifiedMappingFileRef((XmlMappingFileRef)xmlFileRefs.next()));
        }
        if (this.impliedMappingFileIsSpecified()) {
            if (this.impliedMappingFileRef != null) {
                this.unsetImpliedMappingFileRef();
            }
        } else if (this.impliedMappingFileExists()) {
            if (this.impliedMappingFileRef == null) {
                this.setImpliedMappingFileRef();
            }
            this.impliedMappingFileRef.update(null);
        } else if (this.impliedMappingFileRef != null) {
            this.unsetImpliedMappingFileRef();
        }
    }

    protected MappingFileRef buildSpecifiedMappingFileRef(XmlMappingFileRef xmlMappingFileRef) {
        return this.getContextNodeFactory().buildMappingFileRef(this, xmlMappingFileRef);
    }

    protected boolean impliedMappingFileIsSpecified() {
        String impliedMappingFileName = "META-INF/orm.xml";
        ListIterator<MappingFileRef> stream = this.specifiedMappingFileRefs();
        while (stream.hasNext()) {
            if (!impliedMappingFileName.equals(((MappingFileRef)stream.next()).getFileName())) continue;
            return true;
        }
        return false;
    }

    protected boolean impliedMappingFileExists() {
        return this.getJpaProject().getDefaultOrmXmlResource() != null;
    }

    @Override
    public ListIterator<MappingFileRef> specifiedMappingFileRefs() {
        return this.getSpecifiedMappingFileRefs().iterator();
    }

    protected ListIterable<MappingFileRef> getSpecifiedMappingFileRefs() {
        return new LiveCloneListIterable(this.specifiedMappingFileRefs);
    }

    @Override
    public int specifiedMappingFileRefsSize() {
        return this.specifiedMappingFileRefs.size();
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef() {
        return this.addSpecifiedMappingFileRef(this.specifiedMappingFileRefs.size());
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef(int index) {
        XmlMappingFileRef xmlMappingFileRef = this.buildXmlMappingFileRef();
        MappingFileRef mappingFileRef = this.buildSpecifiedMappingFileRef(xmlMappingFileRef);
        this.specifiedMappingFileRefs.add(index, mappingFileRef);
        this.xmlPersistenceUnit.getMappingFiles().add(index, (Object)xmlMappingFileRef);
        this.fireItemAdded("specifiedMappingFileRefs", index, mappingFileRef);
        return mappingFileRef;
    }

    protected XmlMappingFileRef buildXmlMappingFileRef() {
        return PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
    }

    @Override
    public void removeSpecifiedMappingFileRef(MappingFileRef mappingFileRef) {
        this.removeSpecifiedMappingFileRef(this.specifiedMappingFileRefs.indexOf(mappingFileRef));
    }

    @Override
    public void removeSpecifiedMappingFileRef(int index) {
        MappingFileRef mappingFileRef = this.specifiedMappingFileRefs.remove(index);
        mappingFileRef.dispose();
        this.xmlPersistenceUnit.getMappingFiles().remove(index);
        this.fireItemRemoved("specifiedMappingFileRefs", index, mappingFileRef);
    }

    protected void addSpecifiedMappingFileRef_(MappingFileRef mappingFileRef) {
        this.addItemToList(mappingFileRef, this.specifiedMappingFileRefs, "specifiedMappingFileRefs");
    }

    protected void removeSpecifiedMappingFileRef_(MappingFileRef mappingFileRef) {
        mappingFileRef.dispose();
        this.removeItemFromList(mappingFileRef, this.specifiedMappingFileRefs, "specifiedMappingFileRefs");
    }

    @Override
    public MappingFileRef getImpliedMappingFileRef() {
        return this.impliedMappingFileRef;
    }

    protected MappingFileRef setImpliedMappingFileRef() {
        if (this.impliedMappingFileRef != null) {
            throw new IllegalStateException("The implied mapping file ref is already set.");
        }
        this.impliedMappingFileRef = this.buildImpliedMappingFileRef();
        this.firePropertyChanged("impliedMappingFileRef", null, this.impliedMappingFileRef);
        return this.impliedMappingFileRef;
    }

    protected MappingFileRef buildImpliedMappingFileRef() {
        return this.getContextNodeFactory().buildImpliedMappingFileRef(this);
    }

    protected void unsetImpliedMappingFileRef() {
        if (this.impliedMappingFileRef == null) {
            throw new IllegalStateException("The implied mapping file ref is already unset.");
        }
        MappingFileRef old = this.impliedMappingFileRef;
        this.impliedMappingFileRef.dispose();
        this.impliedMappingFileRef = null;
        this.firePropertyChanged("impliedMappingFileRef", old, null);
    }

    @Override
    public ListIterator<JarFileRef> jarFileRefs() {
        return new CloneListIterator(this.jarFileRefs);
    }

    protected Iterable<JarFileRef> getJarFileRefs() {
        return new LiveCloneIterable(this.jarFileRefs);
    }

    @Override
    public int jarFileRefsSize() {
        return this.jarFileRefs.size();
    }

    @Override
    public JarFileRef addJarFileRef() {
        return this.addJarFileRef(this.jarFileRefs.size());
    }

    @Override
    public JarFileRef addJarFileRef(int index) {
        XmlJarFileRef xmlJarFileRef = this.buildXmlJarFileRef();
        JarFileRef jarFileRef = this.buildJarFileRef(xmlJarFileRef);
        this.jarFileRefs.add(index, jarFileRef);
        this.xmlPersistenceUnit.getJarFiles().add(index, (Object)xmlJarFileRef);
        this.fireItemAdded("jarFileRefs", index, jarFileRef);
        return jarFileRef;
    }

    protected XmlJarFileRef buildXmlJarFileRef() {
        return PersistenceFactory.eINSTANCE.createXmlJarFileRef();
    }

    @Override
    public void removeJarFileRef(JarFileRef jarFileRef) {
        this.removeJarFileRef(this.jarFileRefs.indexOf(jarFileRef));
    }

    @Override
    public void removeJarFileRef(int index) {
        JarFileRef jarFileRef = this.jarFileRefs.remove(index);
        jarFileRef.dispose();
        this.xmlPersistenceUnit.getJarFiles().remove(index);
        this.fireItemRemoved("jarFileRefs", index, jarFileRef);
    }

    protected void addJarFileRef_(JarFileRef jarFileRef) {
        this.addItemToList(jarFileRef, this.jarFileRefs, "jarFileRefs");
    }

    protected void removeJarFileRef_(JarFileRef jarFileRef) {
        jarFileRef.dispose();
        this.removeItemFromList(jarFileRef, this.jarFileRefs, "jarFileRefs");
    }

    protected void initializeJarFileRefs() {
        for (XmlJarFileRef xmlJarFileRef : this.xmlPersistenceUnit.getJarFiles()) {
            this.jarFileRefs.add(this.buildJarFileRef(xmlJarFileRef));
        }
    }

    protected void updateJarFileRefs() {
        CloneIterator xmlFileRefs = new CloneIterator(this.xmlPersistenceUnit.getJarFiles());
        ListIterator<JarFileRef> contextFileRefs = this.jarFileRefs();
        while (contextFileRefs.hasNext()) {
            JarFileRef contextFileRef = (JarFileRef)contextFileRefs.next();
            if (xmlFileRefs.hasNext()) {
                contextFileRef.update((XmlJarFileRef)xmlFileRefs.next());
                continue;
            }
            this.removeJarFileRef_(contextFileRef);
        }
        while (xmlFileRefs.hasNext()) {
            this.addJarFileRef_(this.buildJarFileRef((XmlJarFileRef)xmlFileRefs.next()));
        }
    }

    protected JarFileRef buildJarFileRef(XmlJarFileRef xmlJarFileRef) {
        return this.getContextNodeFactory().buildJarFileRef(this, xmlJarFileRef);
    }

    @Override
    public Iterator<ClassRef> classRefs() {
        return this.getClassRefs().iterator();
    }

    protected Iterable<ClassRef> getClassRefs() {
        return new CompositeIterable(new Iterable[]{this.getSpecifiedClassRefs(), this.getImpliedClassRefs()});
    }

    @Override
    public int classRefsSize() {
        return this.specifiedClassRefs.size() + this.impliedClassRefs.size();
    }

    protected Iterable<PersistentType> getNonNullClassRefPersistentTypes() {
        return new FilteringIterable(this.getClassRefPersistentTypes(), NotNullFilter.instance());
    }

    protected Iterable<PersistentType> getClassRefPersistentTypes() {
        return new TransformationIterable<ClassRef, PersistentType>(this.getClassRefs()){

            protected PersistentType transform(ClassRef classRef) {
                return classRef.getJavaPersistentType();
            }
        };
    }

    @Override
    public ListIterator<ClassRef> specifiedClassRefs() {
        return new CloneListIterator(this.specifiedClassRefs);
    }

    protected Iterable<ClassRef> getSpecifiedClassRefs() {
        return new LiveCloneIterable(this.specifiedClassRefs);
    }

    @Override
    public int specifiedClassRefsSize() {
        return this.specifiedClassRefs.size();
    }

    @Override
    public ClassRef addSpecifiedClassRef() {
        return this.addSpecifiedClassRef(this.specifiedClassRefs.size());
    }

    @Override
    public ClassRef addSpecifiedClassRef(int index) {
        XmlJavaClassRef xmlClassRef = this.buildXmlJavaClassRef();
        ClassRef classRef = this.buildClassRef(xmlClassRef);
        this.specifiedClassRefs.add(index, classRef);
        this.xmlPersistenceUnit.getClasses().add(index, (Object)xmlClassRef);
        this.fireItemAdded("specifiedClassRefs", index, classRef);
        return classRef;
    }

    protected XmlJavaClassRef buildXmlJavaClassRef() {
        return PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
    }

    @Override
    public void removeSpecifiedClassRef(ClassRef classRef) {
        this.removeSpecifiedClassRef(this.specifiedClassRefs.indexOf(classRef));
    }

    @Override
    public void removeSpecifiedClassRef(int index) {
        ClassRef classRef = this.specifiedClassRefs.remove(index);
        classRef.dispose();
        this.xmlPersistenceUnit.getClasses().remove(index);
        this.fireItemRemoved("specifiedClassRefs", index, classRef);
    }

    protected void addSpecifiedClassRef_(int index, ClassRef classRef) {
        this.addItemToList(index, classRef, this.specifiedClassRefs, "specifiedClassRefs");
    }

    protected void removeSpecifiedClassRef_(ClassRef classRef) {
        classRef.dispose();
        this.removeItemFromList(classRef, this.specifiedClassRefs, "specifiedClassRefs");
    }

    private void moveSpecifiedClassRef_(int index, ClassRef classRef) {
        this.moveItemInList(index, this.specifiedClassRefs.indexOf(classRef), this.specifiedClassRefs, "specifiedClassRefs");
    }

    protected void initializeSpecifiedClassRefs() {
        for (XmlJavaClassRef xmlJavaClassRef : this.xmlPersistenceUnit.getClasses()) {
            this.specifiedClassRefs.add(this.buildClassRef(xmlJavaClassRef));
        }
    }

    protected void updateSpecifiedClassRefs() {
        HashBag contextClassRefsToRemove = CollectionTools.bag(this.specifiedClassRefs(), (int)this.specifiedClassRefsSize());
        ArrayList<ClassRef> contextClassRefsToUpdate = new ArrayList<ClassRef>(this.specifiedClassRefsSize());
        int resourceIndex = 0;
        CloneIterator xmlClassRefs = new CloneIterator(this.xmlPersistenceUnit.getClasses());
        while (xmlClassRefs.hasNext()) {
            XmlJavaClassRef resourceClassRef = (XmlJavaClassRef)xmlClassRefs.next();
            boolean match = false;
            Iterator contextClassRefs = contextClassRefsToRemove.iterator();
            while (contextClassRefs.hasNext()) {
                ClassRef contextClassRef = (ClassRef)contextClassRefs.next();
                if (contextClassRef.getResourceClassRef() != resourceClassRef) continue;
                this.moveSpecifiedClassRef_(resourceIndex, contextClassRef);
                contextClassRefs.remove();
                contextClassRefsToUpdate.add(contextClassRef);
                match = true;
                break;
            }
            if (!match) {
                this.addSpecifiedClassRef_(resourceIndex, this.buildClassRef(resourceClassRef));
            }
            ++resourceIndex;
        }
        for (ClassRef contextClassRef : contextClassRefsToRemove) {
            this.removeSpecifiedClassRef_(contextClassRef);
        }
        for (ClassRef contextClassRef : contextClassRefsToUpdate) {
            contextClassRef.update();
        }
    }

    protected ClassRef buildClassRef(XmlJavaClassRef xmlClassRef) {
        return this.getContextNodeFactory().buildClassRef((PersistenceUnit)this, xmlClassRef);
    }

    @Override
    public Iterator<ClassRef> impliedClassRefs() {
        return new CloneIterator(this.impliedClassRefs);
    }

    protected Iterable<ClassRef> getImpliedClassRefs() {
        return new LiveCloneIterable(this.impliedClassRefs);
    }

    @Override
    public int impliedClassRefsSize() {
        return this.impliedClassRefs.size();
    }

    protected ClassRef addImpliedClassRef(String className) {
        ClassRef classRef = this.buildClassRef(className);
        this.addItemToCollection(classRef, this.impliedClassRefs, "impliedClassRefs");
        return classRef;
    }

    protected ClassRef buildClassRef(String className) {
        return this.getContextNodeFactory().buildClassRef((PersistenceUnit)this, className);
    }

    protected void removeImpliedClassRef(ClassRef classRef) {
        classRef.dispose();
        this.removeItemFromCollection(classRef, this.impliedClassRefs, "impliedClassRefs");
    }

    protected void initializeImpliedClassRefs() {
        if (!this.excludesUnlistedClasses()) {
            this.initializeImpliedClassRefs_();
        }
    }

    protected void initializeImpliedClassRefs_() {
        Iterator<String> stream = this.getJpaProject().mappedJavaSourceClassNames();
        while (stream.hasNext()) {
            String typeName = stream.next();
            if (this.specifiesPersistentType(typeName)) continue;
            this.impliedClassRefs.add(this.buildClassRef(typeName));
        }
    }

    protected void updateImpliedClassRefs() {
        if (this.excludesUnlistedClasses()) {
            this.clearImpliedClassRefs_();
        } else {
            this.updateImpliedClassRefs_();
        }
    }

    protected void updateImpliedClassRefs_() {
        HashBag impliedRefsToRemove = CollectionTools.bag(this.impliedClassRefs(), (int)this.impliedClassRefsSize());
        ArrayList<ClassRef> impliedRefsToUpdate = new ArrayList<ClassRef>(this.impliedClassRefsSize());
        Iterator<String> mappedClassNames = this.getJpaProject().mappedJavaSourceClassNames();
        while (mappedClassNames.hasNext()) {
            String mappedClassName = mappedClassNames.next();
            if (this.specifiesPersistentType(mappedClassName)) continue;
            boolean match = false;
            Iterator classRefs = impliedRefsToRemove.iterator();
            while (classRefs.hasNext()) {
                ClassRef classRef = (ClassRef)classRefs.next();
                if (!mappedClassName.equals(classRef.getClassName())) continue;
                classRefs.remove();
                impliedRefsToUpdate.add(classRef);
                match = true;
                break;
            }
            if (match) continue;
            this.addImpliedClassRef(mappedClassName);
        }
        for (ClassRef classRef : impliedRefsToRemove) {
            this.removeImpliedClassRef(classRef);
        }
        for (ClassRef classRef : impliedRefsToUpdate) {
            classRef.update(classRef.getClassName());
        }
    }

    protected void clearImpliedClassRefs_() {
        for (ClassRef classRef : this.getImpliedClassRefs()) {
            this.removeImpliedClassRef(classRef);
        }
    }

    @Override
    public boolean excludesUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses != null ? this.specifiedExcludeUnlistedClasses.booleanValue() : this.getDefaultExcludeUnlistedClasses();
    }

    @Override
    public Boolean getSpecifiedExcludeUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses;
    }

    @Override
    public void setSpecifiedExcludeUnlistedClasses(Boolean specifiedExcludeUnlistedClasses) {
        Boolean old = this.specifiedExcludeUnlistedClasses;
        this.specifiedExcludeUnlistedClasses = specifiedExcludeUnlistedClasses;
        this.xmlPersistenceUnit.setExcludeUnlistedClasses(this.specifiedExcludeUnlistedClasses);
        this.firePropertyChanged("specifiedExcludeUnlistedClasses", old, specifiedExcludeUnlistedClasses);
    }

    @Override
    public boolean getDefaultExcludeUnlistedClasses() {
        return false;
    }

    @Override
    public ListIterator<PersistenceUnit.Property> properties() {
        return new CloneListIterator(this.properties);
    }

    protected Iterable<PersistenceUnit.Property> getProperties() {
        return new LiveCloneIterable(this.properties);
    }

    @Override
    public int propertiesSize() {
        return this.properties.size();
    }

    @Override
    public PersistenceUnit.Property getProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        for (PersistenceUnit.Property property : this.getProperties()) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public Iterator<PersistenceUnit.Property> propertiesWithNamePrefix(final String propertyNamePrefix) {
        if (propertyNamePrefix == null) {
            throw new NullPointerException();
        }
        return new FilteringIterator<PersistenceUnit.Property>(this.properties()){

            protected boolean accept(PersistenceUnit.Property property) {
                String pName = property.getName();
                return pName != null && pName.startsWith(propertyNamePrefix);
            }
        };
    }

    @Override
    public PersistenceUnit.Property addProperty() {
        return this.addProperty(this.properties.size());
    }

    @Override
    public PersistenceUnit.Property addProperty(int index) {
        return this.addProperty(this.buildXmlProperty(), index);
    }

    protected XmlProperty buildXmlProperty() {
        return PersistenceFactory.eINSTANCE.createXmlProperty();
    }

    protected PersistenceUnit.Property addProperty(XmlProperty xmlProperty, int index) {
        PersistenceUnit.Property property = this.buildProperty(xmlProperty);
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        if (xmlProperties == null) {
            xmlProperties = this.buildXmlProperties();
            this.xmlPersistenceUnit.setProperties(xmlProperties);
        }
        this.properties.add(index, property);
        xmlProperties.getProperties().add(index, (Object)xmlProperty);
        this.fireItemAdded("properties", index, property);
        if (property.getName() != null) {
            this.propertyAdded(property.getName(), property.getValue());
        }
        return property;
    }

    protected PersistenceUnit.Property buildProperty(XmlProperty xmlProperty) {
        return this.getContextNodeFactory().buildProperty(this, xmlProperty);
    }

    protected XmlProperties buildXmlProperties() {
        return PersistenceFactory.eINSTANCE.createXmlProperties();
    }

    @Override
    public void setProperty(String propertyName, String value) {
        this.setProperty(propertyName, value, false);
    }

    @Override
    public void setProperty(String propertyName, String value, boolean duplicatePropertyNamesAllowed) {
        PersistenceUnit.Property prev = this.getProperty(propertyName);
        if (prev == null) {
            if (value != null) {
                this.addProperty(propertyName, value);
            }
        } else if (duplicatePropertyNamesAllowed) {
            if (value != null) {
                this.addProperty(propertyName, value);
            }
        } else if (value == null) {
            this.removeProperty(prev);
        } else {
            prev.setValue(value);
        }
    }

    protected void addProperty(String propertyName, String value) {
        PersistenceUnit.Property property = this.addProperty();
        property.setName(propertyName);
        property.setValue(value);
    }

    @Override
    public void removeProperty(PersistenceUnit.Property property) {
        this.removeProperty(this.properties.indexOf(property));
    }

    @Override
    public void removeProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        ListIterator<PersistenceUnit.Property> stream = this.properties.listIterator();
        while (stream.hasNext()) {
            PersistenceUnit.Property property = stream.next();
            if (!propertyName.equals(property.getName())) continue;
            this.removeProperty(stream.previousIndex());
            return;
        }
        throw new IllegalArgumentException("invalid property name: " + propertyName);
    }

    @Override
    public void removeProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new NullPointerException();
        }
        ListIterator<PersistenceUnit.Property> stream = this.properties.listIterator();
        while (stream.hasNext()) {
            PersistenceUnit.Property property = stream.next();
            if (!propertyName.equals(property.getName()) || !value.equals(property.getValue())) continue;
            this.removeProperty(stream.previousIndex());
            return;
        }
        throw new IllegalArgumentException("invalid property name/value pair: " + propertyName + " = " + value);
    }

    protected void removeProperty(int index) {
        PersistenceUnit.Property removedProperty = this.properties.remove(index);
        this.xmlPersistenceUnit.getProperties().getProperties().remove(index);
        if (this.xmlPersistenceUnit.getProperties().getProperties().isEmpty()) {
            this.xmlPersistenceUnit.setProperties(null);
        }
        this.fireItemRemoved("properties", index, removedProperty);
        if (removedProperty.getName() != null) {
            this.propertyRemoved(removedProperty.getName());
        }
    }

    protected void addProperty_(int index, PersistenceUnit.Property property) {
        this.addItemToList(index, property, this.properties, "properties");
        if (property.getName() != null) {
            this.propertyAdded(property.getName(), property.getValue());
        }
    }

    protected void removeProperty_(int index) {
        this.removeProperty_(this.properties.get(index));
    }

    protected void removeProperty_(PersistenceUnit.Property property) {
        this.removeItemFromList(property, this.properties, "properties");
        if (property.getName() != null) {
            this.propertyRemoved(property.getName());
        }
    }

    protected void moveProperty_(int index, PersistenceUnit.Property property) {
        this.moveItemInList(index, this.properties.indexOf(property), this.properties, "properties");
    }

    @Override
    public void propertyNameChanged(String oldPropertyName, String newPropertyName, String value) {
        if (oldPropertyName == null && value == null) {
            return;
        }
        if (oldPropertyName != null) {
            this.propertyRemoved(oldPropertyName);
        }
        if (newPropertyName != null) {
            this.propertyAdded(newPropertyName, value);
        }
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        this.connection.propertyValueChanged(propertyName, newValue);
        this.options.propertyValueChanged(propertyName, newValue);
    }

    public void propertyAdded(String propertyName, String value) {
        this.propertyValueChanged(propertyName, value);
    }

    public void propertyRemoved(String propertyName) {
        this.connection.propertyRemoved(propertyName);
        this.options.propertyRemoved(propertyName);
    }

    protected void initializeProperties() {
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        if (xmlProperties != null) {
            for (XmlProperty xmlProperty : xmlProperties.getProperties()) {
                this.properties.add(this.buildProperty(xmlProperty));
            }
        }
        this.connection = this.getContextNodeFactory().buildConnection(this);
        this.options = this.getContextNodeFactory().buildOptions(this);
    }

    protected void updateProperties() {
        HashBag contextPropertiesToRemove = CollectionTools.bag(this.properties(), (int)this.propertiesSize());
        int resourceIndex = 0;
        Iterator<XmlProperty> xmlProperties = this.xmlProperties();
        while (xmlProperties.hasNext()) {
            XmlProperty xmlProperty = xmlProperties.next();
            boolean match = false;
            Iterator contextProperties = contextPropertiesToRemove.iterator();
            while (contextProperties.hasNext()) {
                PersistenceUnit.Property contextProperty = (PersistenceUnit.Property)contextProperties.next();
                if (contextProperty.getXmlProperty() != xmlProperty) continue;
                contextProperties.remove();
                this.moveProperty_(resourceIndex, contextProperty);
                contextProperty.update();
                match = true;
                break;
            }
            if (!match) {
                this.addProperty_(resourceIndex, this.buildProperty(xmlProperty));
            }
            ++resourceIndex;
        }
        for (PersistenceUnit.Property contextProperty : contextPropertiesToRemove) {
            this.removeProperty_(contextProperty);
        }
    }

    protected Iterator<XmlProperty> xmlProperties() {
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        return xmlProperties != null ? new CloneIterator(xmlProperties.getProperties()) : EmptyIterator.instance();
    }

    protected int xmlPropertiesSize() {
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        return xmlProperties == null ? 0 : xmlProperties.getProperties().size();
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType defaultAccess) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = defaultAccess;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)defaultAccess);
    }

    protected AccessType buildDefaultAccess(MappingFilePersistenceUnitDefaults defaults) {
        return defaults == null ? null : defaults.getAccess();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String defaultCatalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = defaultCatalog;
        this.firePropertyChanged("defaultCatalog", old, defaultCatalog);
    }

    protected String buildDefaultCatalog(MappingFilePersistenceUnitDefaults defaults) {
        String catalog = defaults == null ? null : defaults.getCatalog();
        return catalog != null ? catalog : this.getJpaProject().getDefaultCatalog();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String defaultSchema) {
        String old = this.defaultSchema;
        this.defaultSchema = defaultSchema;
        this.firePropertyChanged("defaultSchema", old, defaultSchema);
    }

    protected String buildDefaultSchema(MappingFilePersistenceUnitDefaults defaults) {
        String schema = defaults == null ? null : defaults.getSchema();
        return schema != null ? schema : this.getJpaProject().getDefaultSchema();
    }

    @Override
    public boolean getDefaultCascadePersist() {
        return this.defaultCascadePersist;
    }

    protected void setDefaultCascadePersist(boolean defaultCascadePersist) {
        boolean old = this.defaultCascadePersist;
        this.defaultCascadePersist = defaultCascadePersist;
        this.firePropertyChanged("defaultCascadePersist", old, defaultCascadePersist);
    }

    protected boolean buildDefaultCascadePersist(MappingFilePersistenceUnitDefaults defaults) {
        return defaults == null ? false : defaults.isCascadePersist();
    }

    @Override
    public boolean getDefaultDelimitedIdentifiers() {
        return this.defaultDelimitedIdentifiers;
    }

    protected void setDefaultDelimitedIdentifiers(boolean defaultDelimitedIdentifiers) {
        boolean old = this.defaultDelimitedIdentifiers;
        this.defaultDelimitedIdentifiers = defaultDelimitedIdentifiers;
        this.firePropertyChanged("defaultDelimitedIdentifiers", old, defaultDelimitedIdentifiers);
    }

    protected boolean buildDefaultDelimitedIdentifiers(MappingFilePersistenceUnitDefaults defaults) {
        return !this.isJpa2_0Compatible() ? false : (defaults == null ? false : ((MappingFilePersistenceUnitDefaults2_0)defaults).isDelimitedIdentifiers());
    }

    protected void initializePersistenceUnitDefaults() {
        MappingFilePersistenceUnitDefaults defaults = this.getDefaults();
        this.defaultAccess = this.buildDefaultAccess(defaults);
        this.defaultCatalog = this.buildDefaultCatalog(defaults);
        this.defaultSchema = this.buildDefaultSchema(defaults);
        this.defaultCascadePersist = this.buildDefaultCascadePersist(defaults);
        this.defaultDelimitedIdentifiers = this.buildDefaultDelimitedIdentifiers(defaults);
    }

    protected void updatePersistenceUnitDefaults() {
        MappingFilePersistenceUnitDefaults defaults = this.getDefaults();
        this.setDefaultAccess(this.buildDefaultAccess(defaults));
        this.setDefaultCatalog(this.buildDefaultCatalog(defaults));
        this.setDefaultSchema(this.buildDefaultSchema(defaults));
        this.setDefaultDelimitedIdentifiers(this.buildDefaultDelimitedIdentifiers(defaults));
    }

    protected MappingFilePersistenceUnitDefaults getDefaults() {
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (!mappingFileRef.persistenceUnitDefaultsExists()) continue;
            return mappingFileRef.getPersistenceUnitDefaults();
        }
        return null;
    }

    @Override
    public PersistenceUnitProperties getConnection() {
        return this.connection;
    }

    @Override
    public PersistenceUnitProperties getOptions() {
        return this.options;
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this.specifiedSharedCacheMode != null ? this.specifiedSharedCacheMode : this.defaultSharedCacheMode;
    }

    @Override
    public SharedCacheMode getSpecifiedSharedCacheMode() {
        return this.specifiedSharedCacheMode;
    }

    @Override
    public void setSpecifiedSharedCacheMode(SharedCacheMode specifiedSharedCacheMode) {
        SharedCacheMode old = this.specifiedSharedCacheMode;
        this.specifiedSharedCacheMode = specifiedSharedCacheMode;
        this.xmlPersistenceUnit.setSharedCacheMode(SharedCacheMode.toXmlResourceModel(specifiedSharedCacheMode));
        this.firePropertyChanged("specifiedSharedCacheMode", (Object)old, (Object)specifiedSharedCacheMode);
    }

    @Override
    public SharedCacheMode getDefaultSharedCacheMode() {
        return this.defaultSharedCacheMode;
    }

    protected void setDefaultSharedCacheMode(SharedCacheMode defaultSharedCacheMode) {
        SharedCacheMode old = this.defaultSharedCacheMode;
        this.defaultSharedCacheMode = defaultSharedCacheMode;
        this.firePropertyChanged("defaultSharedCacheMode", (Object)old, (Object)defaultSharedCacheMode);
    }

    @Override
    public boolean calculateDefaultCacheable() {
        switch (this.getSharedCacheMode()) {
            case NONE: 
            case ENABLE_SELECTIVE: 
            case UNSPECIFIED: {
                return false;
            }
            case ALL: 
            case DISABLE_SELECTIVE: {
                return true;
            }
        }
        return false;
    }

    protected SharedCacheMode buildSpecifiedSharedCacheMode() {
        return SharedCacheMode.fromXmlResourceModel(this.xmlPersistenceUnit.getSharedCacheMode());
    }

    protected SharedCacheMode buildDefaultSharedCacheMode() {
        return SharedCacheMode.UNSPECIFIED;
    }

    @Override
    public ValidationMode getValidationMode() {
        return this.specifiedValidationMode != null ? this.specifiedValidationMode : this.defaultValidationMode;
    }

    @Override
    public ValidationMode getSpecifiedValidationMode() {
        return this.specifiedValidationMode;
    }

    @Override
    public void setSpecifiedValidationMode(ValidationMode specifiedValidationMode) {
        ValidationMode old = this.specifiedValidationMode;
        this.specifiedValidationMode = specifiedValidationMode;
        this.xmlPersistenceUnit.setValidationMode(ValidationMode.toXmlResourceModel(specifiedValidationMode));
        this.firePropertyChanged("specifiedValidationMode", (Object)old, (Object)specifiedValidationMode);
    }

    @Override
    public ValidationMode getDefaultValidationMode() {
        return this.defaultValidationMode;
    }

    protected void setDefaultValidationMode(ValidationMode defaultValidationMode) {
        ValidationMode old = this.defaultValidationMode;
        this.defaultValidationMode = defaultValidationMode;
        this.firePropertyChanged("defaultValidationMode", (Object)old, (Object)defaultValidationMode);
    }

    protected ValidationMode buildSpecifiedValidationMode() {
        return ValidationMode.fromXmlResourceModel(this.xmlPersistenceUnit.getValidationMode());
    }

    protected ValidationMode buildDefaultValidationMode() {
        return DEFAULT_VALIDATION_MODE;
    }

    @Override
    public ListIterator<Generator> generators() {
        return new CloneListIterator(this.generators);
    }

    @Override
    public int generatorsSize() {
        return this.generators.size();
    }

    @Override
    public void addGenerator(Generator generator) {
        this.generators.add(generator);
    }

    @Override
    public String[] uniqueGeneratorNames() {
        HashSet<String> names = new HashSet<String>(this.generators.size());
        this.addNonNullGeneratorNamesTo(names);
        return names.toArray(new String[names.size()]);
    }

    protected void addNonNullGeneratorNamesTo(Set<String> names) {
        ListIterator<Generator> stream = this.generators();
        while (stream.hasNext()) {
            String generatorName = ((Generator)stream.next()).getName();
            if (generatorName == null) continue;
            names.add(generatorName);
        }
    }

    @Override
    public ListIterator<Query> queries() {
        return new CloneListIterator(this.queries);
    }

    @Override
    public int queriesSize() {
        return this.queries.size();
    }

    @Override
    public void addQuery(Query query) {
        this.queries.add(query);
    }

    @Override
    public void addRootEntityWithSubEntities(String entityName) {
        this.rootEntityNames.add(entityName);
    }

    @Override
    public boolean entityIsRootWithSubEntities(String entityName) {
        return this.rootEntityNames.contains(entityName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateMappingFiles(messages, reporter);
        this.validateClassRefs(messages, reporter);
        this.validateJarFileRefs(messages, reporter);
        this.validateProperties(messages, reporter);
    }

    protected void validateMappingFiles(List<IMessage> messages, IReporter reporter) {
        this.checkForMultiplePersistenceUnitDefaults(messages);
        this.checkForDuplicateMappingFiles(messages);
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            mappingFileRef.validate(messages, reporter);
        }
    }

    protected void checkForMultiplePersistenceUnitDefaults(List<IMessage> messages) {
        boolean first = true;
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (!mappingFileRef.persistenceUnitDefaultsExists()) continue;
            if (first) {
                first = false;
                continue;
            }
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "MAPPING_FILE_EXTRANEOUS_PERSISTENCE_UNIT_DEFAULTS", new String[]{mappingFileRef.getFileName()}, mappingFileRef));
        }
    }

    protected void checkForDuplicateMappingFiles(List<IMessage> messages) {
        HashBag fileNames = new HashBag();
        CollectionTools.addAll((Collection)fileNames, this.mappingFileRefNames());
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            String fileName = mappingFileRef.getFileName();
            if (fileNames.count((Object)fileName) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_MAPPING_FILE", new String[]{fileName}, mappingFileRef, mappingFileRef.getValidationTextRange()));
        }
    }

    protected Iterator<String> mappingFileRefNames() {
        return new TransformationIterator<MappingFileRef, String>(this.mappingFileRefs()){

            protected String transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.getFileName();
            }
        };
    }

    protected void validateClassRefs(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateClasses(messages);
        Iterator<ClassRef> stream = this.classRefs();
        while (stream.hasNext()) {
            stream.next().validate(messages, reporter);
        }
    }

    protected void checkForDuplicateClasses(List<IMessage> messages) {
        HashBag classNames = new HashBag();
        CollectionTools.addAll((Collection)classNames, this.classRefNames());
        Iterator<ClassRef> stream = this.classRefs();
        while (stream.hasNext()) {
            ClassRef classRef = stream.next();
            String className = classRef.getClassName();
            if (className == null || classNames.count((Object)className) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_CLASS", new String[]{className}, classRef, classRef.getValidationTextRange()));
        }
    }

    protected Iterator<String> classRefNames() {
        return new TransformationIterator<ClassRef, String>(this.classRefs()){

            protected String transform(ClassRef classRef) {
                return classRef.getClassName();
            }
        };
    }

    protected void validateJarFileRefs(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateJarFileRefs(messages);
        for (JarFileRef each : CollectionTools.iterable(this.jarFileRefs())) {
            each.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateJarFileRefs(List<IMessage> messages) {
        HashBag jarFileNames = new HashBag();
        CollectionTools.addAll((Collection)jarFileNames, this.jarFileNames());
        for (JarFileRef jarFileRef : CollectionTools.iterable(this.jarFileRefs())) {
            String jarFileName = jarFileRef.getFileName();
            if (jarFileName == null || jarFileNames.count((Object)jarFileName) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_JAR_FILE", new String[]{jarFileName}, jarFileRef, jarFileRef.getValidationTextRange()));
        }
    }

    protected Iterator<String> jarFileNames() {
        return new TransformationIterator<JarFileRef, String>(this.jarFileRefs()){

            protected String transform(JarFileRef jarFileRef) {
                return jarFileRef.getFileName();
            }
        };
    }

    protected void validateProperties(List<IMessage> messages, IReporter reporter) {
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        Iterator<JpaStructureNode> stream = this.jarFileRefs();
        while (stream.hasNext()) {
            JarFileRef jarFileRef = (JarFileRef)stream.next();
            if (!jarFileRef.containsOffset(textOffset)) continue;
            return jarFileRef;
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (!mappingFileRef.containsOffset(textOffset)) continue;
            return mappingFileRef;
        }
        stream = this.classRefs();
        while (stream.hasNext()) {
            ClassRef classRef = (ClassRef)stream.next();
            if (!classRef.containsOffset(textOffset)) continue;
            return classRef;
        }
        return this;
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return this.connectionProfileIsActive();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.xmlPersistenceUnit.getValidationTextRange();
    }

    @Override
    public PersistentType getPersistentType(String typeName) {
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            PersistentType persistentType = mappingFileRef.getPersistentType(typeName);
            if (persistentType == null) continue;
            return persistentType;
        }
        Iterator<ClassRef> stream = this.classRefs();
        while (stream.hasNext()) {
            ClassRef classRef = stream.next();
            if (!classRef.isFor(typeName)) continue;
            return classRef.getJavaPersistentType();
        }
        stream = this.jarFileRefs();
        while (stream.hasNext()) {
            PersistentType persistentType = ((JarFileRef)((Object)stream.next())).getPersistentType(typeName);
            if (persistentType == null) continue;
            return persistentType;
        }
        return null;
    }

    @Override
    public boolean specifiesPersistentType(String className) {
        for (ClassRef classRef : this.getSpecifiedClassRefs()) {
            if (!classRef.isFor(className)) continue;
            return true;
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (mappingFileRef.getPersistentType(className) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Entity getEntity(String typeName) {
        PersistentType persistentType = this.getPersistentType(typeName);
        if (persistentType == null) {
            return null;
        }
        TypeMapping typeMapping = persistentType.getMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public Embeddable getEmbeddable(String typeName) {
        PersistentType persistentType = this.getPersistentType(typeName);
        if (persistentType == null) {
            return null;
        }
        TypeMapping typeMapping = persistentType.getMapping();
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlPersistenceUnit != null && this.xmlPersistenceUnit.containsOffset(textOffset);
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    @Override
    public void initializeMetamodel() {
        this.initializeMetamodelFiles();
    }

    protected void initializeMetamodelFiles() {
        CollectionTools.addAll(this.metamodelFiles, this.getGeneratedMetamodelFiles());
    }

    protected Iterable<IFile> getGeneratedMetamodelFiles() {
        return new TransformationIterable<JavaResourcePersistentType2_0, IFile>(this.getGeneratedMetamodelTopLevelTypes()){

            protected IFile transform(JavaResourcePersistentType2_0 jrpt) {
                return jrpt.getFile();
            }
        };
    }

    protected Iterable<JavaResourcePersistentType2_0> getGeneratedMetamodelTopLevelTypes() {
        return ((JpaProject2_0)this.getJpaProject()).getGeneratedMetamodelTopLevelTypes();
    }

    @Override
    public void synchronizeMetamodel() {
        HashMap<String, PersistentType2_0> allPersistentTypes = new HashMap<String, PersistentType2_0>();
        this.addPersistentTypesTo_(this.getJarFileRefs(), allPersistentTypes);
        this.addPersistentTypesTo(this.getNonNullClassRefPersistentTypes(), allPersistentTypes);
        this.addPersistentTypesTo_((Iterable<? extends PersistentTypeContainer>)this.getMappingFileRefs(), allPersistentTypes);
        ArrayList<MetamodelSourceType> topLevelTypes = new ArrayList<MetamodelSourceType>(allPersistentTypes.size());
        HashMap<String, Collection<MetamodelSourceType>> memberTypeTree = new HashMap<String, Collection<MetamodelSourceType>>();
        block0: for (PersistentType2_0 type : allPersistentTypes.values()) {
            String declaringTypeName = type.getDeclaringTypeName();
            MetamodelSourceType memberType = type;
            while (true) {
                IType jdtDeclaringType;
                IType jdtType;
                JavaResourcePersistentType jrpt;
                if (declaringTypeName == null) {
                    topLevelTypes.add(memberType);
                    continue block0;
                }
                ArrayList<PersistentType2_0> memberTypes = (ArrayList<PersistentType2_0>)memberTypeTree.get(declaringTypeName);
                if (memberTypes == null) {
                    memberTypes = new ArrayList<PersistentType2_0>();
                    memberTypeTree.put(declaringTypeName, memberTypes);
                }
                memberTypes.add((PersistentType2_0)memberType);
                String memberTypeName = declaringTypeName;
                memberType = allPersistentTypes.get(memberTypeName);
                if (memberType != null || (memberType = (declaringTypeName = (jrpt = this.getJpaProject().getJavaResourcePersistentType(memberTypeName)) != null ? jrpt.getDeclaringTypeName() : ((jdtType = this.findJdtType(memberTypeName)) != null ? ((jdtDeclaringType = jdtType.getDeclaringType()) == null ? null : jdtDeclaringType.getFullyQualifiedName('.')) : null)) == null ? this.selectSourceType(topLevelTypes, memberTypeName) : this.selectSourceType((Iterable)memberTypeTree.get(declaringTypeName), memberTypeName)) != null) continue block0;
                memberType = this.buildNonPersistentMetamodelSourceType(memberTypeName);
            }
        }
        Collections.sort(topLevelTypes, MetamodelSourceType.COMPARATOR);
        HashSet<String> names = new HashSet<String>(topLevelTypes.size());
        Iterator stream = topLevelTypes.iterator();
        while (stream.hasNext()) {
            MetamodelSourceType topLevelType = (MetamodelSourceType)stream.next();
            if (names.add(topLevelType.getName().toLowerCase())) continue;
            stream.remove();
        }
        HashSet<IFile> deadMetamodelFiles = new HashSet<IFile>(this.metamodelFiles);
        this.metamodelFiles.clear();
        for (MetamodelSourceType topLevelType : topLevelTypes) {
            IFile metamodelFile = topLevelType.getMetamodelFile();
            deadMetamodelFiles.remove(metamodelFile);
            if (!this.fileIsGeneratedMetamodel(metamodelFile)) continue;
            this.metamodelFiles.add(metamodelFile);
        }
        for (IFile deadMetamodelFile : deadMetamodelFiles) {
            this.deleteMetamodelFile(deadMetamodelFile);
        }
        for (MetamodelSourceType topLevelType : topLevelTypes) {
            topLevelType.synchronizeMetamodel(memberTypeTree);
        }
    }

    protected void addPersistentTypesTo_(Iterable<? extends PersistentTypeContainer> ptContainers, HashMap<String, PersistentType2_0> persistentTypeMap) {
        for (PersistentTypeContainer persistentTypeContainer : ptContainers) {
            this.addPersistentTypesTo(persistentTypeContainer.getPersistentTypes(), persistentTypeMap);
        }
    }

    protected void addPersistentTypesTo(Iterable<? extends PersistentType> persistentTypes, HashMap<String, PersistentType2_0> persistentTypeMap) {
        for (PersistentType persistentType : persistentTypes) {
            if (persistentType.getName() == null) continue;
            persistentTypeMap.put(persistentType.getName(), (PersistentType2_0)persistentType);
        }
    }

    protected MetamodelSourceType selectSourceType(Iterable<MetamodelSourceType> types, String typeName) {
        if (types != null) {
            for (MetamodelSourceType type : types) {
                if (!type.getName().equals(typeName)) continue;
                return type;
            }
        }
        return null;
    }

    protected MetamodelSourceType buildNonPersistentMetamodelSourceType(String nonPersistentTypeName) {
        return new NonPersistentMetamodelSourceType(nonPersistentTypeName, this.getJpaProject());
    }

    protected IType findJdtType(String typeName) {
        try {
            return this.getJpaProject().getJavaProject().findType(typeName);
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    protected void deleteMetamodelFile(IFile file) {
        try {
            this.deleteMetamodelFile_(file);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
        }
    }

    protected void deleteMetamodelFile_(IFile file) throws CoreException {
        if (this.fileIsGeneratedMetamodel(file)) {
            file.delete(true, null);
        }
    }

    protected boolean fileIsGeneratedMetamodel(IFile file) {
        return ((JpaProject2_0)this.getJpaProject()).getGeneratedMetamodelTopLevelType(file) != null;
    }

    @Override
    public void disposeMetamodel() {
        this.metamodelFiles.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NonPersistentMetamodelSourceType
    implements MetamodelSourceType {
        protected final String name;
        protected final JpaProject jpaProject;
        protected final MetamodelSourceType.Synchronizer metamodelSynchronizer;

        protected NonPersistentMetamodelSourceType(String name, JpaProject jpaProject) {
            this.name = name;
            this.jpaProject = jpaProject;
            this.metamodelSynchronizer = this.buildMetamodelSynchronizer();
        }

        protected MetamodelSourceType.Synchronizer buildMetamodelSynchronizer() {
            return this.getJpaFactory().buildMetamodelSynchronizer(this);
        }

        protected JpaFactory2_0 getJpaFactory() {
            return (JpaFactory2_0)this.getJpaProject().getJpaPlatform().getJpaFactory();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isManaged() {
            return false;
        }

        @Override
        public PersistentType getSuperPersistentType() {
            return null;
        }

        @Override
        public <T extends PersistentAttribute> ListIterator<T> attributes() {
            return EmptyListIterator.instance();
        }

        @Override
        public IFile getMetamodelFile() {
            return this.metamodelSynchronizer.getFile();
        }

        @Override
        public JpaProject getJpaProject() {
            return this.jpaProject;
        }

        @Override
        public void synchronizeMetamodel(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
            this.metamodelSynchronizer.synchronize(memberTypeTree);
        }

        @Override
        public void printBodySourceOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
            this.metamodelSynchronizer.printBodySourceOn(pw, memberTypeTree);
        }
    }
}

