/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class XMLValidatorPreferencePage
extends AbstractPreferencePage {
    private Combo fIndicateNoGrammar;
    private Button fHonourAllSchemaLocations;
    private Button fUseXinclude;
    private Button fExtendedMarkupValidation;
    private Combo fEmptyElementTag;
    private Combo fEndTagWithAttributes;
    private Combo fInvalidWhitespaceBeforeTagname;
    private Combo fMissingClosingBracket;
    private Combo fMissingClosingQuote;
    private Combo fMissingEndTag;
    private Combo fMissingStartTag;
    private Combo fMissingQuotes;
    private Combo fInvalidNamespaceInPI;
    private Combo fMissingTagName;
    private Combo fInvalidWhitespaceAtStart;
    private Group fMarkupValidationGroup;
    private ControlEnableState fMarkupState;
    private static final String[] SEVERITIES = new String[]{XMLUIMessages.Indicate_no_grammar_specified_severities_error, XMLUIMessages.Indicate_no_grammar_specified_severities_warning, XMLUIMessages.Indicate_no_grammar_specified_severities_ignore};
    private static final String[] MARKUP_SEVERITIES = new String[]{XMLUIMessages.Severity_error, XMLUIMessages.Severity_warning, XMLUIMessages.Severity_ignore};

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.xml.ui.webx0064");
        this.createContentsForValidatingGroup(composite);
        this.createContentsForMarkupValidationGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void createContentsForValidatingGroup(Composite parent) {
        Group validatingGroup = this.createGroup(parent, 2);
        ((GridLayout)validatingGroup.getLayout()).makeColumnsEqualWidth = false;
        validatingGroup.setText(XMLUIMessages.Validating_files);
        if (this.fIndicateNoGrammar == null) {
            this.createLabel((Composite)validatingGroup, XMLUIMessages.Indicate_no_grammar_specified);
            this.fIndicateNoGrammar = this.createCombo((Composite)validatingGroup, SEVERITIES);
        }
        if (this.fUseXinclude == null) {
            this.fUseXinclude = this.createCheckBox((Composite)validatingGroup, XMLUIMessages.Use_XInclude);
            ((GridData)this.fUseXinclude.getLayoutData()).horizontalSpan = 2;
        }
        if (this.fHonourAllSchemaLocations == null) {
            this.fHonourAllSchemaLocations = this.createCheckBox((Composite)validatingGroup, XMLUIMessages.Honour_all_schema_locations);
            ((GridData)this.fHonourAllSchemaLocations.getLayoutData()).horizontalSpan = 2;
        }
    }

    private void handleMarkupSeveritySelection(boolean selection) {
        if (selection) {
            this.fMarkupState.restore();
        } else {
            this.fMarkupState = ControlEnableState.disable((Control)this.fMarkupValidationGroup);
        }
    }

    protected void createContentsForMarkupValidationGroup(Composite parent) {
        if (this.fExtendedMarkupValidation == null) {
            this.fExtendedMarkupValidation = this.createCheckBox(parent, XMLUIMessages.MarkupValidation_files);
            ((GridData)this.fExtendedMarkupValidation.getLayoutData()).horizontalSpan = 2;
            this.fExtendedMarkupValidation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    XMLValidatorPreferencePage.this.handleMarkupSeveritySelection(XMLValidatorPreferencePage.this.fExtendedMarkupValidation.getSelection());
                }
            });
        }
        this.fMarkupValidationGroup = this.createGroup(parent, 3);
        ((GridLayout)this.fMarkupValidationGroup.getLayout()).makeColumnsEqualWidth = false;
        this.fMarkupValidationGroup.setText(XMLUIMessages.MarkupValidation_files_label);
        if (this.fMissingStartTag == null) {
            this.fMissingStartTag = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.Missing_start_tag, MARKUP_SEVERITIES);
        }
        if (this.fMissingEndTag == null) {
            this.fMissingEndTag = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.Missing_end_tag, MARKUP_SEVERITIES);
        }
        if (this.fMissingTagName == null) {
            this.fMissingTagName = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.Tag_name_missing, MARKUP_SEVERITIES);
        }
        if (this.fMissingQuotes == null) {
            this.fMissingQuotes = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.Missing_quotes, MARKUP_SEVERITIES);
        }
        if (this.fMissingClosingBracket == null) {
            this.fMissingClosingBracket = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.Missing_closing_bracket, MARKUP_SEVERITIES);
        }
        if (this.fMissingClosingQuote == null) {
            this.fMissingClosingQuote = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.Missing_closing_quote, MARKUP_SEVERITIES);
        }
        if (this.fEmptyElementTag == null) {
            this.fEmptyElementTag = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.Empty_element_tag, MARKUP_SEVERITIES);
        }
        if (this.fEndTagWithAttributes == null) {
            this.fEndTagWithAttributes = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.End_tag_with_attributes, MARKUP_SEVERITIES);
        }
        if (this.fInvalidWhitespaceBeforeTagname == null) {
            this.fInvalidWhitespaceBeforeTagname = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.Invalid_whitespace_before_tagname, MARKUP_SEVERITIES);
        }
        if (this.fInvalidNamespaceInPI == null) {
            this.fInvalidNamespaceInPI = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.Namespace_in_pi_target, MARKUP_SEVERITIES);
        }
        if (this.fInvalidWhitespaceAtStart == null) {
            this.fInvalidWhitespaceAtStart = this.createMarkupCombo((Composite)this.fMarkupValidationGroup, XMLUIMessages.Whitespace_at_start, MARKUP_SEVERITIES);
        }
    }

    private Combo createCombo(Composite parent, String[] items) {
        Combo combo = new Combo(parent, 12);
        combo.setItems(items);
        GridData data = new GridData(4, 0x1000000, true, true);
        combo.setLayoutData((Object)data);
        return combo;
    }

    private Combo createMarkupCombo(Composite parent, String text, String[] items) {
        Label label = new Label(parent, 16384);
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        label.setFont(JFaceResources.getDialogFont());
        label.setText(text);
        label.setLayoutData((Object)gd);
        Combo combo = new Combo(parent, 12);
        combo.setItems(items);
        combo.setLayoutData((Object)new GridData(256));
        return combo;
    }

    protected void initializeValues() {
        this.initializeValuesForValidatingGroup();
        this.initializeValuesForMarkupValidationGroup();
    }

    protected void initializeValuesForValidatingGroup() {
        Preferences modelPreferences = this.getModelPreferences();
        int indicateNoGrammarButtonSelected = modelPreferences.getInt("indicateNoGrammar");
        boolean useXIncludeButtonSelected = modelPreferences.getBoolean("xinclude");
        if (this.fIndicateNoGrammar != null) {
            this.fIndicateNoGrammar.select(2 - indicateNoGrammarButtonSelected);
            this.fIndicateNoGrammar.setText(SEVERITIES[2 - indicateNoGrammarButtonSelected]);
        }
        if (this.fUseXinclude != null) {
            this.fUseXinclude.setSelection(useXIncludeButtonSelected);
        }
        boolean honourAllSelected = modelPreferences.getBoolean("honourAllSchemaLocations");
        if (this.fHonourAllSchemaLocations != null) {
            this.fHonourAllSchemaLocations.setSelection(honourAllSelected);
        }
    }

    protected void initializeValuesForMarkupValidationGroup() {
        Preferences modelPreferences = this.getModelPreferences();
        boolean useExtendedMarkupValidation = modelPreferences.getBoolean("markupValidation");
        if (this.fExtendedMarkupValidation != null) {
            this.fExtendedMarkupValidation.setSelection(useExtendedMarkupValidation);
        }
        int emptyElementTag = modelPreferences.getInt("attributeHasNoValue");
        if (this.fEmptyElementTag != null) {
            this.fEmptyElementTag.select(2 - emptyElementTag);
            this.fEmptyElementTag.setText(MARKUP_SEVERITIES[2 - emptyElementTag]);
        }
        int endTagWithAttributes = modelPreferences.getInt("endTagWithAttributes");
        if (this.fEndTagWithAttributes != null) {
            this.fEndTagWithAttributes.select(2 - endTagWithAttributes);
            this.fEndTagWithAttributes.setText(MARKUP_SEVERITIES[2 - endTagWithAttributes]);
        }
        int invalidWhitespaceBeforeTagname = modelPreferences.getInt("whitespaceBeforeTagName");
        if (this.fInvalidWhitespaceBeforeTagname != null) {
            this.fInvalidWhitespaceBeforeTagname.select(2 - invalidWhitespaceBeforeTagname);
            this.fInvalidWhitespaceBeforeTagname.setText(MARKUP_SEVERITIES[2 - invalidWhitespaceBeforeTagname]);
        }
        int missingClosingBracket = modelPreferences.getInt("missingClosingBracket");
        if (this.fMissingClosingBracket != null) {
            this.fMissingClosingBracket.select(2 - missingClosingBracket);
            this.fMissingClosingBracket.setText(MARKUP_SEVERITIES[2 - missingClosingBracket]);
        }
        int missingClosingQuote = modelPreferences.getInt("missingClosingQuote");
        if (this.fMissingClosingQuote != null) {
            this.fMissingClosingQuote.select(2 - missingClosingQuote);
            this.fMissingClosingQuote.setText(MARKUP_SEVERITIES[2 - missingClosingQuote]);
        }
        int missingEndTag = modelPreferences.getInt("missingEndTag");
        if (this.fMissingEndTag != null) {
            this.fMissingEndTag.select(2 - missingEndTag);
            this.fMissingEndTag.setText(MARKUP_SEVERITIES[2 - missingEndTag]);
        }
        int missingStartTag = modelPreferences.getInt("missingStartTag");
        if (this.fMissingStartTag != null) {
            this.fMissingStartTag.select(2 - missingStartTag);
            this.fMissingStartTag.setText(MARKUP_SEVERITIES[2 - missingStartTag]);
        }
        int missingQuotes = modelPreferences.getInt("missingQuotes");
        if (this.fMissingQuotes != null) {
            this.fMissingQuotes.select(2 - missingQuotes);
            this.fMissingQuotes.setText(MARKUP_SEVERITIES[2 - missingQuotes]);
        }
        int invalidNamespaceInPI = modelPreferences.getInt("namespaceInPITarget");
        if (this.fInvalidNamespaceInPI != null) {
            this.fInvalidNamespaceInPI.select(2 - invalidNamespaceInPI);
            this.fInvalidNamespaceInPI.setText(MARKUP_SEVERITIES[2 - invalidNamespaceInPI]);
        }
        int tagNameMissing = modelPreferences.getInt("missingTagName");
        if (this.fMissingTagName != null) {
            this.fMissingTagName.select(2 - tagNameMissing);
            this.fMissingTagName.setText(MARKUP_SEVERITIES[2 - tagNameMissing]);
        }
        int invalidWhitespaceAtStart = modelPreferences.getInt("whitespaceAtStart");
        if (this.fInvalidWhitespaceAtStart != null) {
            this.fInvalidWhitespaceAtStart.select(2 - invalidWhitespaceAtStart);
            this.fInvalidWhitespaceAtStart.setText(MARKUP_SEVERITIES[2 - invalidWhitespaceAtStart]);
        }
        if (!useExtendedMarkupValidation) {
            this.fMarkupState = ControlEnableState.disable((Control)this.fMarkupValidationGroup);
        }
    }

    protected void performDefaultsForValidatingGroup() {
        Preferences modelPreferences = this.getModelPreferences();
        int indicateNoGrammarButtonSelected = modelPreferences.getDefaultInt("indicateNoGrammar");
        boolean useXIncludeButtonSelected = modelPreferences.getDefaultBoolean("xinclude");
        if (this.fIndicateNoGrammar != null) {
            this.fIndicateNoGrammar.setSelection(new Point(indicateNoGrammarButtonSelected, 2 - indicateNoGrammarButtonSelected));
            this.fIndicateNoGrammar.setText(SEVERITIES[indicateNoGrammarButtonSelected]);
        }
        if (this.fUseXinclude != null) {
            this.fUseXinclude.setSelection(useXIncludeButtonSelected);
        }
        boolean honourAllButtonSelected = modelPreferences.getDefaultBoolean("honourAllSchemaLocations");
        if (this.fHonourAllSchemaLocations != null) {
            this.fHonourAllSchemaLocations.setSelection(honourAllButtonSelected);
        }
    }

    protected void performDefaultsForMarkupValidationGroup() {
        Preferences modelPreferences = this.getModelPreferences();
        boolean useExtendedMarkupValidation = modelPreferences.getDefaultBoolean("markupValidation");
        if (this.fExtendedMarkupValidation != null) {
            if (this.fExtendedMarkupValidation.getSelection() != useExtendedMarkupValidation) {
                this.handleMarkupSeveritySelection(useExtendedMarkupValidation);
            }
            this.fExtendedMarkupValidation.setSelection(useExtendedMarkupValidation);
        }
        int emptyElementTag = modelPreferences.getDefaultInt("attributeHasNoValue");
        if (this.fEmptyElementTag != null) {
            this.fEmptyElementTag.setSelection(new Point(emptyElementTag, 2 - emptyElementTag));
            this.fEmptyElementTag.setText(MARKUP_SEVERITIES[2 - emptyElementTag]);
        }
        int endTagWithAttributes = modelPreferences.getDefaultInt("endTagWithAttributes");
        if (this.fEndTagWithAttributes != null) {
            this.fEndTagWithAttributes.setSelection(new Point(endTagWithAttributes, 2 - endTagWithAttributes));
            this.fEndTagWithAttributes.setText(MARKUP_SEVERITIES[2 - endTagWithAttributes]);
        }
        int invalidWhitespaceBeforeTagname = modelPreferences.getDefaultInt("whitespaceBeforeTagName");
        if (this.fInvalidWhitespaceBeforeTagname != null) {
            this.fInvalidWhitespaceBeforeTagname.setSelection(new Point(invalidWhitespaceBeforeTagname, 2 - invalidWhitespaceBeforeTagname));
            this.fInvalidWhitespaceBeforeTagname.setText(MARKUP_SEVERITIES[2 - invalidWhitespaceBeforeTagname]);
        }
        int missingClosingBracket = modelPreferences.getDefaultInt("missingClosingBracket");
        if (this.fMissingClosingBracket != null) {
            this.fMissingClosingBracket.setSelection(new Point(missingClosingBracket, 2 - missingClosingBracket));
            this.fMissingClosingBracket.setText(MARKUP_SEVERITIES[2 - missingClosingBracket]);
        }
        int missingClosingQuote = modelPreferences.getDefaultInt("missingClosingQuote");
        if (this.fMissingClosingQuote != null) {
            this.fMissingClosingQuote.setSelection(new Point(missingClosingQuote, 2 - missingClosingQuote));
            this.fMissingClosingQuote.setText(MARKUP_SEVERITIES[2 - missingClosingQuote]);
        }
        int missingEndTag = modelPreferences.getDefaultInt("missingEndTag");
        if (this.fMissingEndTag != null) {
            this.fMissingEndTag.setSelection(new Point(missingEndTag, 2 - missingEndTag));
            this.fMissingEndTag.setText(MARKUP_SEVERITIES[2 - missingEndTag]);
        }
        int missingStartTag = modelPreferences.getDefaultInt("missingStartTag");
        if (this.fMissingStartTag != null) {
            this.fMissingStartTag.setSelection(new Point(missingStartTag, 2 - missingStartTag));
            this.fMissingStartTag.setText(MARKUP_SEVERITIES[2 - missingStartTag]);
        }
        int missingQuotes = modelPreferences.getDefaultInt("missingQuotes");
        if (this.fMissingQuotes != null) {
            this.fMissingQuotes.setSelection(new Point(missingQuotes, 2 - missingQuotes));
            this.fMissingQuotes.setText(MARKUP_SEVERITIES[2 - missingQuotes]);
        }
        int invalidNamespaceInPI = modelPreferences.getDefaultInt("namespaceInPITarget");
        if (this.fInvalidNamespaceInPI != null) {
            this.fInvalidNamespaceInPI.setSelection(new Point(invalidNamespaceInPI, 2 - invalidNamespaceInPI));
            this.fInvalidNamespaceInPI.setText(MARKUP_SEVERITIES[2 - invalidNamespaceInPI]);
        }
        int tagNameMissing = modelPreferences.getDefaultInt("missingTagName");
        if (this.fMissingTagName != null) {
            this.fMissingTagName.setSelection(new Point(tagNameMissing, 2 - tagNameMissing));
            this.fMissingTagName.setText(MARKUP_SEVERITIES[2 - tagNameMissing]);
        }
        int invalidWhitespaceAtStart = modelPreferences.getDefaultInt("whitespaceAtStart");
        if (this.fInvalidWhitespaceAtStart != null) {
            this.fInvalidWhitespaceAtStart.setSelection(new Point(invalidWhitespaceAtStart, 2 - invalidWhitespaceAtStart));
            this.fInvalidWhitespaceAtStart.setText(MARKUP_SEVERITIES[2 - invalidWhitespaceAtStart]);
        }
    }

    protected void storeValuesForValidatingGroup() {
        Preferences modelPreferences = this.getModelPreferences();
        if (this.fIndicateNoGrammar != null) {
            int warnNoGrammarButtonSelected = 2 - this.fIndicateNoGrammar.getSelectionIndex();
            modelPreferences.setValue("indicateNoGrammar", warnNoGrammarButtonSelected);
        }
        if (this.fUseXinclude != null) {
            boolean useXIncludeButtonSelected = this.fUseXinclude.getSelection();
            modelPreferences.setValue("xinclude", useXIncludeButtonSelected);
        }
        if (this.fHonourAllSchemaLocations != null) {
            boolean honourAllButtonSelected = this.fHonourAllSchemaLocations.getSelection();
            modelPreferences.setValue("honourAllSchemaLocations", honourAllButtonSelected);
        }
    }

    protected void storeValuesForMarkupValidationGroup() {
        Preferences modelPreferences = this.getModelPreferences();
        if (this.fExtendedMarkupValidation != null) {
            boolean extendedMarkupValidation = this.fExtendedMarkupValidation.getSelection();
            modelPreferences.setValue("markupValidation", extendedMarkupValidation);
        }
        if (this.fEmptyElementTag != null) {
            int emptyElementTag = 2 - this.fEmptyElementTag.getSelectionIndex();
            modelPreferences.setValue("attributeHasNoValue", emptyElementTag);
        }
        if (this.fEndTagWithAttributes != null) {
            int endTagWithAttributes = 2 - this.fEndTagWithAttributes.getSelectionIndex();
            modelPreferences.setValue("endTagWithAttributes", endTagWithAttributes);
        }
        if (this.fInvalidWhitespaceBeforeTagname != null) {
            int invalidWhitespaceBeforeTagname = 2 - this.fInvalidWhitespaceBeforeTagname.getSelectionIndex();
            modelPreferences.setValue("whitespaceBeforeTagName", invalidWhitespaceBeforeTagname);
        }
        if (this.fMissingClosingBracket != null) {
            int missingClosingBracket = 2 - this.fMissingClosingBracket.getSelectionIndex();
            modelPreferences.setValue("missingClosingBracket", missingClosingBracket);
        }
        if (this.fMissingClosingQuote != null) {
            int missingClosingQuote = 2 - this.fMissingClosingQuote.getSelectionIndex();
            modelPreferences.setValue("missingClosingBracket", missingClosingQuote);
        }
        if (this.fMissingEndTag != null) {
            int missingEndTag = 2 - this.fMissingEndTag.getSelectionIndex();
            modelPreferences.setValue("missingEndTag", missingEndTag);
            modelPreferences.getInt("missingEndTag");
        }
        if (this.fMissingStartTag != null) {
            int missingStartTag = 2 - this.fMissingStartTag.getSelectionIndex();
            modelPreferences.setValue("missingStartTag", missingStartTag);
        }
        if (this.fMissingQuotes != null) {
            int missingQuotes = 2 - this.fMissingQuotes.getSelectionIndex();
            modelPreferences.setValue("missingQuotes", missingQuotes);
        }
        if (this.fInvalidNamespaceInPI != null) {
            int invalidNamespaceInPI = 2 - this.fInvalidNamespaceInPI.getSelectionIndex();
            modelPreferences.setValue("namespaceInPITarget", invalidNamespaceInPI);
        }
        if (this.fMissingTagName != null) {
            int missingTagName = 2 - this.fMissingTagName.getSelectionIndex();
            modelPreferences.setValue("missingTagName", missingTagName);
        }
        if (this.fInvalidWhitespaceAtStart != null) {
            int invalidWhitespaceAtStart = 2 - this.fInvalidWhitespaceAtStart.getSelectionIndex();
            modelPreferences.setValue("whitespaceAtStart", invalidWhitespaceAtStart);
        }
    }

    protected void storeValues() {
        this.storeValuesForValidatingGroup();
        this.storeValuesForMarkupValidationGroup();
    }

    protected void performDefaults() {
        this.performDefaultsForValidatingGroup();
        this.performDefaultsForMarkupValidationGroup();
        super.performDefaults();
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void doSavePreferenceStore() {
        XMLCorePlugin.getDefault().savePluginPreferences();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }
}

