/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.operations;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CompatibilityDescriptionGroup;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.refactor.operations.OptionalRefactorHandler;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorOperation;
import org.eclipse.jst.j2ee.refactor.operations.UpdateDependentEARonRenameProvider;
import org.eclipse.jst.j2ee.refactor.operations.UpdateDependentModuleonRenameProvider;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public class ProjectRenameOperation
extends ProjectRefactorOperation {
    public ProjectRenameOperation(IDataModel model) {
        super(model);
    }

    protected ProjectRefactorMetadata getProjectMetadata() {
        return (ProjectRefactorMetadata)this.model.getProperty("ProjectRefactoringProperties.ORIGINAL_PROJECT_METADATA");
    }

    protected void updateProject(ProjectRefactorMetadata originalMetadata) throws ExecutionException {
        ProjectRefactorMetadata refactoredMetadata = super.getProjectMetadata();
        final String oldProjectName = originalMetadata.getProjectName();
        final String newProjectName = refactoredMetadata.getProjectName();
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newProjectName);
        String originalContextRoot = ComponentUtilities.getServerContextRoot((IProject)newProject);
        if (oldProjectName.equals(originalContextRoot)) {
            ComponentUtilities.setServerContextRoot((IProject)newProject, (String)newProjectName);
        }
        StructureEdit core = null;
        WorkbenchComponent component = null;
        try {
            core = StructureEdit.getStructureEditForWrite((IProject)refactoredMetadata.getProject());
            if (core != null) {
                component = core.getComponent();
            }
            if (component != null && component.getName().equals(originalMetadata.getProjectName())) {
                component.setName(refactoredMetadata.getProjectName());
            }
            if (component != null) {
                EList properties = component.getProperties();
                for (Property property : properties) {
                    if (!property.getName().equals("java-output-path")) continue;
                    Path javaOutputPath = new Path(property.getValue());
                    IPath oldProjectNamePath = new Path(oldProjectName).makeAbsolute();
                    if (!oldProjectNamePath.isPrefixOf((IPath)javaOutputPath)) continue;
                    IPath newJavaOutputPath = new Path(newProjectName).append(javaOutputPath.removeFirstSegments(1)).makeAbsolute();
                    property.setValue(newJavaOutputPath.toString());
                }
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
        IProject refactoredProject = refactoredMetadata.getProject();
        String pType = JavaEEProjectUtilities.getJ2EEProjectType(refactoredProject);
        if ("jst.utility".equals(pType) || "".equals(pType)) {
            return;
        }
        final IModelProvider model = ModelProviderManager.getModelProvider(refactoredProject);
        if (model != null) {
            model.modify(new Runnable(){

                public void run() {
                    Object modelObject = model.getModelObject();
                    if (modelObject instanceof CompatibilityDescriptionGroup) {
                        CompatibilityDescriptionGroup cdg = (CompatibilityDescriptionGroup)modelObject;
                        if (cdg.getDisplayName() != null && cdg.getDisplayName().equals(oldProjectName)) {
                            cdg.setDisplayName(newProjectName);
                        }
                    } else {
                        DisplayName oldDN;
                        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
                        dn.setValue(newProjectName);
                        List displayNames = null;
                        if (modelObject instanceof Application) {
                            displayNames = ((Application)modelObject).getDisplayNames();
                        } else if (modelObject instanceof WebApp) {
                            displayNames = ((WebApp)modelObject).getDisplayNames();
                        } else if (modelObject instanceof ApplicationClient) {
                            displayNames = ((ApplicationClient)modelObject).getDisplayNames();
                        } else if (modelObject instanceof EJBJar) {
                            displayNames = ((EJBJar)modelObject).getDisplayNames();
                        }
                        if (displayNames != null && !displayNames.isEmpty() && (oldDN = (DisplayName)displayNames.get(0)).getValue().equals(oldProjectName)) {
                            displayNames.set(0, dn);
                        }
                    }
                }
            }, null);
        }
    }

    protected void updateDependentProjects(ProjectRefactorMetadata originalMetadata, IProgressMonitor monitor) throws ExecutionException {
        if (!originalMetadata.isEAR()) {
            super.updateDependentProjects(originalMetadata, monitor);
        }
        ProjectRefactorMetadata refactoredMetadata = super.getProjectMetadata();
        ProjectModuleFactoryDelegate.handleGlobalProjectChange((IProject)refactoredMetadata.getProject(), (IResourceDelta)((IResourceDelta)this.model.getProperty("ProjectRefactoringProperties.RESOURCE_DELTA")));
        super.updateServerRefs(originalMetadata, refactoredMetadata);
    }

    protected void updateDependentEARProject(ProjectRefactorMetadata dependentMetadata, ProjectRefactorMetadata originalMetadata) throws ExecutionException {
        if (OptionalRefactorHandler.getInstance().shouldRefactorDependentProjectOnRename(originalMetadata, dependentMetadata)) {
            IDataModel dataModel = this.createDataModel(dependentMetadata, originalMetadata, new UpdateDependentEARonRenameProvider());
            dataModel.getDefaultOperation().execute(null, null);
        }
    }

    protected void updateDependentModuleProject(ProjectRefactorMetadata dependentMetadata, ProjectRefactorMetadata originalMetadata) throws ExecutionException {
        if (OptionalRefactorHandler.getInstance().shouldRefactorDependentProjectOnRename(originalMetadata, dependentMetadata)) {
            IDataModel dataModel = this.createDataModel(dependentMetadata, originalMetadata, new UpdateDependentModuleonRenameProvider());
            dataModel.getDefaultOperation().execute(null, null);
        }
    }

    private IDataModel createDataModel(ProjectRefactorMetadata dependentMetadata, ProjectRefactorMetadata originalMetadata, AbstractDataModelProvider provider) {
        ProjectRefactorMetadata refactoredMetadata = super.getProjectMetadata();
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)provider);
        dataModel.setProperty("ProjectRefactoringProperties.PROJECT_METADATA", (Object)refactoredMetadata);
        dataModel.setProperty("ProjectRefactoringProperties.DEPENDENT_PROJECT_METADATA", (Object)dependentMetadata);
        dataModel.setProperty("ProjectRefactoringProperties.ORIGINAL_PROJECT_METADATA", (Object)originalMetadata);
        return dataModel;
    }
}

