/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.InheritanceType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceInheritanceAnnotation
extends SourceAnnotation<Type>
implements InheritanceAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Inheritance");
    private static final DeclarationAnnotationElementAdapter<String> STRATEGY_ADAPTER = SourceInheritanceAnnotation.buildStrategyAdapter();
    private final AnnotationElementAdapter<String> strategyAdapter;
    private InheritanceType strategy;

    public SourceInheritanceAnnotation(JavaResourcePersistentType parent, Type type) {
        super(parent, type, DECLARATION_ANNOTATION_ADAPTER);
        this.strategyAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)type, STRATEGY_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Inheritance";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.strategy = this.buildStrategy(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncStrategy(this.buildStrategy(astRoot));
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.strategy == null;
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.strategy);
    }

    @Override
    public InheritanceType getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(InheritanceType strategy) {
        if (this.attributeValueHasChanged((Object)this.strategy, (Object)strategy)) {
            this.strategy = strategy;
            this.strategyAdapter.setValue((Object)InheritanceType.toJavaAnnotationValue(strategy));
        }
    }

    private void syncStrategy(InheritanceType astStrategy) {
        InheritanceType old = this.strategy;
        this.strategy = astStrategy;
        this.firePropertyChanged("strategy", (Object)old, (Object)astStrategy);
    }

    private InheritanceType buildStrategy(CompilationUnit astRoot) {
        return InheritanceType.fromJavaAnnotationValue(this.strategyAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getStrategyTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(STRATEGY_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildStrategyAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "strategy");
    }
}

