/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.resource.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DiscriminatorType implements Enumerator
{
    STRING(0, "STRING", "STRING"),
    CHAR(1, "CHAR", "CHAR"),
    INTEGER(2, "INTEGER", "INTEGER");

    public static final int STRING_VALUE = 0;
    public static final int CHAR_VALUE = 1;
    public static final int INTEGER_VALUE = 2;
    private static final DiscriminatorType[] VALUES_ARRAY;
    public static final List<DiscriminatorType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DiscriminatorType[]{STRING, CHAR, INTEGER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DiscriminatorType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DiscriminatorType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DiscriminatorType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DiscriminatorType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DiscriminatorType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return CHAR;
            }
            case 2: {
                return INTEGER;
            }
        }
        return null;
    }

    private DiscriminatorType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

