/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.Map;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableQueryHintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceQueryHintAnnotation
extends SourceAnnotation<Type>
implements NestableQueryHintAnnotation {
    private DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.buildNameDeclarationAdapter();
    private AnnotationElementAdapter<String> nameAdapter = this.buildNameAdapter();
    private String name;
    private DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter = this.buildValueDeclarationAdapter();
    private AnnotationElementAdapter<String> valueAdapter = this.buildValueAdapter();
    private String value;

    public SourceQueryHintAnnotation(JavaResourceNode parent, Type type, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, type, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter((AnnotatedElement)type, idaa));
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.QueryHint";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.value = this.buildValue(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncValue(this.buildValue(astRoot));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"name");
    }

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildStringElementAdapter(this.nameDeclarationAdapter);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildValueDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"value");
    }

    private AnnotationElementAdapter<String> buildValueAdapter() {
        return this.buildStringElementAdapter(this.valueDeclarationAdapter);
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.value == null;
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.valueDeclarationAdapter = this.buildValueDeclarationAdapter();
        this.valueAdapter = this.buildValueAdapter();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        map.put("name", this.name);
        this.name = null;
        map.put("value", this.value);
        this.value = null;
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        this.setName((String)map.get("name"));
        this.setValue((String)map.get("value"));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    static SourceQueryHintAnnotation createNamedQueryQueryHint(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter namedQueryAdapter, int index) {
        return new SourceQueryHintAnnotation(parent, type, SourceQueryHintAnnotation.buildNamedQueryQueryHintAnnotationAdapter(namedQueryAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedQueryQueryHintAnnotationAdapter(DeclarationAnnotationAdapter namedQueryAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedQueryAdapter, "hints", index, "javax.persistence.QueryHint");
    }

    static SourceQueryHintAnnotation createNamedNativeQueryQueryHint(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter namedNativeQueryAdapter, int index) {
        return new SourceQueryHintAnnotation(parent, type, SourceQueryHintAnnotation.buildNamedNativeQueryQueryHintAnnotationAdapter(namedNativeQueryAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedNativeQueryQueryHintAnnotationAdapter(DeclarationAnnotationAdapter namedNativeQueryAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedNativeQueryAdapter, "hints", index, "javax.persistence.QueryHint");
    }
}

