/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.ActionConfig;
import org.eclipse.wst.common.project.facet.core.util.EventListenerRegistry;
import org.eclipse.wst.common.project.facet.core.util.IEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFacetInstallConfig
extends ActionConfig {
    private static final String PROD_PROP_OUTPUT_FOLDER = "defaultJavaOutputFolder";
    private static final String PROD_PROP_OUTPUT_FOLDER_LEGACY = "outputFolder";
    private static final String DEFAULT_OUTPUT_FOLDER = "build/classes";
    private boolean caseSensitiveFs = EFS.getLocalFileSystem().isCaseSensitive();
    private EventListenerRegistry<ChangeEvent.Type, ChangeEvent> listeners = new EventListenerRegistry(ChangeEvent.Type.class);
    private List<IPath> sourceFolders = new CopyOnWriteArrayList<IPath>();
    private List<IPath> sourceFoldersReadOnly = Collections.unmodifiableList(this.sourceFolders);
    private IPath defaultOutputFolder = null;

    public JavaFacetInstallConfig() {
        String sourceFolder = FacetCorePlugin.getJavaSrcFolder();
        this.sourceFolders.add((IPath)new Path(sourceFolder));
        String outputFolder = JavaFacetInstallConfig.getProductProperty(PROD_PROP_OUTPUT_FOLDER);
        if (outputFolder == null) {
            outputFolder = JavaFacetInstallConfig.getProductProperty(PROD_PROP_OUTPUT_FOLDER_LEGACY);
        }
        if (outputFolder == null) {
            outputFolder = DEFAULT_OUTPUT_FOLDER;
        }
        this.defaultOutputFolder = new Path(outputFolder);
    }

    public Set<IFile> getValidateEditFiles() {
        Set files = super.getValidateEditFiles();
        IProject project = this.getFacetedProjectWorkingCopy().getProject();
        if (project != null) {
            files.add(project.getFile(".project"));
            files.add(project.getFile(".classpath"));
            files.add(project.getFile(".settings/org.eclipse.jdt.core.prefs"));
            files.add(project.getFile(".settings/org.eclipse.jst.common.project.facet.core.prefs"));
        }
        return files;
    }

    public IStatus validate() {
        IStatus status = Status.OK_STATUS;
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (IPath sourceFolder : this.sourceFolders) {
            folders.add(new SourceFolder(sourceFolder));
        }
        folders.add(new OutputFolder(this.defaultOutputFolder));
        while (!folders.isEmpty()) {
            Folder folder = (Folder)folders.remove(0);
            status = this.validateFolder(folders, folder);
            if (!status.isOK()) break;
        }
        return status;
    }

    public IStatus validateSourceFolder(String candidateSourceFolder) {
        if (candidateSourceFolder == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (IPath sourceFolder : this.sourceFolders) {
            folders.add(new SourceFolder(sourceFolder));
        }
        folders.add(new OutputFolder(this.defaultOutputFolder));
        return this.validateFolder(folders, (Folder)new SourceFolder((IPath)new Path(candidateSourceFolder.trim())));
    }

    private IStatus validateFolder(List<Folder> existingFolders, Folder folder) {
        IStatus status = Status.OK_STATUS;
        if (folder.path.segmentCount() == 0) {
            status = folder instanceof SourceFolder ? new Status(4, "org.eclipse.jst.common.project.facet.core", Resources.mustSpecifySourceFolderMessage) : new Status(4, "org.eclipse.jst.common.project.facet.core", Resources.mustSpecifyDefaultOutputFolderMessage);
        } else {
            String pjname = this.getFacetedProjectWorkingCopy().getProjectName();
            String fullPath = "/" + pjname + "/" + folder.path;
            status = ResourcesPlugin.getWorkspace().validatePath(fullPath, 2);
            if (status.isOK()) {
                for (Folder existingFolder : existingFolders) {
                    status = this.validateFolder(existingFolder, folder);
                    if (!status.isOK()) break;
                }
            }
        }
        return status;
    }

    private IStatus validateFolder(Folder existingPath, Folder newPath) {
        int newPathLen;
        int existingPathLen = existingPath.path.segmentCount();
        int minPathLen = Math.min(existingPathLen, newPathLen = newPath.path.segmentCount());
        if (minPathLen == 0) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < minPathLen) {
            if (!this.comparePathSegments(existingPath.path.segment(i), newPath.path.segment(i))) {
                return Status.OK_STATUS;
            }
            ++i;
        }
        String message = null;
        if (existingPathLen == newPathLen) {
            if (existingPath instanceof SourceFolder && newPath instanceof SourceFolder) {
                message = NLS.bind((String)Resources.nonUniqueSourceFolderMessage, (Object)newPath.path);
            }
        } else {
            Folder y;
            Folder x;
            if (existingPathLen > newPathLen) {
                x = newPath;
                y = existingPath;
            } else {
                x = existingPath;
                y = newPath;
            }
            message = NLS.bind((String)Resources.cannotNestFoldersMessage, (Object[])new Object[]{x.path, x.getTypeLabel(), y.path, y.getTypeLabel()});
        }
        if (message == null) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.jst.common.project.facet.core", message);
    }

    private boolean comparePathSegments(String a, String b) {
        return this.caseSensitiveFs && a.equals(b) || !this.caseSensitiveFs && a.equalsIgnoreCase(b);
    }

    public List<IPath> getSourceFolders() {
        return this.sourceFoldersReadOnly;
    }

    public void setSourceFolders(List<IPath> paths) {
        if (!this.sourceFolders.equals(paths)) {
            this.sourceFolders.clear();
            this.sourceFolders.addAll(paths);
            ChangeEvent event = new ChangeEvent(ChangeEvent.Type.SOURCE_FOLDERS_CHANGED, this);
            this.listeners.notifyListeners((Enum)ChangeEvent.Type.SOURCE_FOLDERS_CHANGED, (Object)event);
        }
    }

    public void setSourceFolder(IPath path) {
        List<Object> newSourceFolders = path == null ? Collections.emptyList() : Collections.singletonList(path);
        this.setSourceFolders(newSourceFolders);
    }

    public void addSourceFolder(IPath path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<IPath> newSourceFolders = new ArrayList<IPath>(this.getSourceFolders());
        newSourceFolders.add(path);
        this.setSourceFolders(newSourceFolders);
    }

    public void removeSourceFolder(IPath path) {
        ArrayList<IPath> newSourceFolders = new ArrayList<IPath>(this.getSourceFolders());
        newSourceFolders.remove(path);
        this.setSourceFolders(newSourceFolders);
    }

    public IPath getDefaultOutputFolder() {
        return this.defaultOutputFolder;
    }

    public void setDefaultOutputFolder(IPath defaultOutputFolder) {
        if (!JavaFacetInstallConfig.equal(this.defaultOutputFolder, defaultOutputFolder)) {
            this.defaultOutputFolder = defaultOutputFolder;
            ChangeEvent event = new ChangeEvent(ChangeEvent.Type.DEFAULT_OUTPUT_FOLDER_CHANGED, this);
            this.listeners.notifyListeners((Enum)ChangeEvent.Type.DEFAULT_OUTPUT_FOLDER_CHANGED, (Object)event);
        }
    }

    public void addListener(IEventListener<ChangeEvent> listener, ChangeEvent.Type ... types) {
        this.listeners.addListener(listener, (Enum[])types);
    }

    public void removeListener(IEventListener<ChangeEvent> listener) {
        this.listeners.removeListener(listener);
    }

    private static boolean equal(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private static String getProductProperty(String propName) {
        String value = null;
        if (Platform.getProduct() != null) {
            value = Platform.getProduct().getProperty(propName);
        }
        return value;
    }

    public static class ChangeEvent {
        private final Type type;
        private final JavaFacetInstallConfig installConfig;

        ChangeEvent(Type type, JavaFacetInstallConfig installConfig) {
            this.type = type;
            this.installConfig = installConfig;
        }

        public final Type getType() {
            return this.type;
        }

        public final JavaFacetInstallConfig getJavaFacetInstallConfig() {
            return this.installConfig;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            SOURCE_FOLDERS_CHANGED,
            DEFAULT_OUTPUT_FOLDER_CHANGED;

        }
    }

    private static abstract class Folder {
        public final IPath path;

        public Folder(IPath path) {
            this.path = path;
        }

        public abstract String getTypeLabel();
    }

    private static final class OutputFolder
    extends Folder {
        public OutputFolder(IPath path) {
            super(path);
        }

        public String getTypeLabel() {
            return Resources.outputFolderType;
        }
    }

    private static final class Resources
    extends NLS {
        public static String mustSpecifySourceFolderMessage;
        public static String mustSpecifyDefaultOutputFolderMessage;
        public static String nonUniqueSourceFolderMessage;
        public static String cannotNestFoldersMessage;
        public static String sourceFolderType;
        public static String outputFolderType;

        static {
            Resources.initializeMessages((String)JavaFacetInstallConfig.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class SourceFolder
    extends Folder {
        public SourceFolder(IPath path) {
            super(path);
        }

        public String getTypeLabel() {
            return Resources.sourceFolderType;
        }
    }
}

