/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.validation;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.validation.JpaValidationPreferences;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class DefaultJpaValidationMessages {
    private static String[] DEFAULT_PARMS = new String[0];
    private static TextRange DEFAULT_TEXT_RANGE = TextRange.Empty.instance();

    public static IMessage buildMessage(int defaultSeverity, String messageId, Object targetObject) {
        return DefaultJpaValidationMessages.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, Object targetObject) {
        return DefaultJpaValidationMessages.buildMessage(defaultSeverity, messageId, parms, targetObject, DEFAULT_TEXT_RANGE);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, Object targetObject, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject, textRange);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, Object targetObject, TextRange textRange) {
        int severity = defaultSeverity;
        int severityPreference = JpaValidationPreferences.getProblemSeverityPreference(targetObject, messageId);
        if (severityPreference != -1) {
            severity = severityPreference;
        }
        Message message = new Message("jpa_validation", severity, messageId, parms, targetObject);
        message.setMarkerId("org.eclipse.jpt.jpa.core.jpaProblemMarker");
        if (textRange == null) {
            JptJpaCorePlugin.log(new NullPointerException("Null text range for message ID: " + messageId));
        } else {
            message.setLineNo(textRange.getLineNumber());
            message.setOffset(textRange.getOffset());
            message.setLength(textRange.getLength());
        }
        return message;
    }

    private DefaultJpaValidationMessages() {
        throw new UnsupportedOperationException();
    }
}

