/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnsAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NestableJoinColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceJoinColumnsAnnotation
extends SourceAnnotation<Member>
implements JoinColumnsAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinColumns");
    private final Vector<NestableJoinColumnAnnotation> joinColumns = new Vector();

    public SourceJoinColumnsAnnotation(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.JoinColumns";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        AnnotationContainerTools.initialize(this, astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        AnnotationContainerTools.synchronize(this, astRoot);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.joinColumns.isEmpty();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.joinColumns);
    }

    @Override
    public String getElementName() {
        return "value";
    }

    @Override
    public String getNestedAnnotationName() {
        return "javax.persistence.JoinColumn";
    }

    @Override
    public Iterable<NestableJoinColumnAnnotation> getNestedAnnotations() {
        return new LiveCloneIterable(this.joinColumns);
    }

    @Override
    public int getNestedAnnotationsSize() {
        return this.joinColumns.size();
    }

    @Override
    public void nestStandAloneAnnotation(NestableAnnotation standAloneAnnotation) {
        this.nestStandAloneAnnotation(standAloneAnnotation, this.joinColumns.size());
    }

    private void nestStandAloneAnnotation(NestableAnnotation standAloneAnnotation, int index) {
        standAloneAnnotation.convertToNested(this, this.daa, index);
    }

    @Override
    public void addNestedAnnotation(int index, NestableAnnotation annotation) {
        this.joinColumns.add(index, (NestableJoinColumnAnnotation)annotation);
    }

    @Override
    public void convertLastNestedAnnotationToStandAlone() {
        this.joinColumns.remove(0).convertToStandAlone();
    }

    @Override
    public NestableJoinColumnAnnotation addNestedAnnotation() {
        return this.addNestedAnnotation(this.joinColumns.size());
    }

    private NestableJoinColumnAnnotation addNestedAnnotation(int index) {
        NestableJoinColumnAnnotation joinColumn = this.buildJoinColumn(index);
        this.joinColumns.add(index, joinColumn);
        return joinColumn;
    }

    @Override
    public void syncAddNestedAnnotation(Annotation astAnnotation) {
        int index = this.joinColumns.size();
        NestableJoinColumnAnnotation joinColumn = this.addNestedAnnotation(index);
        joinColumn.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("joinColumns", index, joinColumn);
    }

    private NestableJoinColumnAnnotation buildJoinColumn(int index) {
        return SourceJoinColumnAnnotation.createNestedJoinColumn(this.parent, (Member)this.annotatedElement, index, this.daa);
    }

    @Override
    public NestableJoinColumnAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
        return (NestableJoinColumnAnnotation)CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public NestableJoinColumnAnnotation removeNestedAnnotation(int index) {
        return this.joinColumns.remove(index);
    }

    @Override
    public void syncRemoveNestedAnnotations(int index) {
        this.removeItemsFromList(index, this.joinColumns, "joinColumns");
    }
}

