/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.search;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.xml.core.internal.search.matching.SAXSearchElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSearchPattern
extends SearchPattern {
    private String elementNamespace = null;
    private String elementName = null;
    private String attributeName = null;
    private String searchName = null;
    private String searchNamespace = null;
    private String parentName = null;
    private int depth = -1;
    private SAXSearchElement element = null;
    private Element domElement = null;

    public XMLSearchPattern(String elementNamespace, String parentElementName, String elementName, String attributeName) {
        this(elementNamespace, parentElementName, elementName, attributeName, -1);
    }

    public XMLSearchPattern(String elementNamespace, String elementName, String attributeName) {
        this(elementNamespace, null, elementName, attributeName, -1);
    }

    public XMLSearchPattern(String elementNamespace, String elementName, String attributeName, int depth) {
        this(elementNamespace, null, elementName, attributeName, depth);
    }

    private XMLSearchPattern(String elementNamespace, String parentElementName, String elementName, String attributeName, int depth) {
        this.attributeName = attributeName;
        this.elementName = elementName;
        this.parentName = parentElementName;
        this.elementNamespace = elementNamespace;
        this.depth = depth;
    }

    public XMLSearchPattern() {
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getElementNamespace() {
        return this.elementNamespace;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public String getSearchNamespace() {
        return this.searchNamespace;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public void setSearchNamespace(String searchNamespace) {
        this.searchNamespace = searchNamespace;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setElementNamespace(String elementNamespace) {
        this.elementNamespace = elementNamespace;
    }

    public void setSearchElement(SAXSearchElement element) {
        this.element = element;
    }

    public void setSearchElement(Element element) {
        this.domElement = element;
    }

    public boolean matches(XMLSearchPattern pattern) {
        if (pattern.searchName == null) {
            return false;
        }
        if ("*".equals(this.searchName) && "*".equals(this.searchNamespace)) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(pattern.searchName);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int n = token.indexOf(":");
            String name = token;
            String namespace = pattern.searchNamespace;
            if (n > 0) {
                String prefix = token.substring(0, n);
                name = token.substring(n + 1);
                String string = namespace = pattern.element != null ? (String)pattern.element.getNamespaceMap().get(prefix) : this.computeNamespaceForPrefix(pattern.domElement, prefix);
            }
            if (!(namespace == null ? name.equals(this.searchName) || "*".equals(this.searchName) : (namespace.equals(this.searchNamespace) || "*".equals(this.searchNamespace)) && name.equals(this.searchName))) continue;
            return true;
        }
        return false;
    }

    protected String computeNamespaceForPrefix(Element element, String prefix) {
        String result = null;
        Node node = element;
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element e = node;
                String attributeName = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
                String string = result = e.hasAttribute(attributeName) ? e.getAttribute(attributeName) : null;
                if (result != null && result.length() > 0) break;
            }
            node = node.getParentNode();
        }
        return result;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }
}

