/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.Map;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceQueryAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceQueryHintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableNamedNativeQueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NestableQueryHintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceNamedNativeQueryAnnotation
extends SourceQueryAnnotation
implements NestableNamedNativeQueryAnnotation {
    public static final SimpleDeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.NamedNativeQuery");
    private DeclarationAnnotationElementAdapter<String> resultClassDeclarationAdapter = this.buildResultClassDeclarationAdapter();
    private AnnotationElementAdapter<String> resultClassAdapter = this.buildResultClassAdapter();
    private String resultClass;
    private String fullyQualifiedResultClassName;
    private boolean fqResultClassNameStale = true;
    private DeclarationAnnotationElementAdapter<String> resultSetMappingDeclarationAdapter;
    private AnnotationElementAdapter<String> resultSetMappingAdapter;
    private String resultSetMapping;

    public SourceNamedNativeQueryAnnotation(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, type, daa, annotationAdapter);
        this.resultSetMappingDeclarationAdapter = this.buildResultSetMappingAdapter(daa);
        this.resultSetMappingAdapter = this.buildResultSetMappingAdapter();
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.NamedNativeQuery";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.resultClass = this.buildResultClass(astRoot);
        this.resultSetMapping = this.buildResultSetMapping(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncResultClass(this.buildResultClass(astRoot));
        this.syncResultSetMapping(this.buildResultSetMapping(astRoot));
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    String getQueryElementName() {
        return "query";
    }

    @Override
    String getHintsElementName() {
        return "hints";
    }

    @Override
    NestableQueryHintAnnotation buildHint(int index) {
        return SourceQueryHintAnnotation.createNamedNativeQueryQueryHint(this, (Type)this.annotatedElement, this.daa, index);
    }

    @Override
    public String getResultClass() {
        return this.resultClass;
    }

    @Override
    public void setResultClass(String resultClass) {
        if (this.attributeValueHasChanged(this.resultClass, resultClass)) {
            this.resultClass = resultClass;
            this.fqResultClassNameStale = true;
            this.resultClassAdapter.setValue((Object)resultClass);
        }
    }

    private void syncResultClass(String astResultClass) {
        if (this.attributeValueHasChanged(this.resultClass, astResultClass)) {
            this.syncResultClass_(astResultClass);
        }
    }

    private void syncResultClass_(String astResultClass) {
        String old = this.resultClass;
        this.resultClass = astResultClass;
        this.fqResultClassNameStale = true;
        this.firePropertyChanged("resultClass", old, astResultClass);
    }

    private String buildResultClass(CompilationUnit astRoot) {
        return (String)this.resultClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getResultClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultClassDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildResultClassDeclarationAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, "resultClass", SimpleTypeStringExpressionConverter.instance());
    }

    private AnnotationElementAdapter<String> buildResultClassAdapter() {
        return this.buildStringElementAdapter(this.resultClassDeclarationAdapter);
    }

    @Override
    public String getFullyQualifiedResultClassName() {
        if (this.fqResultClassNameStale) {
            this.fullyQualifiedResultClassName = this.buildFullyQualifiedResultClassName();
            this.fqResultClassNameStale = false;
        }
        return this.fullyQualifiedResultClassName;
    }

    private String buildFullyQualifiedResultClassName() {
        return this.resultClass == null ? null : this.buildFullyQualifiedResultClassName_();
    }

    private String buildFullyQualifiedResultClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.resultClassAdapter.getExpression(this.buildASTRoot()));
    }

    @Override
    public String getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    public void setResultSetMapping(String resultSetMapping) {
        if (this.attributeValueHasChanged(this.resultSetMapping, resultSetMapping)) {
            this.resultSetMapping = resultSetMapping;
            this.resultSetMappingAdapter.setValue((Object)resultSetMapping);
        }
    }

    private void syncResultSetMapping(String astResultSetMapping) {
        String old = this.resultSetMapping;
        this.resultSetMapping = astResultSetMapping;
        this.firePropertyChanged("resultSetMapping", old, astResultSetMapping);
    }

    private String buildResultSetMapping(CompilationUnit astRoot) {
        return (String)this.resultSetMappingAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getResultSetMappingTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultSetMappingDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildResultSetMappingAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"resultSetMapping");
    }

    private AnnotationElementAdapter<String> buildResultSetMappingAdapter() {
        return this.buildStringElementAdapter(this.resultSetMappingDeclarationAdapter);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.resultClass == null && this.resultSetMapping == null;
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.resultClassDeclarationAdapter = this.buildResultClassDeclarationAdapter();
        this.resultClassAdapter = this.buildResultClassAdapter();
        this.resultSetMappingDeclarationAdapter = this.buildResultSetMappingAdapter(this.daa);
        this.resultSetMappingAdapter = this.buildResultSetMappingAdapter();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        map.put("resultClass", this.resultClass);
        this.resultClass = null;
        map.put("resultSetMapping", this.resultSetMapping);
        this.resultSetMapping = null;
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        this.setResultClass((String)map.get("resultClass"));
        this.setResultSetMapping((String)map.get("resultSetMapping"));
    }

    public static SourceNamedNativeQueryAnnotation createNamedNativeQuery(JavaResourceNode parent, Type type) {
        return new SourceNamedNativeQueryAnnotation(parent, type, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new ElementAnnotationAdapter((AnnotatedElement)type, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER));
    }

    static SourceNamedNativeQueryAnnotation createNestedNamedNativeQuery(JavaResourceNode parent, Type type, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourceNamedNativeQueryAnnotation.buildNestedDeclarationAnnotationAdapter(index, attributeOverridesAdapter, "javax.persistence.NamedNativeQuery");
        ElementIndexedAnnotationAdapter annotationAdapter = new ElementIndexedAnnotationAdapter((AnnotatedElement)type, idaa);
        return new SourceNamedNativeQueryAnnotation(parent, type, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }
}

