/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi;

import org.eclipse.wst.jsdt.debug.core.jsdi.NumberValue;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFMirror;

public class CFNumberValue
extends CFMirror
implements NumberValue {
    public static final Double NAN_OBJ = new Double(Double.NaN);
    public static final Double NEG_INFINITY_OBJ = new Double(Double.NEGATIVE_INFINITY);
    public static final Double INFINITY_OBJ = new Double(Double.POSITIVE_INFINITY);
    private Number number = null;

    public CFNumberValue(VirtualMachine vm, Number number) {
        super(vm);
        this.number = number != null ? (Number)number : (Number)NAN_OBJ;
    }

    public CFNumberValue(VirtualMachine vm, String number) {
        super(vm);
        if ("Infinity".equals(number)) {
            this.number = INFINITY_OBJ;
        } else if ("-Infinity".equals(number)) {
            this.number = NEG_INFINITY_OBJ;
        }
        if (this.number == null) {
            this.number = NAN_OBJ;
        }
    }

    public int intValue() {
        return this.number.intValue();
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }

    public boolean booleanValue() {
        return this.number.intValue() > 0;
    }

    public String stringValue() {
        return this.number.toString();
    }

    public String valueString() {
        return this.stringValue();
    }

    public Number value() {
        return this.number;
    }

    public boolean isNaN() {
        return Double.isNaN(this.number.doubleValue());
    }
}

