/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceSequenceGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.SequenceGenerator2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;

public final class SourceSequenceGenerator2_0Annotation
extends SourceSequenceGeneratorAnnotation
implements SequenceGenerator2_0Annotation {
    private static final DeclarationAnnotationElementAdapter<String> CATALOG_ADAPTER = SourceSequenceGenerator2_0Annotation.buildAdapter("catalog");
    private final AnnotationElementAdapter<String> catalogAdapter = this.buildAdapter(CATALOG_ADAPTER);
    private String catalog;
    private static final DeclarationAnnotationElementAdapter<String> SCHEMA_ADAPTER = SourceSequenceGenerator2_0Annotation.buildAdapter("schema");
    private final AnnotationElementAdapter<String> schemaAdapter = this.buildAdapter(SCHEMA_ADAPTER);
    private String schema;

    public SourceSequenceGenerator2_0Annotation(JavaResourceNode parent, Member member) {
        super(parent, member);
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.catalog = this.buildCatalog(astRoot);
        this.schema = this.buildSchema(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncCatalog(this.buildCatalog(astRoot));
        this.syncSchema(this.buildSchema(astRoot));
    }

    public boolean isUnset() {
        return super.isUnset() && this.catalog == null && this.schema == null;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        if (this.attributeValueHasChanged(this.catalog, catalog)) {
            this.catalog = catalog;
            this.catalogAdapter.setValue((Object)catalog);
        }
    }

    private void syncCatalog(String astCatalog) {
        String old = this.catalog;
        this.catalog = astCatalog;
        this.firePropertyChanged("catalog", old, astCatalog);
    }

    private String buildCatalog(CompilationUnit astRoot) {
        return (String)this.catalogAdapter.getValue(astRoot);
    }

    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(CATALOG_ADAPTER, astRoot);
    }

    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(CATALOG_ADAPTER, pos, astRoot);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        if (this.attributeValueHasChanged(this.schema, schema)) {
            this.schema = schema;
            this.schemaAdapter.setValue((Object)schema);
        }
    }

    private void syncSchema(String astSchema) {
        String old = this.schema;
        this.schema = astSchema;
        this.firePropertyChanged("schema", old, astSchema);
    }

    private String buildSchema(CompilationUnit astRoot) {
        return (String)this.schemaAdapter.getValue(astRoot);
    }

    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SCHEMA_ADAPTER, astRoot);
    }

    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(SCHEMA_ADAPTER, pos, astRoot);
    }
}

