/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import java.util.Map;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryNode;
import org.eclipse.jpt.jpa.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryAnnotation
extends BinaryNode
implements org.eclipse.jpt.jpa.core.resource.java.Annotation {
    final IAnnotation jdtAnnotation;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final IMemberValuePair[] EMPTY_MEMBER_VALUE_PAIR_ARRAY = new IMemberValuePair[0];

    protected BinaryAnnotation(JavaResourceNode parent, IAnnotation jdtAnnotation) {
        super(parent);
        this.jdtAnnotation = jdtAnnotation;
    }

    protected Object[] getJdtMemberValues(String memberName) {
        Object[] values = (Object[])this.getJdtMemberValue(memberName);
        return values != null ? values : EMPTY_OBJECT_ARRAY;
    }

    protected Object getJdtMemberValue(String memberName) {
        IMemberValuePair pair = this.getJdtMemberValuePair(memberName);
        return pair == null ? null : pair.getValue();
    }

    private IMemberValuePair getJdtMemberValuePair(String memberName) {
        IMemberValuePair[] iMemberValuePairArray = this.getJdtMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (pair.getMemberName().equals(memberName)) {
                return pair;
            }
            ++n2;
        }
        return null;
    }

    private IMemberValuePair[] getJdtMemberValuePairs() {
        try {
            return this.jdtAnnotation.getMemberValuePairs();
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return EMPTY_MEMBER_VALUE_PAIR_ARRAY;
        }
    }

    @Override
    public Annotation getAstAnnotation(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void newAnnotation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUnset() {
        throw new UnsupportedOperationException();
    }

    public void moveAnnotation(int index) {
        throw new UnsupportedOperationException();
    }

    public void convertToNested(ContainerAnnotation<? extends NestableAnnotation> containerAnnotation, DeclarationAnnotationAdapter containerAnnotationAdapter, int index) {
        throw new UnsupportedOperationException();
    }

    public void convertToStandAlone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }
}

