/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import java.util.Iterator;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryAnnotatedElement;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.jpa.core.resource.java.NestableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryPersistentMember
extends BinaryAnnotatedElement
implements JavaResourcePersistentMember {
    boolean persistable = this.buildPersistable();
    private boolean final_ = this.buildFinal();

    public BinaryPersistentMember(JavaResourceNode parent, Adapter adapter) {
        super(parent, adapter);
    }

    private Adapter getAdapter() {
        return (Adapter)this.adapter;
    }

    @Override
    public void update() {
        super.update();
        this.setPersistable(this.buildPersistable());
        this.setFinal(this.buildFinal());
    }

    @Override
    public boolean isPersistable() {
        return this.persistable;
    }

    private void setPersistable(boolean persistable) {
        boolean old = this.persistable;
        this.persistable = persistable;
        this.firePropertyChanged("persistable", old, persistable);
    }

    private boolean buildPersistable() {
        return this.getAdapter().isPersistable();
    }

    @Override
    public boolean isFinal() {
        return this.final_;
    }

    private void setFinal(boolean final_) {
        boolean old = this.final_;
        this.final_ = final_;
        this.firePropertyChanged("final", old, final_);
    }

    private boolean buildFinal() {
        try {
            return Flags.isFinal((int)this.getMember().getFlags());
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return false;
        }
    }

    IMember getMember() {
        return (IMember)this.adapter.getElement();
    }

    <T extends JavaResourcePersistentMember> Iterator<T> persistableMembers(Iterator<T> members) {
        Filter filter = PERSISTABLE_MEMBER_FILTER;
        return new FilteringIterator(members, filter);
    }

    static String convertTypeSignatureToTypeName(String typeSignature) {
        return typeSignature == null ? null : BinaryPersistentMember.convertTypeSignatureToTypeName_(typeSignature);
    }

    static String convertTypeSignatureToTypeName_(String typeSignature) {
        return Signature.toString((String)Signature.getTypeErasure((String)typeSignature));
    }

    @Override
    public Annotation addAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NestableAnnotation addAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveAnnotation(int targetIndex, int sourceIndex, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation setPrimaryAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        throw new UnsupportedOperationException();
    }

    static interface Adapter
    extends BinaryAnnotatedElement.Adapter {
        public IMember getElement();

        public boolean isPersistable();
    }
}

