/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmBaseEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.AttributeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.BaseColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.OverrideTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EmbeddableOverrideDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.OverrideValidator;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.orm.AbstractXmlEmbedded;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmBaseEmbeddedMapping<X extends AbstractXmlEmbedded>
extends AbstractOrmAttributeMapping<X>
implements OrmBaseEmbeddedMapping {
    protected final OrmAttributeOverrideContainer attributeOverrideContainer = this.buildAttributeOverrideContainer();
    protected Embeddable targetEmbeddable;

    protected AbstractOrmBaseEmbeddedMapping(OrmPersistentAttribute parent, X xmlMapping) {
        super(parent, xmlMapping);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.attributeOverrideContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.attributeOverrideContainer.update();
        this.setTargetEmbeddable(this.buildTargetEmbeddable());
    }

    @Override
    public OrmAttributeOverrideContainer getAttributeOverrideContainer() {
        return this.attributeOverrideContainer;
    }

    protected OrmAttributeOverrideContainer buildAttributeOverrideContainer() {
        return this.getContextNodeFactory().buildOrmAttributeOverrideContainer(this, this.buildAttributeOverrideContainerOwner());
    }

    protected OrmAttributeOverrideContainer.Owner buildAttributeOverrideContainerOwner() {
        return new AttributeOverrideContainerOwner();
    }

    @Override
    public Embeddable getTargetEmbeddable() {
        return this.targetEmbeddable;
    }

    protected void setTargetEmbeddable(Embeddable embeddable) {
        Embeddable old = this.targetEmbeddable;
        this.targetEmbeddable = embeddable;
        this.firePropertyChanged("targetEmbeddable", old, embeddable);
    }

    protected Embeddable buildTargetEmbeddable() {
        JavaPersistentAttribute javaAttribute = this.getJavaPersistentAttribute();
        return javaAttribute == null ? null : javaAttribute.getEmbeddable();
    }

    @Override
    public Iterator<String> allOverridableAttributeMappingNames() {
        return this.isJpa2_0Compatible() ? this.embeddableOverridableAttributeMappingNames() : super.allOverridableAttributeMappingNames();
    }

    protected Iterator<String> embeddableOverridableAttributeMappingNames() {
        return this.qualifiedEmbeddableOverridableMappingNames(AttributeMappingTools.ALL_OVERRIDABLE_ATTRIBUTE_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterator<String> allOverridableAssociationMappingNames() {
        return this.isJpa2_0Compatible() ? this.embeddableOverridableAssociationMappingNames() : super.allOverridableAssociationMappingNames();
    }

    protected Iterator<String> embeddableOverridableAssociationMappingNames() {
        return this.qualifiedEmbeddableOverridableMappingNames(AttributeMappingTools.ALL_OVERRIDABLE_ASSOCIATION_MAPPING_NAMES_TRANSFORMER);
    }

    protected Iterator<String> qualifiedEmbeddableOverridableMappingNames(Transformer<AttributeMapping, Iterator<String>> transformer) {
        return new TransformationIterator(this.embeddableAttributeMappingNames(transformer), this.buildQualifierTransformer());
    }

    protected Iterator<String> embeddableAttributeMappingNames(Transformer<AttributeMapping, Iterator<String>> transformer) {
        return new CompositeIterator(this.embeddableAttributeMappingNamesLists(transformer));
    }

    protected Iterator<Iterator<String>> embeddableAttributeMappingNamesLists(Transformer<AttributeMapping, Iterator<String>> transformer) {
        return new TransformationIterator(this.embeddableAttributeMappings(), transformer);
    }

    protected Iterator<AttributeMapping> embeddableAttributeMappings() {
        return this.targetEmbeddable != null && this.targetEmbeddable != this.getTypeMapping() ? this.targetEmbeddable.attributeMappings() : EmptyIterator.instance();
    }

    @Override
    protected void initializeFromOrmBaseEmbeddedMapping(OrmBaseEmbeddedMapping oldMapping) {
        super.initializeFromOrmBaseEmbeddedMapping(oldMapping);
        this.attributeOverrideContainer.initializeFrom(oldMapping.getAttributeOverrideContainer());
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        return this.isJpa2_0Compatible() ? this.resolveOverriddenColumn_(attributeName) : null;
    }

    protected Column resolveOverriddenColumn_(String attributeName) {
        if ((attributeName = this.unqualify(attributeName)) == null) {
            return null;
        }
        OrmAttributeOverride override = this.attributeOverrideContainer.getSpecifiedOverrideNamed(attributeName);
        return override != null ? override.getColumn() : this.resolveOverriddenColumnInTargetEmbeddable(attributeName);
    }

    protected Column resolveOverriddenColumnInTargetEmbeddable(String attributeName) {
        return this.targetEmbeddable == null ? null : this.targetEmbeddable.resolveOverriddenColumn(attributeName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.validateTargetEmbeddable(messages)) {
            this.validateOverrides(messages, reporter);
        }
    }

    protected boolean validateTargetEmbeddable(List<IMessage> messages) {
        if (this.targetEmbeddable == null) {
            String targetEmbeddableTypeName = this.getPersistentAttribute().getTypeName();
            if (targetEmbeddableTypeName != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_NOT_AN_EMBEDDABLE", new String[]{targetEmbeddableTypeName}, this, this.getValidationTextRange()));
            }
            return false;
        }
        return true;
    }

    protected void validateOverrides(List<IMessage> messages, IReporter reporter) {
        this.attributeOverrideContainer.validate(messages, reporter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeOverrideContainerOwner
    implements OrmAttributeOverrideContainer.Owner {
        protected AttributeOverrideContainerOwner() {
        }

        @Override
        public OrmTypeMapping getTypeMapping() {
            return AbstractOrmBaseEmbeddedMapping.this.getTypeMapping();
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractOrmBaseEmbeddedMapping.this.getTargetEmbeddable();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping != null ? this.allOverridableAttributeNames_(typeMapping) : EmptyIterator.instance();
        }

        protected Iterator<String> allOverridableAttributeNames_(TypeMapping typeMapping) {
            return typeMapping.allOverridableAttributeNames();
        }

        @Override
        public EList<XmlAttributeOverride> getXmlOverrides() {
            return ((AbstractXmlEmbedded)AbstractOrmBaseEmbeddedMapping.this.getXmlAttributeMapping()).getAttributeOverrides();
        }

        @Override
        public Column resolveOverriddenColumn(String attributeName) {
            return MappingTools.resolveOverriddenColumn(this.getOverridableTypeMapping(), attributeName);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return this.getTypeMapping().allAssociatedTableNames();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return this.getTypeMapping().resolveDbTable(tableName);
        }

        @Override
        public String getDefaultTableName() {
            return this.getTypeMapping().getPrimaryTableName();
        }

        @Override
        public JptValidator buildValidator(Override_ override, OverrideContainer container, OverrideTextRangeResolver textRangeResolver) {
            return new AttributeOverrideValidator((PersistentAttribute)this.getPersistentAttribute(), (AttributeOverride)override, (AttributeOverrideContainer)container, textRangeResolver, (OverrideValidator.OverrideDescriptionProvider)new EmbeddableOverrideDescriptionProvider());
        }

        @Override
        public JptValidator buildColumnValidator(Override_ override, BaseColumn column, BaseColumn.Owner owner, BaseColumnTextRangeResolver textRangeResolver) {
            return new AttributeOverrideColumnValidator(this.getPersistentAttribute(), (AttributeOverride)override, column, textRangeResolver, new EntityTableDescriptionProvider());
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractOrmBaseEmbeddedMapping.this.getValidationTextRange();
        }

        protected OrmPersistentAttribute getPersistentAttribute() {
            return AbstractOrmBaseEmbeddedMapping.this.getPersistentAttribute();
        }
    }
}

