/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableQueryHintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceQueryAnnotation
extends SourceAnnotation<Type>
implements QueryAnnotation {
    DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    AnnotationElementAdapter<String> nameAdapter;
    String name;
    TextRange nameTextRange;
    DeclarationAnnotationElementAdapter<String> queryDeclarationAdapter;
    AnnotationElementAdapter<String> queryAdapter;
    String query;
    TextRange queryTextRange;
    final Vector<NestableQueryHintAnnotation> hints = new Vector();
    final HintsAnnotationContainer hintsContainer = new HintsAnnotationContainer();

    SourceQueryAnnotation(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, type, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.queryDeclarationAdapter = this.buildQueryDeclarationAdapter();
        this.queryAdapter = this.buildQueryAdapter();
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.query = this.buildQuery(astRoot);
        this.queryTextRange = this.buildQueryTextRange(astRoot);
        AnnotationContainerTools.initialize(this.hintsContainer, astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.syncQuery(this.buildQuery(astRoot));
        this.queryTextRange = this.buildQueryTextRange(astRoot);
        AnnotationContainerTools.synchronize(this.hintsContainer, astRoot);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)this.getNameElementName());
    }

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildStringElementAdapter(this.nameDeclarationAdapter);
    }

    abstract String getNameElementName();

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        if (this.attributeValueHasChanged(this.query, query)) {
            this.query = query;
            this.queryAdapter.setValue((Object)query);
        }
    }

    private void syncQuery(String annotationQuery) {
        String old = this.query;
        this.query = annotationQuery;
        this.firePropertyChanged("query", old, annotationQuery);
    }

    private String buildQuery(CompilationUnit astRoot) {
        return (String)this.queryAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getQueryTextRange(CompilationUnit astRoot) {
        return this.queryTextRange;
    }

    private TextRange buildQueryTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.queryDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildQueryDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)this.getQueryElementName());
    }

    private AnnotationElementAdapter<String> buildQueryAdapter() {
        return this.buildStringElementAdapter(this.queryDeclarationAdapter);
    }

    abstract String getQueryElementName();

    @Override
    public ListIterator<QueryHintAnnotation> hints() {
        return new CloneListIterator(this.hints);
    }

    Iterable<NestableQueryHintAnnotation> getNestableHints() {
        return new LiveCloneIterable(this.hints);
    }

    @Override
    public int hintsSize() {
        return this.hints.size();
    }

    @Override
    public NestableQueryHintAnnotation hintAt(int index) {
        return this.hints.get(index);
    }

    @Override
    public int indexOfHint(QueryHintAnnotation hint) {
        return this.hints.indexOf(hint);
    }

    private NestableQueryHintAnnotation addHint() {
        return this.addHint(this.hints.size());
    }

    @Override
    public NestableQueryHintAnnotation addHint(int index) {
        return (NestableQueryHintAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.hintsContainer);
    }

    NestableQueryHintAnnotation addHint_() {
        return this.addHint_(this.hints.size());
    }

    private NestableQueryHintAnnotation addHint_(int index) {
        NestableQueryHintAnnotation hint = this.buildHint(index);
        this.hints.add(index, hint);
        return hint;
    }

    void syncAddHint(Annotation astAnnotation) {
        int index = this.hints.size();
        NestableQueryHintAnnotation hint = this.addHint_(index);
        hint.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("hints", index, hint);
    }

    abstract NestableQueryHintAnnotation buildHint(int var1);

    void hintAdded(int index, NestableQueryHintAnnotation hint) {
        this.fireItemAdded("hints", index, hint);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.hintsContainer);
    }

    NestableQueryHintAnnotation moveHint_(int targetIndex, int sourceIndex) {
        return (NestableQueryHintAnnotation)CollectionTools.move(this.hints, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public void removeHint(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.hintsContainer);
    }

    NestableQueryHintAnnotation removeHint_(int index) {
        return this.hints.remove(index);
    }

    void syncRemoveHints(int index) {
        this.removeItemsFromList(index, this.hints, "hints");
    }

    abstract String getHintsElementName();

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.query == null && this.hints.isEmpty();
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.queryDeclarationAdapter = this.buildQueryDeclarationAdapter();
        this.queryAdapter = this.buildQueryAdapter();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        map.put("name", this.name);
        this.name = null;
        map.put("query", this.query);
        this.query = null;
        List<Map<String, Object>> hintsState = this.buildStateList(this.hints.size());
        for (NestableQueryHintAnnotation hint : this.getNestableHints()) {
            HashMap<String, Object> hintState = new HashMap<String, Object>();
            hint.storeOn(hintState);
            hintsState.add(hintState);
        }
        map.put("hints", hintsState);
        this.hints.clear();
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        this.setName((String)map.get("name"));
        this.setQuery((String)map.get("query"));
        List hintsState = (List)map.get("hints");
        for (Map hintState : hintsState) {
            this.addHint().restoreFrom(hintState);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HintsAnnotationContainer
    implements AnnotationContainer<NestableQueryHintAnnotation> {
        HintsAnnotationContainer() {
        }

        @Override
        public Annotation getAstAnnotation(CompilationUnit astRoot) {
            return SourceQueryAnnotation.this.getAstAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return SourceQueryAnnotation.this.getHintsElementName();
        }

        @Override
        public String getNestedAnnotationName() {
            return "javax.persistence.QueryHint";
        }

        @Override
        public Iterable<NestableQueryHintAnnotation> getNestedAnnotations() {
            return SourceQueryAnnotation.this.getNestableHints();
        }

        @Override
        public int getNestedAnnotationsSize() {
            return SourceQueryAnnotation.this.hintsSize();
        }

        @Override
        public NestableQueryHintAnnotation addNestedAnnotation() {
            return SourceQueryAnnotation.this.addHint_();
        }

        @Override
        public void syncAddNestedAnnotation(Annotation astAnnotation) {
            SourceQueryAnnotation.this.syncAddHint(astAnnotation);
        }

        @Override
        public NestableQueryHintAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
            return SourceQueryAnnotation.this.moveHint_(targetIndex, sourceIndex);
        }

        @Override
        public NestableQueryHintAnnotation removeNestedAnnotation(int index) {
            return SourceQueryAnnotation.this.removeHint_(index);
        }

        @Override
        public void syncRemoveNestedAnnotations(int index) {
            SourceQueryAnnotation.this.syncRemoveHints(index);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

