/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JarFile;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJarFile
extends AbstractPersistenceXmlContextNode
implements JarFile,
PersistentType.Owner {
    protected final JavaResourcePackageFragmentRoot jarResourcePackageFragmentRoot;
    protected final Vector<JavaPersistentType> javaPersistentTypes = new Vector();
    protected final JavaPersistentTypeContainerAdapter javaPersistentTypeContainerAdapter = new JavaPersistentTypeContainerAdapter();

    public GenericJarFile(JarFileRef parent, JavaResourcePackageFragmentRoot jarResourcePackageFragmentRoot) {
        super(parent);
        this.jarResourcePackageFragmentRoot = jarResourcePackageFragmentRoot;
        this.initializeJavaPersistentTypes();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncJavaPersistentTypes();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes(this.getJavaPersistentTypes());
    }

    @Override
    public JavaResourcePackageFragmentRoot getJarResourcePackageFragmentRoot() {
        return this.jarResourcePackageFragmentRoot;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public JptResourceType getResourceType() {
        return JptCommonCorePlugin.JAR_RESOURCE_TYPE;
    }

    @Override
    public JavaPersistentType getPersistentType(String typeName) {
        for (JavaPersistentType pt : this.getJavaPersistentTypes()) {
            if (!pt.getName().equals(typeName)) continue;
            return pt;
        }
        return null;
    }

    @Override
    public Iterator<JavaPersistentType> javaPersistentTypes() {
        return this.getJavaPersistentTypes().iterator();
    }

    protected Iterable<JavaPersistentType> getJavaPersistentTypes() {
        return new LiveCloneIterable(this.javaPersistentTypes);
    }

    @Override
    public int javaPersistentTypesSize() {
        return this.javaPersistentTypes.size();
    }

    protected void initializeJavaPersistentTypes() {
        for (JavaResourcePersistentType jrpt : this.getJavaResourcePersistentTypes()) {
            this.javaPersistentTypes.add(this.buildJavaPersistentType(jrpt));
        }
    }

    protected void syncJavaPersistentTypes() {
        ContextContainerTools.synchronizeWithResourceModel(this.javaPersistentTypeContainerAdapter);
    }

    protected void addJavaPersistentType(JavaResourcePersistentType jrpt) {
        JavaPersistentType javaPersistentType = this.buildJavaPersistentType(jrpt);
        this.addItemToCollection(javaPersistentType, this.javaPersistentTypes, "javaPersistentTypes");
    }

    protected void removeJavaPersistentType(JavaPersistentType javaPersistentType) {
        this.removeItemFromCollection(javaPersistentType, this.javaPersistentTypes, "javaPersistentTypes");
    }

    protected Iterable<JavaResourcePersistentType> getJavaResourcePersistentTypes() {
        return CollectionTools.iterable(this.jarResourcePackageFragmentRoot.persistentTypes());
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourcePersistentType jrpt) {
        return this.getJpaFactory().buildJavaPersistentType(this, jrpt);
    }

    @Override
    public Iterable<? extends PersistentType> getPersistentTypes() {
        return this.getJavaPersistentTypes();
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return null;
    }

    @Override
    public JarFileRef getParent() {
        return (JarFileRef)super.getParent();
    }

    protected JarFileRef getJarFileRef() {
        return this.getParent();
    }

    @Override
    public IResource getResource() {
        return this.jarResourcePackageFragmentRoot.getFile();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
    }

    @Override
    public boolean isIn(IFolder folder) {
        IResource member = folder.findMember(this.jarResourcePackageFragmentRoot.getFile().getName());
        IFile file = this.jarResourcePackageFragmentRoot.getFile();
        return member != null && file != null && member.equals((Object)file);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getJarFileRef().getValidationTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JavaPersistentTypeContainerAdapter
    implements ContextContainerTools.Adapter<JavaPersistentType, JavaResourcePersistentType> {
        protected JavaPersistentTypeContainerAdapter() {
        }

        @Override
        public Iterable<JavaPersistentType> getContextElements() {
            return GenericJarFile.this.getJavaPersistentTypes();
        }

        @Override
        public Iterable<JavaResourcePersistentType> getResourceElements() {
            return GenericJarFile.this.getJavaResourcePersistentTypes();
        }

        @Override
        public JavaResourcePersistentType getResourceElement(JavaPersistentType contextElement) {
            return contextElement.getResourcePersistentType();
        }

        @Override
        public void moveContextElement(int index, JavaPersistentType element) {
        }

        @Override
        public void addContextElement(int index, JavaResourcePersistentType resourceElement) {
            GenericJarFile.this.addJavaPersistentType(resourceElement);
        }

        @Override
        public void removeContextElement(JavaPersistentType element) {
            GenericJarFile.this.removeJavaPersistentType(element);
        }
    }
}

