/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.resource.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.JptResourceModelListener;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.resource.xml.JpaRootEObject;
import org.eclipse.jst.j2ee.internal.xml.J2EEXmlDtDEntityResolver;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResourceImpl;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaXmlResource
extends TranslatorResourceImpl
implements JptResourceModel {
    protected final IContentType contentType;
    protected final Translator rootTranslator;
    protected final ListenerList<JptResourceModelListener> resourceModelListenerList = new ListenerList(JptResourceModelListener.class);

    public JpaXmlResource(URI uri, Renderer renderer, IContentType contentType, Translator rootTranslator) {
        super(uri, renderer);
        this.contentType = contentType;
        this.rootTranslator = rootTranslator;
    }

    public IContentType getContentType() {
        return this.contentType;
    }

    public String getVersion() {
        JpaRootEObject root = this.getRootObject();
        return root == null ? null : root.getVersion();
    }

    public JptResourceType getResourceType() {
        String version = this.getVersion();
        return this.contentType == null || version == null ? null : new JptResourceType(this.contentType, version);
    }

    public void eNotify(Notification notification) {
        if (this.loadedFlagCleared(notification)) {
            super.eNotify(notification);
            if (this.isReverting()) {
                this.resourceModelReverted();
            } else {
                this.resourceModelUnloaded();
            }
        } else if (!notification.isTouch() && this.isLoaded() && this.resourceSet != null) {
            super.eNotify(notification);
            this.resourceModelChanged();
        }
    }

    protected boolean loadedFlagCleared(Notification notification) {
        return notification.getNotifier() == this && notification.getEventType() == 1 && notification.getFeatureID(Resource.class) == 4 && !notification.getNewBooleanValue();
    }

    protected boolean resultSetCleared(Notification notification) {
        return notification.getNotifier() == this && notification.getEventType() == 1 && notification.getFeatureID(Resource.class) == 0 && notification.getNewValue() == null;
    }

    public String getDoctype() {
        return null;
    }

    public Translator getRootTranslator() {
        return this.rootTranslator;
    }

    protected String getDefaultPublicId() {
        return null;
    }

    protected String getDefaultSystemId() {
        return null;
    }

    protected int getDefaultVersionID() {
        return 10;
    }

    public JpaRootEObject getRootObject() {
        EObject root = super.getRootObject();
        try {
            return (JpaRootEObject)root;
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException("The root object of a JPA XML resource must implement JpaRootEObject: " + root, ex);
        }
    }

    public EntityResolver getEntityResolver() {
        return J2EEXmlDtDEntityResolver.INSTANCE;
    }

    public boolean fileExists() {
        return this.getFile().exists();
    }

    public IFile getFile() {
        IFile file = this.getFile(this.uri);
        return file != null ? file : this.getConvertedURIFile();
    }

    protected IFile getConvertedURIFile() {
        if (this.resourceSet == null) {
            return null;
        }
        URI convertedURI = this.resourceSet.getURIConverter().normalize(this.uri);
        return this.uri.equals((Object)convertedURI) ? null : this.getFile(convertedURI);
    }

    protected IFile getFile(URI fileURI) {
        if (!WorkbenchResourceHelperBase.isPlatformResourceURI((URI)fileURI)) {
            return null;
        }
        String fileName = URI.decode((String)fileURI.path()).substring("resource".length() + 1);
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
    }

    public IProject getProject() {
        return this.getFile().getProject();
    }

    public void modify(Runnable runnable) {
        try {
            runnable.run();
            try {
                this.save(Collections.EMPTY_MAP);
            }
            catch (IOException ex) {
                JptJpaCorePlugin.log(ex);
            }
        }
        catch (Exception ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)((Object)this), (Object)this.getURI());
    }

    public void addResourceModelListener(JptResourceModelListener listener) {
        this.resourceModelListenerList.add((EventListener)listener);
    }

    public void removeResourceModelListener(JptResourceModelListener listener) {
        this.resourceModelListenerList.remove((EventListener)listener);
    }

    protected void resourceModelChanged() {
        for (JptResourceModelListener listener : this.resourceModelListenerList.getListeners()) {
            listener.resourceModelChanged((JptResourceModel)this);
        }
    }

    protected void resourceModelReverted() {
        for (JptResourceModelListener listener : this.resourceModelListenerList.getListeners()) {
            listener.resourceModelReverted((JptResourceModel)this);
        }
    }

    protected void resourceModelUnloaded() {
        for (JptResourceModelListener listener : this.resourceModelListenerList.getListeners()) {
            listener.resourceModelUnloaded((JptResourceModel)this);
        }
    }

    public EList<Adapter> eAdapters() {
        return super.eAdapters();
    }

    public EList<EObject> getContents() {
        return super.getContents();
    }
}

